/*
 *	system.h
 *
 *	Type Definition & Function Prototype Declaration for "system.c"
 */

#ifdef	USEWAITPID
#define	Xwait(wp, opts)	waitpid(-1, wp, opts)
typedef int		wait_t;
# ifndef	WIFSTOPPED
# define	WIFSTOPPED(x)	(((x) & 0177) == WSTOPPED)
# endif
# ifndef	WIFSIGNALED
# define	WIFSIGNALED(x)	(((x) & 0177) != WSTOPPED \
				&& ((x) & 0177) != 0)
# endif
# ifndef	WIFEXITED
# define	WIFEXITED(x)	(((x) & 0177) == 0)
# endif
# ifndef	WCOREDUMP
# define	WCOREDUMP(x)	((x) & 0200))
# endif
# ifndef	WSTOPSIG
# define	WSTOPSIG(x)	((x) >> 8)
# endif
# ifndef	WTERMSIG
# define	WTERMSIG(x)	((x) & 0177)
# endif
# ifndef	WEXITSTATUS
# define	WEXITSTATUS(x)	((x) >> 8)
# endif
#else	/* !USEWAITPID */
#define	Xwait(wp, opts)	wait3(wp, opts, NULL)
typedef union wait	wait_t;
# ifndef	WIFSTOPPED
# define	WIFSTOPPED(x)	((x).w_stopval == WSTOPPED)
# endif
# ifndef	WIFSIGNALED
# define	WIFSIGNALED(x)	((x).w_stopval != WSTOPPED \
				&& (x).w_termsig != 0)
# endif
# ifndef	WIFEXITED
# define	WIFEXITED(x)	((x).w_stopval != WSTOPPED \
				&& (x).w_termsig == 0)
# endif
# ifndef	WCOREDUMP
# define	WCOREDUMP(x)	((x).w_coredump)
# endif
# ifndef	WSTOPSIG
# define	WSTOPSIG(x)	((x).w_stopsig)
# endif
# ifndef	WTERMSIG
# define	WTERMSIG(x)	((x).w_termsig)
# endif
# ifndef	WEXITSTATUS
# define	WEXITSTATUS(x)	((x).w_retcode)
# endif
#endif	/* !USEWAITPID */

typedef struct _redirectlist {
	int fd;
	char *filename;
	u_char type;
	int new;
	int old;
	struct _redirectlist *next;
} redirectlist;

#define	MD_NORMAL	000
#define	MD_READ		001
#define	MD_WRITE	002
#define	MD_RDWR		003
#define	MD_APPEND	004
#define	MD_FILEDESC	010
#define	MD_WITHERR	020
#define	MD_HEREDOC	040

typedef struct _command_t {
	hashlist *hash;
	int argc;
	char **argv;
	redirectlist *redp;
	u_char type;
	u_char id;
} command_t;

#define	CT_STATEMENT	001
#define	CT_NONE		002
#define	CT_BUILTIN	003
#define	CT_COMMAND	004
#define	CT_FUNCTION	005
#define	CT_ALIAS	006

#define	SM_IF		001
#define	SM_THEN		002
#define	SM_ELIF		003
#define	SM_ELSE		004
#define	SM_FI		005
#define	SM_WHILE	006
#define	SM_UNTIL	007
#define	SM_DO		010
#define	SM_DONE		011
#define	SM_FOR		012
#define	SM_IN		013
#define	SM_CASE		014
#define	SM_INCASE	015
#define	SM_RPAREN	016
#define	SM_CASEEND	017
#define	SM_ESAC		020
#define	SM_LPAREN	021
#define	SM_FUNC		022
#define	SM_LIST		023
#define	SM_LISTEND	024
#define	SM_ANOTHER	075
#define	SM_CHILD	076
#define	SM_STATEMENT	077

#define	isstatement(comm)	((comm) && (comm) -> type == CT_STATEMENT)
#define	notstatement(comm)	((comm) && (comm) -> type != CT_STATEMENT)
#define	isbuiltin(comm)		((comm) && (comm) -> type == CT_BUILTIN)
#define	iscommand(comm)		((comm) && (comm) -> type == CT_COMMAND)
#define	ischild(comm)		((comm) && (comm) -> type == CT_STATEMENT \
				&& (comm) -> id == SM_CHILD)

typedef struct _syntaxtree {
	command_t *comm;
	struct _syntaxtree *parent;
	struct _syntaxtree *next;
	u_char flags;
} syntaxtree;

#define	ST_TYPE	0007
#define	ST_CONT	0070
#define	ST_META	0010
#define	ST_QUOT	0020
#define	ST_STAT	0040
#define	ST_NODE	0100
#define	ST_NEXT	0200

#define	OP_FG	1
#define	OP_BG	2
#define	OP_AND	3
#define	OP_OR	4
#define	OP_PIPE	5

typedef struct _builtintable {
	int (*func)__P_((syntaxtree *));
	char *ident;
	u_char flags;
} builtintable;

#define	BT_NOGLOB	0001

#define	SMPREV	4
typedef struct _statementtable {
	int (*func)__P_((syntaxtree *));
	char *ident;
	u_char type;
	u_char prev[SMPREV];
} statementtable;

#define	STT_TYPE	0017
#define	STT_FOR		0001
#define	STT_CASE	0002
#define	STT_IN		0003
#define	STT_INCASE	0004
#define	STT_CASEEND	0005
#define	STT_LIST	0006
#define	STT_LPAREN	0007
#define	STT_FUNC	0010
#define	STT_NEEDLIST	0020
#define	STT_NEEDIDENT	0040
#define	STT_NEEDNONE	0100
#define	STT_NEEDCOMM	0200

typedef struct _opetable {
	u_char op;
	u_char level;
	char *symbol;
} opetable;

typedef struct _pipelist {
	char *file;
	FILE *fp;
	int fd;
	int new;
	int old;
	long pid;
	struct _pipelist *next;
} pipelist;

typedef struct _jobtable {
	long *pids;
	int *stats;
	int npipe;
	syntaxtree *trp;
} jobtable;

typedef struct _functable {
	char *ident;
	syntaxtree *func;
} functable;

typedef struct _aliastable {
	char *ident;
	char *comm;
} aliastable;

typedef struct _signaltable {
	int sig;
	int (*func)__P_((VOID_A));
	char *ident;
	char *mes;
	u_char flags;
} signaltable;

#define	TR_STAT		0007
#define	TR_IGN		0001
#define	TR_TERM		0002
#define	TR_STOP		0003
#define	TR_TRAP		0004
#define	TR_BLOCK	0010
#define	TR_NOTRAP	0020
#define	TR_CATCH	0040

typedef struct _ulimittable {
	u_char opt;
	int res;
	int unit;
	char *mes;
} ulimittable;

extern char *ifs_set;
extern char **shellvar;
extern char **envvar;

extern char *getshellvar __P_((char *, int));
extern int putshellvar __P_((char *, int));
extern int exec_line __P_((char *));
extern int dosystem __P_((char *));
extern FILE *dopopen __P_((char *));
extern int dopclose __P_((FILE *));
extern int execruncom __P_((char *));
extern int initshell __P_((int, char *[], char *[]));
