/*
 *	kctype.h
 *
 *	Kanji Code Type Macros
 */

#include <ctype.h>

#define	QUOTE		('^' - '@')
#define	C_BS		'\010'
#define	C_DEL		'\177'

#ifdef	LSI_C
#include <jctype.h>
#define	issjis1(c)	iskanji(c)
#define	issjis2(c)	iskanji2(c)
#define	isctl(c)	iscntrl(c)
#define	iskna(c)	iskana(c)
#else
#define	isctl(c)	((u_char)(c) < ' ' || (u_char)(c) == C_DEL)
#define	iskna(c)	((u_char)(c) >= 0xa1 && (u_char)(c) <= 0xdf)
#endif

#ifndef	issjis1
#define	issjis1(c)	(((u_char)(c) >= 0x81 && (u_char)(c) <= 0x9f) \
			|| ((u_char)(c) >= 0xe0 && (u_char)(c) <= 0xfc))
#endif
#ifndef	issjis2
#define	issjis2(c)	((u_char)(c) >= 0x40 && (u_char)(c) <= 0xfc \
			&& (u_char)(c) != 0x7f)
#endif

#ifndef	iseuc
#define	iseuc(c)	((u_char)(c) >= 0xa1 && (u_char)(c) <= 0xfe)
#endif

#define	isekana(s, i)	((u_char)((s)[i]) == 0x8e && iskna((s)[(i) + 1]))
#define	isskana(s, i)	iskna((s)[i])

#define	NOCNV	0
#define	ENG	1
#define	SJIS	2
#define	EUC	3
#define	JIS7	4
#define	O_JIS7	5
#define	JIS8	6
#define	O_JIS8	7
#define	JUNET	8
#define	O_JUNET	9
#define	HEX	10
#define	CAP	11

#ifdef	CODEEUC
#define	DEFCODE	EUC
#define	KANAWID	2
#else
#define	DEFCODE	SJIS
#define	KANAWID	1
#endif

#if	!MSDOS && !defined (_NOKANJICONV)
extern int inputkcode;
extern int fnamekcode;
#endif
#if	(!MSDOS && !defined (_NOKANJICONV)) \
|| (!defined (_NOENGMES) && !defined (_NOJPNMES))
extern int outputkcode;
#endif

#define	L_INPUT		0
#define	L_OUTPUT	1
#define	L_FNAME		2

#ifdef	CODEEUC
#define	iskanji1(s, i)	(iseuc((s)[i]) && iseuc((s)[(i) + 1]))
#else
#define	iskanji1(s, i)	(issjis1((s)[i]) && issjis2((s)[(i) + 1]))
#endif

#if	MSDOS
#define	isinkanji1(c)	issjis1(c)
#else	/* !MSDOS */

#ifdef	_NOKANJICONV
# ifdef	CODEEUC
# define	isinkanji1(c)	iseuc(c)
# else
# define	isinkanji1(c)	issjis1(c)
# endif
#else	/* !_NOKANJICONV */
#define	isinkanji1(c)	((inputkcode == EUC) ? iseuc(c) : issjis1(c))
#define	tobin(c)	(((u_char)(c) >= 'a' && (u_char)(c) <= 'f') \
			? (u_char)(c) - 'a' + 10 : \
			(((u_char)(c) >= 'A' && (u_char)(c) <= 'F') \
			? (u_char)(c) - 'A' + 10 : \
			(u_char)(c) - '0'))
#define	tohexa(c)	(((u_char)(c) >= 10) ? \
			(u_char)(c) + 'a' - 10 : (u_char)(c) + '0')
#define	tobin2(s, i)	(u_char)((tobin((s)[i]) << 4) | (tobin((s)[(i) + 1])))

#define	HEXTAG	':'
#define	HEXSTR	"0123456789abcdefABCDEF"
#define	ishex(s, i)	(((s)[i] == HEXTAG) \
			&& strchr(HEXSTR, (s)[(i) + 1]) \
			&& strchr(HEXSTR, (s)[(i) + 2]))
#define	CAPTAG	':'
#define	CAPSTR	"89abcdefABCDEF"
#define	iscap(s, i)	(((s)[i] == CAPTAG) \
			&& strchr(CAPSTR, (s)[(i) + 1]) \
			&& strchr(HEXSTR, (s)[(i) + 2]))

#endif	/* !_NOKANJICONV */
#endif	/* !MSDOS */
