/*
 *	checkid.c
 *
 *	calculate checksum for a file
 */

#include <stdio.h>

#ifdef	__STDC__
#define	__P_(args)	args
#else
#define	__P_(args)	()
#endif

#define	RMUL	11
#define	RADD	3
#define	CHRBITS	6
#define	CHRNUM	(1 << CHRBITS)
#define	STRSIZE	32
#define	SUMBITS	8
#define	SFTBITS	(11 % SUMBITS)
#define	SUMSIZE	((STRSIZE * CHRBITS + SUMBITS - 1) / SUMBITS)

static char *checkid __P_((FILE *));

static char chrtable[CHRNUM] = {
	'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
	'@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I',
	'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S',
	'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '_', 'a', 'b',
	'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l',
	'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v',
	'w', 'x', 'y', 'z'
};

static char *checkid(fp)
FILE *fp;
{
	static char str[STRSIZE + 1];
	unsigned char sum[SUMSIZE + 1];
	int c, i, n;

	sum[0] = 0x55;
	for (i = 0; i < SUMSIZE - 1; i++) sum[i + 1] = sum[i] * RMUL + RADD;
	while ((c = fgetc(fp)) != EOF) {
		n = sum[SUMSIZE - 1];
		for (i = SUMSIZE; i > 1; i--)
			sum[i] = (sum[i - 1] << SFTBITS)
				| (sum[i - 2] >> (SUMBITS - SFTBITS));
		sum[1] = (sum[0] << SFTBITS) | (n >> (SUMBITS - SFTBITS));
		sum[0] = sum[SUMSIZE];
		for (i = 0; i < SUMSIZE; i++) {
			if (sum[i] < (1 << SUMBITS) - c) {
				sum[i] += c;
				break;
			}
			sum[i] += c;
			c = 1;
		}
	}
	if (ferror(fp)) return(NULL);

	for (n = STRSIZE - 1; n >= 0; n--) {
		str[n] = chrtable[sum[0] & (CHRNUM - 1)];
		for (i = 0; i < SUMSIZE - 1; i++)
			sum[i] = (sum[i] >> CHRBITS)
				| (sum[i + 1] << (SUMBITS - CHRBITS));
		sum[i] = (sum[i] >> CHRBITS);
	}
	str[STRSIZE] = '\0';
	return(str);
}

int main(argc, argv)
int argc;
char *argv[];
{
	FILE *fp;
	int i;

	if (argc <= 1) {
		printf("ID = %s\t(<STDIN>)\n", checkid(stdin));
	}
	else for (i = 1; i < argc; i++) {
		if (!(fp = fopen(argv[i], "r"))) {
			printf("%s: cannot open.\n", argv[i]);
			continue;
		}
		printf("ID = %s\t(%s)\n", checkid(fp), argv[i]);
		fclose(fp);
	}

	return(0);
}
