/*
 *	ftp.h
 *
 *	definitions & function prototype declarations for "ftp.c"
 */

#include "dirent.h"
#include "namelist.h"
#include "socket.h"
#include "url.h"

#define	FTPNOFILE	16
#define	FTP_QUIT	"QUIT"
#define	FTP_USER	"USER"
#define	FTP_PASS	"PASS"
#define	FTP_CWD		"CWD"
#define	FTP_PWD		"PWD"
#define	FTP_TYPE	"TYPE"
#define	FTP_LIST	"LIST"
#define	FTP_NLST	"NLST"
#define	FTP_PORT	"PORT"
#define	FTP_PASV	"PASV"
#define	FTP_MDTM	"MDTM"
#define	FTP_SERVICE	"ftp"
#define	FTP_ANONUSER	"anonymous"
#define	FTP_ANONPASS	"fdclone@"

typedef struct _ftphost_t {
	int s;
	urlhost_t host;
	int options;
} ftphost_t;

#define	FFL_NOPASV	0001
#define	FFL_NOMDTM	0002
#define	FFL_NOPORT	0004
#define	FFL_RETRYPASV	0010
#define	FFL_RETRYPORT	0020
#define	FFL_VERBOSE	0100
#define	FFL_COPYMASK	0007

typedef struct _ftppath_t {
	namelist *list;
	int max;
	int fh;
	int nlink;
	char *path;
} ftppath_t;

extern int ftpparse __P_((CONST char *, char **));
extern int ftpopendev __P_((CONST char *));
extern int ftpclosedev __P_((int));
extern int ftpchdir __P_((int, CONST char *));
extern char *ftpgetcwd __P_((int, char *, ALLOC_T));
extern DIR *ftpopendir __P_((CONST char *, CONST char *));
extern int ftpclosedir __P_((DIR *));
extern struct dirent *ftpreaddir __P_((DIR *));
extern int ftpstat __P_((CONST char *, CONST char *, struct stat *));
extern int ftplstat __P_((CONST char *, CONST char *, struct stat *));

extern int ftpkcode;
