/*
 *	socket.h
 *
 *	definitions & function prototype declarations for "socket.c"
 */

#ifndef	__SOCKET_H_
#define	__SOCKET_H_

#ifdef	USESOCKLEN
#define	sock_len_t	socklen_t
#else
typedef int		sock_len_t;
#endif

typedef struct _sockdirdesc {
	int dd_id;
	int dd_fd;
	long dd_loc;
	long dd_size;
} sockDIR;

#define	SID_IFFTPDRIVE	(-2)
#define	SID_IFHTTPDRIVE	(-3)

#define	SCK_TOSTYPE	0007
#define	SCK_LOWDELAY	0001
#define	SCK_THROUGHPUT	0002
#define	SCK_RELIABILITY	0003
#define	SCK_MINCOST	0004
#define	SCK_NORMAL	0005
#define	SCK_KEEPALIVE	0010
#define	SCK_REUSEADDR	0020

extern int cmpsockport __P_((CONST char *, CONST char *));
extern int cmpsockaddr __P_((CONST char *, CONST char *));
extern int issocket __P_((int));
extern int getsockinfo __P_((int, u_char *, ALLOC_T));
extern int chgsockopt __P_((int, int));
extern int sockconnect __P_((CONST char *, int, CONST char *, int, int));
extern int sockreply __P_((int, int, u_char *, ALLOC_T, int));
extern int sockaccept __P_((int, int));
extern int sockwait __P_((CONST char *, int, int));
extern int sockfclose __P_((FILE *));

#endif	/* !__SOCKET_H_ */
