/*
 *	string.c
 *
 *	alternative string functions
 */

#include "headers.h"
#include "kctype.h"
#include "string.h"


char *strchr2(s, c)
CONST char *s;
int c;
{
	int i;

	for (i = 0; s[i]; i++) {
		if (s[i] == c) return((char *)&(s[i]));
		if (iskanji1(s, i)) i++;
#ifdef	CODEEUC
		else if (isekana(s, i)) i++;
#endif
	}

	return(NULL);
}

#ifndef	MINIMUMSHELL
char *strrchr2(s, c)
CONST char *s;
int c;
{
	int i;
	char *cp;

	cp = NULL;
	for (i = 0; s[i]; i++) {
		if (s[i] == c) cp = (char *)&(s[i]);
		if (iskanji1(s, i)) i++;
#ifdef	CODEEUC
		else if (isekana(s, i)) i++;
#endif
	}

	return(cp);
}

char *memchr2(s, c, n)
CONST char *s;
int c, n;
{
	int i;

	for (i = 0; i < n && s[i]; i++) {
		if (s[i] == c) return((char *)&(s[i]));
		if (iskanji1(s, i)) i++;
#ifdef	CODEEUC
		else if (isekana(s, i)) i++;
#endif
	}

	return(NULL);
}
#endif	/* !MINIMUMSHELL */

char *strcpy2(s1, s2)
char *s1;
CONST char *s2;
{
	int i;

	for (i = 0; s2[i]; i++) s1[i] = s2[i];
	s1[i] = '\0';

	return(&(s1[i]));
}

char *strncpy2(s1, s2, n)
char *s1;
CONST char *s2;
int n;
{
	int i;

	for (i = 0; i < n && s2[i]; i++) s1[i] = s2[i];
	s1[i] = '\0';

	return(&(s1[i]));
}

#ifdef	CODEEUC
int strlen2(s)
CONST char *s;
{
	int i, len;

	for (i = len = 0; s[i]; i++, len++) if (isekana(s, i)) i++;

	return(len);
}
#endif	/* CODEEUC */
