/*
 *	sysemu.h
 *
 *	definitions & function prototype declarations for "sysemu.c"
 */

#include "dirent.h"

#if	defined (FD) && !defined (_NODOSDRIVE)
#define	EMU_DOSDRIVE
#endif
#if	!MSDOS && defined (EMU_DOSDRIVE)
#define	EMU_DOSEMU
#endif
#if	MSDOS || defined (EMU_DOSDRIVE)
#define EMU_DOSPATH
#endif
#if	MSDOS && defined (FD) && !defined (_NOUSELFN)
#define	EMU_DOSLFN
#endif
#if	!defined (NOMULTIKANJI) && defined (FD) && !defined (_NOKANJIFCONV)
#define	EMU_KANJIPATH
#endif
#if	defined (FD) && !defined (_NOROCKRIDGE)
#define	EMU_ROCKRIDGE
#endif

#if	!MSDOS \
&& (defined (WITHNETWORK) || (defined (FD) && !defined (_NOFTP)))
#define	EMU_FTPPATH
#endif
#if	!MSDOS \
&& (defined (WITHNETWORK) || (defined (FD) && !defined (_NOHTTP)))
#define	EMU_HTTPPATH
#endif
#if	defined (EMU_FTPPATH) || defined (EMU_HTTPPATH)
#define	EMU_URLPATH
#endif

#if	defined (EMU_DOSDRIVE) || defined (EMU_DOSLFN) \
|| defined (EMU_KANJIPATH) || defined (EMU_ROCKRIDGE) || defined (EMU_URLPATH)
#define	EMU_PSEUDOPATH
#endif
#if	MSDOS || defined (EMU_PSEUDOPATH)
#define	EMU_DIRENT
#endif

#define	DEV_NORMAL		0
#define	DEV_DOS			1
#define	DEV_FTP			2
#define	DEV_HTTP		3

#if	MSDOS && defined (DJGPP)
extern int dos_putpath __P_((CONST char *, int));
#endif
#if	MSDOS && !defined (FD)
extern int getcurdrv __P_((VOID_A));
extern int setcurdrv __P_((int, int));
extern char *unixrealpath __P_((CONST char *, char *));
#endif
#ifdef	EMU_DOSPATH
extern int _dospath __P_((CONST char *));
extern int dospath __P_((CONST char *, char *));
#endif
#ifdef	EMU_URLPATH
extern int _urlpath __P_((CONST char *, char **, int *));
extern int urlpath __P_((CONST char *, char **, char *, int *));
#endif
#ifdef	EMU_DOSDRIVE
# if	MSDOS
extern int dospath2 __P_((CONST char *));
extern int dospath3 __P_((CONST char *));
# else
#define	dospath2(path)	dospath(path, NULL)
#define	dospath3(path)	dospath(path, NULL)
# endif
#endif	/* EMU_DOSDRIVE */
#if	defined (EMU_DIRENT)
extern DIR *Xopendir __P_((CONST char *));
extern int Xclosedir __P_((DIR *));
extern struct dirent *Xreaddir __P_((DIR *));
extern VOID Xrewinddir __P_((DIR *));
#else
#define Xopendir	opendir
#define Xclosedir	closedir
#define Xreaddir	readdir
#define Xrewinddir	rewinddir
#endif
#if	MSDOS
extern int rawchdir __P_((CONST char *));
#else
#define	rawchdir(p)	((chdir(p)) ? -1 : 0)
#endif
extern int Xchdir __P_((CONST char *));
extern char *Xgetwd __P_((char *));
#ifdef	EMU_DIRENT
extern int Xstat __P_((CONST char *, struct stat *));
extern int Xlstat __P_((CONST char *, struct stat *));
#else
#define Xstat(p, s)	((stat(p, s)) ? -1 : 0)
#define Xlstat(p, s)	((lstat(p, s)) ? -1 : 0)
#endif
#ifdef	EMU_PSEUDOPATH
extern int Xaccess __P_((CONST char *, int));
extern int Xsymlink __P_((CONST char *, CONST char *));
extern int Xreadlink __P_((CONST char *, char *, int));
extern int Xchmod __P_((CONST char *, int));
#else
#define Xaccess(p, m)	((access(p, m)) ? -1 : 0)
#define Xsymlink(o, n)	((symlink(o, n)) ? -1 : 0)
#define Xreadlink	readlink
#define Xchmod(p, m)	((chmod(p, m)) ? -1 : 0)
#endif
#ifdef	EMU_DIRENT
# ifdef	USEUTIME
extern int Xutime __P_((CONST char *, CONST struct utimbuf *));
# else
extern int Xutimes __P_((CONST char *, CONST struct timeval *));
# endif
#else
#define Xutime(p, t)	((utime(p, t)) ? -1 : 0)
#define Xutimes(p, t)	((utimes(p, t)) ? -1 : 0)
#endif
#ifdef	EMU_PSEUDOPATH
# ifdef	HAVEFLAGS
extern int Xchflags __P_((CONST char *, u_long));
# endif
# ifndef	NOUID
extern int Xchown __P_((CONST char *, uid_t, gid_t));
# endif
extern int Xunlink __P_((CONST char *));
extern int Xrename __P_((CONST char *, CONST char *));
extern int Xopen __P_((CONST char *, int, int));
#else	/* !EMU_PSEUDOPATH */
#define Xchflags(p, f)	((chflags(p, f)) ? -1 : 0)
#define Xchown(p, u, g)	((chown(p, u, g)) ? -1 : 0)
#define Xunlink(p)	((unlink(p)) ? -1 : 0)
#define Xrename(f, t)	((rename(f, t)) ? -1 : 0)
#define Xopen		open
#endif	/* !EMU_PSEUDOPATH */
#ifdef	EMU_DOSDRIVE
extern int Xclose __P_((int));
extern int Xread __P_((int, char *, int));
extern int Xwrite __P_((int, CONST char *, int));
extern off_t Xlseek __P_((int, off_t, int));
extern int Xftruncate __P_((int, off_t));
extern int Xdup __P_((int));
extern int Xdup2 __P_((int, int));
#else
#define	Xclose(f)	((close(f)) ? -1 : 0)
#define	Xread		read
#define	Xwrite		write
#define	Xlseek		lseek
#define	Xftruncate	ftruncate
#define	Xdup		safe_dup
#define	Xdup2		safe_dup2
#endif
extern int Xmkdir __P_((CONST char *, int));
#ifdef	EMU_PSEUDOPATH
extern int Xrmdir __P_((CONST char *));
extern FILE *Xfopen __P_((CONST char *, CONST char *));
#else
#define Xrmdir(p)	((rmdir(p)) ? -1 : 0)
#define Xfopen		fopen
#endif
#ifdef	EMU_DOSDRIVE
extern FILE *Xfdopen __P_((int, CONST char *));
extern int Xfclose __P_((FILE *));
extern int Xfileno __P_((FILE *));
extern int Xfeof __P_((FILE *));
extern int Xfread __P_((char *, int, int, FILE *));
extern int Xfwrite __P_((CONST char *, int, int, FILE *));
extern int Xfflush __P_((FILE *));
extern int Xfgetc __P_((FILE *));
extern int Xfputc __P_((int, FILE *));
extern char *Xfgets __P_((char *, int, FILE *));
extern int Xfputs __P_((CONST char *, FILE *));
#else
#define	Xfdopen		fdopen
#define	Xfclose		fclose
#define	Xfileno		fileno
#define	Xfeof		feof
#define	Xfread		fread
#define	Xfwrite		fwrite
#define	Xfflush		fflush
#define	Xfgetc		fgetc
#define	Xfputc		fputc
#define	Xfgets		fgets
#define	Xfputs		fputs
#endif
#if	defined (FD) && defined (_NOORIGSHELL)
# if	MSDOS
extern FILE *Xpopen __P_((CONST char *, CONST char *));
extern int Xpclose __P_((FILE *));
# else
#define	Xpopen		popen
#define	Xpclose		pclose
# endif
#endif	/* FD && _NOORIGSHELL */

#ifdef	EMU_DOSDRIVE
extern int lastdrv;
#endif
#ifdef	EMU_DOSEMU
extern int dosdrive;
#endif
#ifdef	EMU_FTPPATH
extern int lastftp;
#endif
#ifdef	EMU_HTTPPATH
extern int lasthttp;
#endif
#ifdef	EMU_URLPATH
extern int urldrive;
#endif
