/*
 *	url.c
 *
 *	URL parser
 */

#include "headers.h"
#include "printf.h"
#include "kctype.h"
#include "string.h"
#include "malloc.h"
#include "pathname.h"
#include "url.h"

static scheme_t schemelist[] = {
#define	DEFSCHEME(i, t)	{i, strsize(i), t}
	DEFSCHEME(SCHEME_FTP, TYPE_FTP),
	DEFSCHEME(SCHEME_HTTP, TYPE_HTTP),
	{NULL, 0, TYPE_UNKNOWN},
};


char *urldecode(s, len)
CONST char *s;
int len;
{
	char *cp;
	int i, j, n, c;

	if (len < 0) len = strlen(s);
	cp = malloc2(len + 1);

	for (i = j = 0; i < len; i++, j++) {
		if (s[i] == '%') {
			cp[j] = '\0';
			for (n = 1; n < 2; n++) {
				c = tolower2(s[i + n]);
				if (isdigit2(c)) c -= '0';
				else if (isxdigit2(c)) c -= 'a' - 10;
				else break;
				cp[j] = ((cp[j]) << 4) + c;
			}
			if (n >= 2) {
				i += 2;
				continue;
			}
		}
		cp[j] = s[i];
	}
	cp[j] = '\0';

	return(cp);
}

int urlgetscheme(s, scheme, hostp, typep)
CONST char *s;
scheme_t *scheme;
char **hostp;
int *typep;
{
	CONST char *cp, *path;
	int i, n;

	/*
	 * scheme://user:passwd@host:port/path;params?query#fragment
	 */

	if (!scheme) scheme = schemelist;
	if (!s) return(0);
	for (i = 0; scheme[i].ident; i++)
		if (!strncasecmp2(s, scheme[i].ident, scheme[i].len)) break;
	if (!(scheme[i].ident)) return(0);
	cp = &(s[scheme[i].len]);
	if (*(cp++) != ':' || *(cp++) != '/' || *(cp++) != '/') return(0);

	if ((path = strdelim(cp, 0))) {
		if (path == cp) return(0);
		if (hostp) *hostp = strndup2(cp, path - cp);
		n = path - s;
	}
	else {
		if (hostp) *hostp = strdup2(s);
		n = strlen(s);
	}
	if (typep) *typep = scheme[i].type;

	return(n);
}

VOID urlfreehost(hp)
urlhost_t *hp;
{
	free2(hp -> user);
	free2(hp -> pass);
	free2(hp -> host);
	hp -> user = hp -> pass = hp -> host = NULL;
	hp -> port = -1;
}

int urlgethost(s, hp)
CONST char *s;
urlhost_t *hp;
{
	CONST char *cp, *host, *user;
	int i, n, len, hlen, ulen;

	if ((host = strchr2(s, '@'))) {
		user = s;
		ulen = host++ - s;
	}
	else {
		ulen = 0;
		user = NULL;
		host = s;
	}

	n = 0;
	cp = (user) ? memchr2(user, ':', ulen) : NULL;
	if (!cp) hp -> pass = NULL;
	else {
		len = ulen - (cp - user) - 1;
		ulen = cp - user;
		if (len <= 0) hp -> pass = NULL;
		else if (!(hp -> pass = urldecode(++cp, len))) n = -1;
	}

	if (!(cp = strchr2(host, ':'))) {
		hlen = strlen(host);
		hp -> port = -1;
	}
	else {
		hlen = cp++ - host;
		if (!*cp) hp -> port = -1;
		else {
			i = 0;
			hp -> port = getnum(cp, &i);
			if (hp -> port < 0 || cp[i]) {
				errno = EINVAL;
				n = -1;
			}
		}
	}

	if (!host || hlen <= 0) hp -> host = NULL;
	else if (!(hp -> host = urldecode(host, hlen))) n = -1;
	if (!user || ulen <= 0) hp -> user = NULL;
	else if (!(hp -> user = urldecode(user, ulen))) n = -1;

	if (n < 0) {
		urlfreehost(hp);
		return(-1);
	}

	return(0);
}

int urlgetpath(s, pp)
CONST char *s;
urlpath_t *pp;
{
	CONST char *cp;

	if (!s || *s != _SC_) {
		errno = EINVAL;
		return(-1);
	}
	pp -> params = pp -> query = pp -> fragment = NULL;

	if (!(cp = strpbrk(s, ";?#"))) {
		pp -> path = strdup2(s);
		pp -> params = pp -> query = pp -> fragment = NULL;
		return(0);
	}
	pp -> path = strndup2(s, cp - s);
	s = &(cp[1]);

	if (*cp != ';') pp -> params = NULL;
	else {
		if (!(cp = strpbrk(s, "?#"))) {
			pp -> params = strdup2(s);
			pp -> query = pp -> fragment = NULL;
			return(0);
		}
		pp -> params = strndup2(s, cp - s);
		s = &(cp[1]);
	}

	if (*cp != '?') pp -> query = NULL;
	else {
		if (!(cp = strchr2(s, '#'))) {
			pp -> query = strdup2(s);
			pp -> fragment = NULL;
			return(0);
		}
		pp -> query = strndup2(s, cp - s);
		s = &(cp[1]);
	}

	if (*cp != '#') pp -> fragment = NULL;
	else pp -> fragment = strdup2(s);

	return(0);
}
