/*
 *	ftp.h
 *
 *	definitions & function prototype declarations for "ftp.c"
 */

#include "dirent.h"
#include "namelist.h"
#include "socket.h"
#include "url.h"

#define	FTPNOFILE	16
#define	FTP_ANONUSER	"anonymous"
#define	FTP_ANONPASS	"@"
#define	FTP_QUITTIMEOUT	3
#define	FTPDEBUG	"/var/tmp/ftp.log"

#define	FTP_QUIT	0
#define	FTP_USER	1
#define	FTP_PASS	2
#define	FTP_CWD		3
#define	FTP_PWD		4
#define	FTP_TYPE	5
#define	FTP_LIST	6
#define	FTP_NLST	7
#define	FTP_PORT	8
#define	FTP_PASV	9
#define	FTP_MDTM	10
#define	FTP_CHMOD	11
#define	FTP_DELE	12
#define	FTP_RNFR	13
#define	FTP_RNTO	14
#define	FTP_RETR	15
#define	FTP_STOR	16
#define	FTP_MKD		17
#define	FTP_RMD		18
#define	FTP_FEAT	19
#define	FTP_ASCII	"A"
#define	FTP_IMAGE	"I"

typedef struct _ftphost_t {
	FILE *fp;
	urlhost_t host;
	int nlink;
	int options;
} ftphost_t;

#define	FFL_NOPASV	00001
#define	FFL_NOPORT	00002
#define	FFL_NOMDTM	00004
#define	FFL_NOFEAT	00010
#define	FFL_RETRYPASV	00100
#define	FFL_RETRYPORT	00200
#define	FFL_LOCKED	01000
#define	FFL_INTRED	02000
#define	FFL_CLOSED	04000
#define	FFL_COPYMASK	00077

typedef struct _ftppath_t {
	namelist *list;
	int max;
	int fh;
	int nlink;
	char *path;
} ftppath_t;

extern VOID ftpfreestat __P_((int));
extern int ftpopendev __P_((CONST char *));
extern VOID ftpclosedev __P_((int));
extern int ftpchdir __P_((int, CONST char *));
extern char *ftpgetcwd __P_((int, char *, ALLOC_T));
extern DIR *ftpopendir __P_((CONST char *, CONST char *));
extern int ftpclosedir __P_((DIR *));
extern struct dirent *ftpreaddir __P_((DIR *));
extern VOID ftprewinddir __P_((DIR *));
extern int ftpstat __P_((CONST char *, CONST char *, struct stat *));
extern int ftplstat __P_((CONST char *, CONST char *, struct stat *));
extern int ftpaccess __P_((CONST char *, CONST char *, int));
extern int ftpreadlink __P_((CONST char *, CONST char *, char *, int));
extern int ftpchmod __P_((CONST char *, CONST char *, int));
extern int ftpunlink __P_((CONST char *, CONST char *));
extern int ftprename __P_((CONST char *, CONST char *, CONST char *));
extern int ftpopen __P_((CONST char *, CONST char *, int));
extern int ftpclose __P_((int));
extern int ftpdup2 __P_((int, int));
extern int ftpmkdir __P_((CONST char *, CONST char *));
extern int ftprmdir __P_((CONST char *, CONST char *));
extern int ftpallclose __P_((VOID_A));

extern char *ftpaddress;
extern char *ftpproxy;
extern char *ftplogfile;
extern int ftptimeout;
extern int ftpoptions;
extern int ftpkcode;
