/*
 *	http.c
 *
 *	HTTP module
 */

#ifdef	FD
#include "fd.h"
#else
#include "headers.h"
#include "depend.h"
#include "printf.h"
#include "kctype.h"
#include "malloc.h"
#endif

#include "termio.h"
#include "pathname.h"
#include "lsparse.h"
#include "http.h"

#if	!MSDOS && (!defined (FD) || !defined (_NOHTTP))

#define	MAXCMDLINE	255
#ifndef	HTTPDEBUG
#define	HTTPDEBUG	NULL
#endif

static int NEAR vhttplog __P_((CONST char *, va_list));
static int httplog __P_((CONST char *, ...));
static FILE *NEAR httpconnect __P_((urlhost_t *, int *));
static int NEAR _httpclosedev __P_((int));

char *httpproxy = NULL;
char *httplogfile = HTTPDEBUG;
int httptimeout = 0;
int httpoptions = 0;
int httpkcode = NOCNV;

static httphost_t httphostlist[HTTPNOFILE];
static int maxhttphost = 0;
static int httporder[HTTPNOFILE];

static char *form_http[] = {
	"%a, %d %b %Y %H:%M:%S %Z",	/* RFC 822 */
	"%A, %d-%b-%y %H:%M:%S %Z",	/* RFC 850 */
	"%a %b %e %H:%M:%S %Y",		/* asctime() */
	NULL
};


static int NEAR vhttplog(fmt, args)
CONST char *fmt;
va_list args;
{
	FILE *fp;
	int n;

	if (!httplogfile || !*httplogfile) return(0);
	if (!(fp = fopen(httplogfile, "a"))) return(-1);
	n = vfprintf2(fp, fmt, args);
	fclose(fp);

	return(n);
}

#ifdef	USESTDARGH
/*VARARGS1*/
static int httplog(CONST char *fmt, ...)
#else
/*VARARGS1*/
static int httplog(fmt, ...)
CONST char *fmt;
va_dcl;
#endif
{
	va_list args;
	int n;

	VA_START(args, fmt);
	n = vhttplog(fmt, args);
	va_end(args);

	return(n);
}

static FILE *NEAR httpconnect(hp, typep)
urlhost_t *hp;
int *typep;
{
	urlhost_t proxy;
	FILE *fp;
	char *cp;
	int s, type;

	proxy.user = proxy.pass = proxy.host = NULL;
	if (!urlgetscheme(httpproxy, NULL, &cp, &type)) /*EMPTY*/;
	else if (urlgethost(cp, &proxy) < 0) /*EMPTY*/;
	else if (!(proxy.host)) /*EMPTY*/;
	else {
		hp = &proxy;
		if (hp -> port < 0) hp -> port = urlgetport(type);
	}
	free2(cp);
	if (typep) *typep = (hp == &proxy) ? type : TYPE_UNKNOWN;

	s = sockconnect(hp -> host, hp -> port, httptimeout, SCK_LOWDELAY);
	urlfreehost(&proxy);
	if (s < 0) return(NULL);
	if (!(fp = fdopen(s, "r+"))) {
		safeclose(s);
		return(NULL);
	}

	return(fp);
}

int httpopendev(host)
CONST char *host;
{
	urlhost_t *hp, tmp;
	FILE *fp;
	int i, hh, type;

	if (urlgethost(host, &tmp) < 0) return(-1);
	if (!(tmp.host)) {
		urlfreehost(&tmp);
		return(seterrno(EINVAL));
	}
	if (tmp.port < 0) tmp.port = urlgetport(TYPE_HTTP);

	for (i = maxhttphost - 1; i >= 0; i--) {
		hh = httporder[i];
		if (tmp.port != httphostlist[hh].host.port) continue;
		if (cmpsockaddr(tmp.host, httphostlist[hh].host.host))
			continue;
		if (!(tmp.pass))
			tmp.pass = strdup2(httphostlist[hh].host.pass);
		break;
	}

	if (i >= 0) {
		hh = httporder[i];
		hp = &(httphostlist[hh].host);
	}
	else {
		hp = &tmp;
		if (maxhttphost > 0) {
			hh = httporder[0];
			urlfreehost(&(httphostlist[hh].host));
		}
		else {
			hh = 0;
			httphostlist[hh].host.user =
				httphostlist[hh].host.pass =
				httphostlist[hh].host.host = NULL;
		}
	}

	if (!(fp = httpconnect(hp, &type))) {
		if (hp == &tmp) urlfreehost(&tmp);
		return(-1);
	}

	httphostlist[hh].fp = fp;
	httphostlist[hh].options = (httpoptions & HFL_COPYMASK);
	if (hp == &tmp) memcpy((char *)&(httphostlist[hh].host),
		(char *)hp, sizeof(urlhost_t));
	if (hh >= maxhttphost) maxhttphost++;
	else {
		for (i = 0; i < maxhttphost; i++)
			if (httporder[i] == hh) break;
		if (i < maxhttphost - 1)
			memmove((char *)&(httporder[i]),
				(char *)&(httporder[i + 1]),
				(maxhttphost - i - 1) * sizeof(int));
	}
	httporder[maxhttphost - 1] = hh;

	return(hh);
}

static int NEAR _httpclosedev(hh)
int hh;
{
	int n;

	n = 0;
	if (httphostlist[hh].fp) {
		if (fclose(httphostlist[hh].fp) == EOF) n = -1;
		httphostlist[hh].fp = NULL;
	}

	return(n);
}

VOID httpclosedev(hh)
int hh;
{
	int duperrno;

	duperrno = errno;
	if (hh >= 0 && hh < maxhttphost) VOID_C _httpclosedev(hh);
	errno = duperrno;
}

int httpstat(host, path, stp)
CONST char *host, *path;
struct stat *stp;
{
	int hh;

	httplog("stat(\"%s\")\n", path);
	if ((hh = httpopendev(host)) < 0) return(-1);
	if (_httpclosedev(hh) < 0) return(-1);

	return(0);
}
#endif	/* !MSDOS && (!FD || !_NOHTTP) */
