/*
 *	http.h
 *
 *	definitions & function prototype declarations for "http.c"
 */

#include "dirent.h"
#include "socket.h"
#include "url.h"

#define	HTTPNOFILE	16
#define	HTTPDEBUG	"/var/tmp/http.log"

typedef struct _httphost_t {
	FILE *fp;
	urlhost_t host;
	int options;
} httphost_t;

#define	HFL_VERBOSE	0001
#define	HFL_RETRY	0010
#define	HFL_COPYMASK	0004

extern int httpopendev __P_((CONST char *));
extern VOID httpclosedev __P_((int));
extern int httpstat __P_((CONST char *, CONST char *, struct stat *));

extern char *httpproxy;
extern char *httplogfile;
extern int httptimeout;
extern int httpoptions;
extern int httpkcode;
