/*
 *	url.h
 *
 *	definitions & function prototype declarations for "url.c"
 */

#ifndef	__URL_H_
#define	__URL_H_
typedef struct _scheme_t {
	CONST char *ident;
	int len;
	int port;
	int type;
} scheme_t;

#define	SCHEME_FTP	"ftp"
#define	SCHEME_HTTP	"http"
#define	TYPE_UNKNOWN	0
#define	TYPE_FTP	1
#define	TYPE_HTTP	2

typedef struct _urlhost_t {
	char *user;
	char *pass;
	char *host;
	int port;
} urlhost_t;

typedef struct _urlpath_t {
	char *path;
	char *params;
	char *query;
	char *fragment;
} urlpath_t;

extern char *urldecode __P_((CONST char *, int));
extern char *urlencode __P_((CONST char *, int));
extern char *urlencode_path __P_((CONST char *, int));
extern char *urlencode_glob __P_((CONST char *, int));
extern int urlgetscheme __P_((CONST char *, scheme_t *, char **, int *));
extern int urlgetport __P_((int));
extern VOID urlfreehost __P_((urlhost_t *));
extern int urlgethost __P_((CONST char *, urlhost_t *));
extern int urlgetpath __P_((CONST char *, urlpath_t *));

#endif	/* !__URL_H_ */
