/*
 *	args.c
 *
 *	to Get Argument List
 */

#include "lipsf.h"
#include "var.h"

#define MAXARGS	256

typedef struct _argassoc {
	char *key;
	int num;
} argassoc;

static argassoc papertype[] = {
	{"a3", 12},
	{"a4", 14},
	{"a5", 16},
	{"hagaki", 18},
	{"b4", 24},
	{"b5", 26}
};
#define	N_PAPER	(sizeof(papertype) / sizeof(argassoc))
static argassoc castype[] = {
	{"a", 0},
	{"m", 1},
	{"l", 2},
	{"u", 3}
};
#define	N_CAS	(sizeof(castype) / sizeof(argassoc))
static argassoc landtype[] = {
	{"p", 0},
	{"l", 1}
};
#define	N_LAND	(sizeof(landtype) / sizeof(argassoc))
static argassoc fonttype[] = {
	{"m", 80},
	{"g", 81},
	{"r", 82}
};
#define	N_FONT	(sizeof(fonttype) / sizeof(argassoc))
static argassoc kanjitype[] = {
	{"s", SJIS},
	{"u", EUC},
	{"e", EUC},
	{"j", JIS}
};
#define	N_KANJI	(sizeof(kanjitype) / sizeof(argassoc))

u_char *styletitle;

extern char *optarg;
extern int optind;
extern int kanjicode;
extern int dpitable[];

#if	MSDOS
#define	strcasecmp2	stricmp
#define	strncasecmp2	strnicmp
#else
static int strcasecmp2 __P_((char *, char *));
static int strncasecmp2 __P_((char *, char *, int));
#endif
VOID varinit __P_((VOID_A));
VOID stackvar __P_((int));
VOID chgmaxlinecol __P_((VOID_A));
VOID chgwidheight __P_((VOID_A));
static int compareargs __P_((char *, argassoc [], int));
static int gettwoarg __P_((char *, int, int *, int *));
int trunclimit __P_((char *, int, int));
static int arrangeheadfoot __P_((char *));
long getrgb __P_((char *));
static int lips4extention __P_((char *));
VOID argfile __P_((char *));
int getarg __P_((int, char *[], int));

extern VOID error __P_((int));
extern VOID usage __P_((int));
extern char *strdup2 __P_((char *));
#if	MSDOS
extern int getopt __P_((int, char *[], char *));
#endif


#if	!MSDOS
static int strcasecmp2(s1, s2)
char *s1, *s2;
{
	int c1, c2;

	for (;;) {
		c1 = *(s1++);
		if (c1 >= 'a' && c1 <= 'z') c1 += 'A' - 'a';
		c2 = *(s2++);
		if (c2 >= 'a' && c2 <= 'z') c2 += 'A' - 'a';
		if (!c1 || c1 != c2) return(c1 - c2);
	}
}

static int strncasecmp2(s1, s2, n)
char *s1, *s2;
int n;
{
	int c1, c2;

	while (--n >= 0) {
		c1 = *(s1++);
		if (c1 >= 'a' && c1 <= 'z') c1 += 'A' - 'a';
		c2 = *(s2++);
		if (c2 >= 'a' && c2 <= 'z') c2 += 'A' - 'a';
		if (!c1 || c1 != c2) return(c1 - c2);
	}
	return(0);
}
#endif

VOID varinit(VOID_A)
{
	lipsmode	= LIPSMODE;
	cassette	= CASSETTE;
	islandscape	= ISLANDSCAPE;
	isvertical	= ISVERTICAL;
	fontpattern	= FONTPATTERN;
	papersize	= PAPERSIZE;
	usrlettersize	= AUTOVALUE;
	usrlineheight	= AUTOVALUE;
	usrcolumnwidth	= AUTOVALUE;
	printnum	= PRINTNUM;
	topmargin	= TOPMARGIN;
	bottommargin	= AUTOVALUE;
	leftmargin	= LEFTMARGIN;
	rightmargin	= AUTOVALUE;
	headerstr	= NULL;
	footerstr	= NULL;
	headermargin	= HEADERMARGIN;
	footermargin	= FOOTERMARGIN;
	usrmaxcolumns	= AUTOVALUE;
	usrmaxlines	= AUTOVALUE;
	tabposition	= TABPOSITION;
	isnewjis	= ISNEWJIS;
	isroman		= ISROMAN;
	isconcat	= ISCONCAT;
	overlaymode	= OVERLAYMODE;
	controlchar	= CONTROLCHAR;
	controlmode	= 0;
	iszerosup	= ISZEROSUP;
	iskanjinum	= ISKANJINUM;
	istoupper	= ISTOUPPER;
	istolower	= ISTOLOWER;
	paperwidth	= A4WIDTH;
	paperheight	= A4HEIGHT;
	maxsteps	= MAXSTEPS;
	stepcolumns	= AUTOVALUE;
	firstpage	= FIRSTPAGE;
	startpage	= AUTOVALUE;
	endpage		= AUTOVALUE;
	outputprinter	= LPRPRINTER;

	finemode	= FINEMODE;
	doubleside	= DOUBLESIDE;
	colormode	= COLORMODE;
	defcolor	= -1;

	widesize	= longsize	= broadsize	= topscript	=
	subscript	= underline	= doubleunder	= forcedchar	=
	italicchar	= amikake	= exclusive	= outline	=
	patternfill	= shadow	= kumimoji	= returnheight	=
	parentheses	= centering	= flushright	= leftindent	=
	rightindent	= iskinsoku	= iswordwrap	= isjustify	=
	isinfo		= 0;
}

VOID stackvar(push)
int push;
{
	static int d_isvertical;
	static int d_fontpattern;
	static int d_lettersize;
	static int d_lineheight;
	static int d_columnwidth;
	static int d_tabposition;
	static int d_isconcat;
	static int d_controlmode;
	
	static int d_iskinsoku;
	static int d_iswordwrap;
	static int d_isjustify;

	if (push) {
		d_isvertical	= isvertical;
		d_fontpattern	= fontpattern;
		d_lettersize	= usrlettersize;
		d_lineheight	= usrlineheight;
		d_columnwidth	= usrcolumnwidth;
		d_tabposition	= tabposition;
		d_isconcat	= isconcat;
		d_controlmode	= controlmode;

		d_iskinsoku	= iskinsoku;
		d_iswordwrap	= iswordwrap;
		d_isjustify	= isjustify;
	}
	else {
		isvertical	= d_isvertical;
		fontpattern	= d_fontpattern;
		usrlettersize	= d_lettersize;
		usrlineheight	= d_lineheight;
		usrcolumnwidth	= d_columnwidth;
		tabposition	= d_tabposition;
		isconcat	= d_isconcat;
		controlmode	= d_controlmode;

		widesize	= longsize	= broadsize	=
		topscript	= subscript	= underline	=
		doubleunder	= forcedchar	= italicchar	=
		amikake		= exclusive	= outline	=
		patternfill	= shadow	= kumimoji	=
		returnheight	= parentheses	= centering	=
		flushright	= leftindent	= rightindent	= 0;

		iskinsoku	= d_iskinsoku;
		iswordwrap	= d_iswordwrap;
		isjustify	= d_isjustify;

		chgmaxlinecol();
	}
}

VOID chgmaxlinecol(VOID_A)
{
	long max, width, height;
	int dpi, right, bottom;

	if (lipsmode >= 4) dpitable[lipsmode] = (finemode) ? 1200 : 600;
	dpi = dpitable[lipsmode];
	right = (rightmargin == AUTOVALUE) ? MINRIGHTMARGIN : rightmargin;
	bottom = (bottommargin == AUTOVALUE) ? MINBOTTOMMARGIN : bottommargin;
	lettersize = (usrlettersize == AUTOVALUE)
		? (LETTERSIZE * dpi) / 300 : usrlettersize;
	lineheight = (usrlineheight == AUTOVALUE)
		? (LINEHEIGHT * dpi) / 300 : usrlineheight;
	columnwidth = (usrcolumnwidth == AUTOVALUE)
		? (COLUMNWIDTH * dpi) / 300 : usrcolumnwidth;

	if (islandscape) {
		width = paperheight;
		height = paperwidth;
	}
	else {
		width = paperwidth;
		height = paperheight;
	}

	max = width - leftmargin - right;
	max *= 100;
	max *= dpi;
	max /= BASEINCH;
	max -= 4;
	dotprintwidth = (int)max;

	if ((columnwidth + lettersize / 2) <= 0) max = -1L;
	else {
		max += columnwidth;
		max /= columnwidth + lettersize / 2;
	}
	automaxcolumns = (int)max;

	if (max < 0L) realmaxcolumns = -1;
	else if (usrmaxcolumns == AUTOVALUE) realmaxcolumns = automaxcolumns;
	else if (usrmaxcolumns > (int)max) realmaxcolumns = (int)max;
	else realmaxcolumns = usrmaxcolumns;

	if (max < 0L) maxcolumns = autostepcolumns = -1;
	else if (maxsteps <= 1) maxcolumns = realmaxcolumns;
	else {
		max /= maxsteps;
		if (usrmaxcolumns == AUTOVALUE) autostepcolumns = (int)max;
		else autostepcolumns = usrmaxcolumns / maxsteps;
		if (stepcolumns == AUTOVALUE) maxcolumns = autostepcolumns;
		else if (stepcolumns > (int)max) maxcolumns = (int)max;
		else maxcolumns = stepcolumns;
	}

	max = height - topmargin - bottom;
	max *= 100;
	max *= dpi;
	max /= BASEINCH;
	dotprintheight = max;

	if (lineheight + lettersize <= 0) max = -1L;
	else {
		max = height - topmargin - bottom;
		if (headerstr) max -= headermargin;
		if (footerstr) max -= footermargin;
		max *= 100;
		max *= dpi;
		max /= BASEINCH;
		if (headerstr) max -= lettersize;
		if (footerstr) max -= lettersize;
		max += lineheight;
		max /= lineheight + lettersize;
	}
	automaxlines = (int)max;

	if (max < 0L) maxlines = -1;
	else if (usrmaxlines == AUTOVALUE) maxlines = automaxlines;
	else if (usrmaxlines > (int)max) maxlines = (int)max;
	else maxlines = usrmaxlines;
}

VOID chgwidheight(VOID_A)
{
	switch (papersize) {
		case 12:
			paperwidth = A3WIDTH;
			paperheight = A3HEIGHT;
			break;
		case 14:
			paperwidth = A4WIDTH;
			paperheight = A4HEIGHT;
			break;
		case 16:
			paperwidth = A5WIDTH;
			paperheight = A5HEIGHT;
			break;
		case 18:
			paperwidth = HAGAKIWIDTH;
			paperheight = HAGAKIHEIGHT;
			break;
		case 24:
			paperwidth = B4WIDTH;
			paperheight = B4HEIGHT;
			break;
		case 26:
			paperwidth = B5WIDTH;
			paperheight = B5HEIGHT;
			break;
		default:
			break;
	}
}

static int compareargs(arg, table, n)
char *arg;
argassoc table[];
int n;
{
	int i;

	for (i = 0; i < n; i++) {
		if (table[i].key[1]) {
			if (!strcasecmp2(arg, table[i].key)) break;
		}
		else if (!strncasecmp2(arg, table[i].key, 1)) break;
	}
	if (i >= n) return(-1);
	return(table[i].num);
}

static int gettwoarg(str, ch, x, y)
char *str;
int ch, *x, *y;
{
	char *cp = str;
	int tmp = 2;

	while (isdigit(*cp)) cp++;
	if (cp != str) *x = atoi(str);
	else tmp = 0;
	if (*cp == '\0') return(1);
	else if (*cp != ch) return(-1);
	str = ++cp;
	while (isdigit(*cp)) cp++;
	if (cp != str) *y = atoi(str);
	else tmp = 0;
	if (*cp != '\0') return(-1);
	return(tmp);
}

int trunclimit(arg, min, max)
char *arg;
int min, max;
{
	int tmp;

	tmp = (arg && *arg) ? atoi(arg) : 0;
	if (tmp < min) tmp = min;
	else if (tmp > max) tmp = max;
	return(tmp);
}

static int arrangeheadfoot(arg)
char *arg;
{
	switch (*arg) {
		case 'H':
			headermargin = trunclimit(arg + 1,
				MINHEADERMARGIN, MAXHEADERMARGIN);
			break;
		case 'F':
			footermargin = trunclimit(arg + 1,
				MINFOOTERMARGIN, MAXFOOTERMARGIN);
			break;
		case 'z':
			iszerosup = 1;
			break;
		case 'k':
			iskanjinum = 1;
			break;
		case 'U':
			istoupper = 1;
			break;
		case 'L':
			istolower = 1;
			break;
		default:
			error(EINVAL);
			return(0);
/*NOTREACHED*/
			break;
	}

	return(1);
}

long getrgb(s)
char *s;
{
	long l;
	int i;

	l = -1L;

	if (!s || !*s);
	else if (isdigit(*s)) l = *s - '0';
	else if (*s == '%') {
		i = atoi(s + 1);
		if (i >= 0 && i <= 100) l = (i | 0x02000000L);
	}
	else if (*s == '#') {
		s++;
		for (i = l = 0; i < 6 && s[i]; i++) {
			l *= 16;
			if (s[i] >= '0' && s[i] <= '9') l += s[i] - '0';
			else if (s[i] >= 'a' && s[i] <= 'f')
				l += s[i] - 'a' + 10;
			else if (s[i] >= 'A' && s[i] <= 'F')
				l += s[i] - 'A' + 10;
			else break;
		}
		l |= 0x01000000L;
	}

	return(l);
}

static int lips4extention(arg)
char *arg;
{
	switch (*arg) {
		case 'f':
			finemode = 1;
			break;
		case 'd':
			doubleside = 1;
			break;
		case 'c':
			colormode = 1;
			defcolor = getrgb(arg + 1);
			break;
		default:
			error(EINVAL);
			return(0);
/*NOTREACHED*/
			break;
	}

	return(1);
}

VOID argfile(filename)
char *filename;
{
	FILE *fp;
	int argc = 1;
	char *argv[MAXARGS];
	char *argbuf, *argbuf2;
	struct stat buf;
	int i, j, inarg, quote, bslash;
	int c;

	if (!(fp = fopen(filename, "r"))) error(-1);
	if (fstat(fileno(fp), &buf)) error(-1);
	if (!buf.st_size) {
		fclose(fp);
		return;
	}

	if (!(argbuf = (char *)malloc(buf.st_size + 1))) error(-1);
	if (!(argbuf2 = (char *)malloc(buf.st_size + 1))) error(-1);
	if (!(i = fread(argbuf, sizeof(char), buf.st_size, fp))) {
		error(errno);
		return;
	}
	fclose(fp);

	argbuf[i] = '\0';
	inarg = quote = bslash = 0;
	styletitle = NULL;
	i = 0;

	if (*argbuf == ';') {
		do i++;
		while (argbuf[i] && argbuf[i] != '\n');
		if (i > 1) {
			if (!(styletitle = (u_char *)malloc(i))) error(-1);
			strncpy(styletitle, argbuf + 1, i - 1);
			styletitle[i - 1] = '\0';
		}
	}
	for (j = 0; (c = argbuf[i]); i++) {
		if (bslash) {
			bslash = 0;
			if (!inarg) argv[argc++] = &argbuf2[j];
			argbuf2[j++] = c;
			inarg = 1;
		}
		else switch(c) {
			case '\n':
				if (quote) {
					if (!inarg) argv[argc++] = &argbuf2[j];
					argbuf2[j++] = '\0';
				}
				else if (inarg) argbuf2[j++] = '\0';
				inarg = quote = 0;

				if (argbuf[i + 1] == ';') {
					i++;
					do i++;
					while (argbuf[i] && argbuf[i] != '\n');
					i--;
				}
				break;
			case '\t':
			case ' ':
				if (quote) {
					if (!inarg) argv[argc++] = &argbuf2[j];
					argbuf2[j++] = c;
					inarg = 1;
				}
				else {
					if (inarg) argbuf2[j++] = '\0';
					inarg = quote = 0;
				}
				break;
			case '\\':
				bslash = 1;
				break;
			case '\"':
				if (!quote) quote = 1;
				else {
					if (!inarg) argv[argc++] = &argbuf2[j];
					inarg = 1;
					quote = 0;
				}
				break;
			default:
				if (!inarg) argv[argc++] = &argbuf2[j];
				argbuf2[j++] = c;
				inarg = 1;
				break;
		}
	}
	argbuf2[j] = '\0';
	argv[0] = filename;
#ifdef	DEBUG
	for (i = 0; i < argc; i++) {
	fprintf(stderr, "[");
	for (j = 0; j < strlen(argv[i]); j++)
		if (isprint(argv[i][j])) fputc(argv[i][j], stderr);
	fprintf(stderr, "]\n");
	}
#endif
	getarg(argc, argv, 1);
	free(argbuf);
}

int getarg(argc, argv, recurse)
int argc;
char *argv[];
int recurse;
{
	int c, i;

	optarg = NULL;
	optind = 1;
	if (!recurse) varinit();

	while ((c = getopt(argc, argv,
	"p:m:d:f:J:s:h:w:C:N:A:#:t:c:l:T:B:L:R:H:F:O:S:r:P:vjakKi234X:@:?")
	) != EOF)
	switch (c) {
		case 'p':
			if ((i = compareargs(optarg, papertype, N_PAPER)) >= 0)
				papersize = i;
			else if (gettwoarg(optarg, 'x',
				&paperwidth, &paperheight) == 2) {
				papersize = 80;
				if (paperwidth < MINPAPERWIDTH)
					paperwidth = MINPAPERWIDTH;
				else if (paperwidth > MAXPAPERWIDTH)
					paperwidth = MAXPAPERWIDTH;
				if (paperheight < MINPAPERHEIGHT)
					paperheight = MINPAPERHEIGHT;
				else if (paperheight > MAXPAPERHEIGHT)
					paperheight = MAXPAPERHEIGHT;
			}
			else {
				error(EINVAL);
				return(0);
			}
			chgwidheight();
			break;
		case 'm':
			if ((i = compareargs(optarg, castype, N_CAS)) >= 0)
				cassette = i;
			else {
				error(EINVAL);
				return(0);
			}
			break;
		case 'd':
			if ((i = compareargs(optarg, landtype, N_LAND)) >= 0)
				islandscape = i;
			else {
				error(EINVAL);
				return(0);
			}
			break;
		case 'f':
			if ((i = compareargs(optarg, fonttype, N_FONT)) >= 0)
				fontpattern = i;
			else {
				error(EINVAL);
				return(0);
			}
			break;
		case 's':
			usrlettersize = trunclimit(optarg,
				MINLETTERSIZE, MAXLETTERSIZE);
			break;
		case 'h':
			usrlineheight = trunclimit(optarg,
				MINLINEHEIGHT, MAXLINEHEIGHT);
			break;
		case 'w':
			usrcolumnwidth = trunclimit(optarg,
				MINCOLUMNWIDTH, MAXCOLUMNWIDTH);
			break;
		case 'C':
			controlmode = 1;
#if	MSDOS
			if (optarg[0] == '\\' && optarg[1]) optarg++;
#endif
			if (!optarg[0] || optarg[1]) {
				error(EINVAL);
				return(0);
			}
			controlchar = *optarg;
			break;
		case 'N':
#if	MSDOS
			if (strncasecmp2(optarg, "lpt", 3)
			|| optarg[3] < '1' || optarg[3] > '9' || optarg[4]) {
				error(EINVAL);
				return(0);
			}
#endif
			if (!(outputprinter = strdup2(optarg))) error(-1);
			break;
		case 'A':
			if (!arrangeheadfoot(optarg)) return(0);
			break;
		case 'J':
			if ((i = compareargs(optarg, kanjitype, N_KANJI)) >= 0)
				kanjicode = i;
			else {
				error(EINVAL);
				return(0);
			}
			break;
		case '#':
			printnum = trunclimit(optarg,
				MINPRINTNUM, MAXPRINTNUM);
			break;
		case 't':
			tabposition = trunclimit(optarg,
				MINTABPOSITION, MAXTABPOSITION);
			break;
		case 'c':
			usrmaxcolumns = trunclimit(optarg,
				MINMAXCOLUMNS, MAXMAXCOLUMNS);
			break;
		case 'l':
			usrmaxlines = trunclimit(optarg,
				MINMAXLINES, MAXMAXLINES);
			break;
		case 'T':
			topmargin = trunclimit(optarg,
				MINTOPMARGIN, MAXTOPMARGIN);
			break;
		case 'B':
			bottommargin = trunclimit(optarg,
				MINBOTTOMMARGIN, MAXBOTTOMMARGIN);
			break;
		case 'L':
			leftmargin = trunclimit(optarg,
				MINLEFTMARGIN, MAXLEFTMARGIN);
			break;
		case 'R':
			rightmargin = trunclimit(optarg,
				MINRIGHTMARGIN, MAXRIGHTMARGIN);
			break;
		case 'H':
			if (!(headerstr = (u_char *)strdup2(optarg)))
				error(-1);
			break;
		case 'F':
			if (!(footerstr = (u_char *)strdup2(optarg)))
				error(-1);
			break;
		case 'O':
			overlaymode = atoi(optarg);
			if (overlaymode < 0 || overlaymode > 5)
				overlaymode = OVERLAYMODE;
			break;
		case 'S':
			if (gettwoarg(optarg, ',', &maxsteps, &i) == 2) {
				stepcolumns = i;
				if (stepcolumns < MINSTEPCOLUMNS)
					stepcolumns = MINSTEPCOLUMNS;
				else if (stepcolumns > MAXSTEPCOLUMNS)
					stepcolumns = MAXSTEPCOLUMNS;
			}
			if (maxsteps < MINMAXSTEPS) maxsteps = MINMAXSTEPS;
			else if (maxsteps > MAXMAXSTEPS)
				maxsteps = MAXMAXSTEPS;
			break;
		case 'r':
			if (gettwoarg(optarg, '-', &startpage, &endpage) == 1)
				endpage = startpage;
			if (startpage < MINSTARTPAGE) startpage = AUTOVALUE;
			else if (startpage > MAXSTARTPAGE)
				startpage = MAXSTARTPAGE;
			else startpage--;
			if (endpage < MINENDPAGE) endpage = AUTOVALUE;
			else if (endpage > MAXENDPAGE) endpage = MAXENDPAGE;
			else endpage--;
			break;
		case 'P':
			firstpage = trunclimit(optarg,
				MINFIRSTPAGE, MAXFIRSTPAGE);
			break;
		default:
			switch (c) {
				case 'v':
					isvertical = 4;
					break;
				case 'j':
					isnewjis = 0;
					break;
				case 'a':
					isroman = 0;
					break;
				case 'k':
					isconcat = 1;
					break;
				case 'K':
					iskinsoku = 1;
					break;
				case 'i':
					isinfo = 1;
					break;
				case '2':
				case '3':
				case '4':
					lipsmode = c - '0';
					break;
				case 'X':
					if (!lips4extention(optarg)) return(0);
					break;
				case '@':
					if (recurse) {
						error(EMFILE);
						return(0);
					}
					c = optind;
					optind = 1;
					argfile(optarg);
					optind = c;
					break;
				case '?':
					usage(0);
					return(0);
/*NOTREACHED*/
					break;
				default :
					error(EINVAL);
					return(0);
/*NOTREACHED*/
					break;
			}
			break;
	}

	if (!recurse) chgmaxlinecol();
	else if (optind != argc) error(EINVAL);
	return(optind);
}
