/*
 *	file.c
 *
 *	File Access Module
 */

#include "lipsf.h"
#include "term.h"
#include "kanji.h"
#include <time.h>

#if	MSDOS
#include <dos.h>
#include <direct.h>
#include <process.h>
extern char *strrdelim __P_((char *));
#define	MAXNAMLEN	255
#define	MAXPATHLEN	260
#define	FILEPERLINE	5
#else
#ifdef	USEDIRECT
#include <sys/dir.h>
#else
#include <dirent.h>
#endif
#include <pwd.h>
#include <grp.h>
#include <sys/param.h>
#define	strrdelim(s)	strrchr(s, _SC_)
#define	FILEPERLINE	2
#endif
#define	FILEPERLOW	(n_line - 4)
#define	FILEPERPAGE	(FILEPERLINE * FILEPERLOW)

typedef struct _namelist {
	char *name;
	unsigned short st_mode;
#if	!MSDOS
	short st_nlink;
	uid_t st_uid;
	gid_t st_gid;
#endif
	off_t st_size;
	time_t st_mtim;
	int no;
	u_char isdir;
	struct _namelist *prev;
	struct _namelist *next;
} namelist;

static int isdelim __P_((char *, int));
char *getworkdir __P_((VOID_A));
#if	MSDOS
VOID initdir __P_((int));
#endif
static int searchdir __P_((char *));
VOID system2 __P_((char *, char *));
int system3 __P_((char *, char *));
#ifndef	PAGER
static VOID dump __P_((char *));
#endif
static VOID getstatus __P_((char *, namelist *));
static namelist *newlist __P_((namelist *));
static namelist *addlist __P_((namelist *, char *, int, int));
static namelist *swaplist __P_((namelist *, namelist *));
static namelist *sortlist __P_((namelist *));
static VOID pathbar __P_((VOID_A));
static VOID helpbar __P_((VOID_A));
static VOID statusbar __P_((namelist *));
static VOID stylebar __P_((namelist *));
static VOID calclocate __P_((int));
static VOID putname __P_((int, char *, int, int));
static namelist *listupfile __P_((namelist *, char *));
static int selectfile __P_((char *, char *, char *, int));
char *getfilename __P_((char *, char *, int));

extern VOID error __P_((int));
extern VOID title __P_((VOID_A));
extern char *strdup2 __P_((char *));
extern char *inputstr2 __P_((char *));
extern int yesno __P_((char *));
extern int warning __P_((int, char *));


static int isdelim(s, ptr)
char *s;
int ptr;
{
#if	MSDOS
	int i;
#endif

	if (ptr < 0 || s[ptr] != _SC_) return(0);
#if	MSDOS
	if (--ptr < 0) return(1);
	if (!ptr) return(!issjis1((u_char)(s[0])));

	for (i = 0; s[i] && i < ptr; i++) if (issjis1((u_char)(s[i]))) i++;
	if (!s[i] || i > ptr) return(1);
	return(!issjis1((u_char)(s[i])));
#else
	return(1);
#endif
}

char *getworkdir(VOID_A)
{
	char cwd[MAXPATHLEN + 1];
	char *dup;

#ifdef	USEGETWD
	if (!getwd(cwd)) error(-1);
#else
	if (!getcwd(cwd, MAXPATHLEN)) error(-1);
#endif
	if (!(dup = strdup2(cwd))) error(-1);
	return(dup);
}

#if	MSDOS
VOID initdir(get)
int get;
{
	static unsigned drv;
	static char *path = NULL;
	unsigned dammy;

	if (get) {
		if (path) free(path);
		_dos_getdrive(&drv);
		path = getworkdir();
	}
	else {
		_dos_setdrive(drv, &dammy);
		chdir(path);
	}
}

static int searchdir(file)
char *file;
{
	static struct find_t _findbuf;
	static int eof = 1;
	struct find_t *findbuf = &_findbuf;

	if (eof) eof = _dos_findfirst("*.*", _A_NORMAL | _A_SUBDIR, findbuf);
	else eof = _dos_findnext(findbuf);
	if (eof) return(-1);

	strcpy(file, findbuf -> name);
	return((findbuf -> attrib & _A_SUBDIR) ? 1 : 0);
}

#else	/* MSDOS */

static int searchdir(file)
char *file;
{
	static DIR *dirp = NULL;
	struct dirent *findbuf;
	struct stat status;

	if (!dirp) dirp = opendir(".");
	if (!(findbuf = readdir(dirp))) {
		closedir(dirp);
		dirp = NULL;
		return(-1);
	}

	strcpy(file, findbuf -> d_name);
	stat(findbuf -> d_name, &status);
	return(((status.st_mode & S_IFMT) == S_IFDIR) ? 1 : 0);
}

#endif	/* MSDOS */

VOID system2(command, arg)
char *command, *arg;
{
	char *tmp;

	if (!(tmp = (char *)malloc(strlen(command) + strlen(arg) + 2)))
		error(-1);
	strcpy(tmp, command);
	strcat(tmp, " ");
	strcat(tmp, arg);

	locate(0, n_line - 1);
	putterm(l_clear);
	tflush();
	putterms(t_end);
	putterms(t_nokeypad);
	tflush();

	cooked2();
	echo2();
	nl2();
	tabs();
	system(tmp);
	raw2();
	noecho2();
	nonl2();
	notabs();

	putterms(t_init);
	putterms(t_keypad);
}

int system3(env, arg)
char *env, *arg;
{
	char *command;

	if (!(command = (char *)getenv(env))) return(0);
	system2(command, arg);
	return(1);
}

#ifndef	PAGER
static VOID dump(file)
char *file;
{
	FILE *fp;
	char buf[82], *prompt;
	int i;

	if (!(prompt = (char *)malloc(strlen(file) + 21))) error(-1);
	strcpy(prompt, file);
	strcat(prompt, NEXT_K);

	if (!(fp = fopen(file, "r"))) error(-1);

	i = 0;
	while (fgets(buf, 81, fp)) {
		locate(0, i);
		putterm(l_clear);
		cputs2(buf);
		if (++i >= FILEPERLOW + 2) {
			i = 0;
			if (!yesno(prompt)) break;
		}
	}

	if (feof(fp)) {
		for (;i < FILEPERLOW + 2; i++) {
			locate(0, i);
			putterm(l_clear);
		}
	}

	fclose(fp);
}
#endif

static VOID getstatus(file, namep)
char *file;
namelist *namep;
{
	struct stat status;

#if	MSDOS
	if (!strcmp(file, "..")) file = ".";
	if (stat(file, &status)) error(-1);
#else
	if (lstat(file, &status)) error(-1);
#endif

	namep -> st_mode = status.st_mode;
#if	!MSDOS
	namep -> st_nlink = status.st_nlink;
	namep -> st_uid = status.st_uid;
	namep -> st_gid = status.st_gid;
#endif
	namep -> st_size = status.st_size;
	namep -> st_mtim = status.st_mtime;
}

static namelist *newlist(prev)
namelist *prev;
{
	namelist *newp;
	if (!(newp = (namelist *)malloc(sizeof(namelist)))) error(-1);
	newp -> prev = prev;
	newp -> next = NULL;
	return(newp);
}

static namelist *addlist(endp, name, no, c)
namelist *endp;
char *name;
int no, c;
{
	namelist *newp;

	newp = newlist(endp);
	if (!(endp -> name = strdup2(name))) error(-1);
	if (c < 2) getstatus(name, endp);
	endp -> no = no;
	endp -> isdir = c;
	endp -> next = newp;
	return(newp);
}

static namelist *swaplist(namep1, namep2)
namelist *namep1, *namep2;
{
	namelist *np1, *np2;
	int i;

	i = namep1 -> no;
	namep1 -> no = namep2 -> no;
	namep2 -> no = i;

	np1 = namep1 -> next;
	np2 = namep2 -> next;

	namep1 -> next = np2;
	namep2 -> next = np1;
	if (np1) np1 -> prev = namep2;
	if (np2) np2 -> prev = namep1;

	np1 = namep1 -> prev;
	np2 = namep2 -> prev;

	namep1 -> prev = np2;
	namep2 -> prev = np1;
	if (np1) np1 -> next = namep2;
	if (np2) np2 -> next = namep1;

	if (!np1) return(namep2);
	else if (!np2) return(namep1);
	else return(NULL);
}

static namelist *sortlist(startp)
namelist *startp;
{
	namelist *np1, *np2, *prev, *next, *topp;

	prev = NULL;

	np1 = (startp -> isdir < 2) ? startp : startp -> next;
	while (np1 -> next) {
		np2 = np1 -> next;
		while (np2) {
			next = np2 -> next;
			if ((!np1 -> isdir && np2 -> isdir)
			|| (np1 -> isdir == np2 -> isdir
			&& strcmp(np1 -> name, np2 -> name) > 0)) {
				topp = swaplist(np1, np2);
				if (topp) startp = topp;
				np1 = (prev) ? prev -> next : startp;
			}
			np2 = next;
		}
		prev = np1;
		np1 = np1 -> next;
	}

	return(startp);
}

static VOID pathbar(VOID_A)
{
	char *path;

	path = getworkdir();
	if (strlen(path) > 73) path[73] = '\0';

	locate(0, 1);
	putterm(l_clear);
	cputs2("  ");
	putterm(t_standout);
	cputs2("PATH:");
	putterm(end_standout);
	cputs2(path);
	free(path);

	tflush();
}

static VOID helpbar(VOID_A)
{
	locate(0, FILEPERLOW + 2);

	cputs2("  ");
	putterm(t_standout);
#if	!MSDOS
	cputs2("       ");
#endif
	cputs2(HELP1_K);
	cputs2(HELP2_K);
	cputs2(HELP3_K);
#if	MSDOS
	cputs2(HELP4_K);
#else
	cputs2("        ");
#endif
	putterm(end_standout);
	cputs2("  ");

	tflush();
}

static VOID statusbar(namep)
namelist *namep;
{
	char buf[11];
	struct tm *timep;
#if	!MSDOS
	struct passwd *uid;
	struct group *gid;
#endif

	locate(0, FILEPERLOW + 3);

	if (namep -> isdir > 1) {
		putterm(l_clear);
		return;
	}

	timep = localtime(&namep -> st_mtim);
#if	!MSDOS
	uid = getpwuid(namep -> st_uid);
	gid = getgrgid(namep -> st_gid);
#endif

	strcpy(buf, "----------");
	switch(namep -> st_mode & S_IFMT) {
		case S_IFDIR:
			buf[0] = 'd';
			break;
#if	!MSDOS
		case S_IFBLK:
			buf[0] = 'b';
			break;
		case S_IFCHR:
			buf[0] = 'c';
			break;
		case S_IFLNK:
			buf[0] = 'l';
			break;
		case S_IFSOCK:
			buf[0] = 's';
			break;
		case S_IFIFO:
			buf[0] = 'p';
			break;
#endif
		default:
			break;
	}

#if	MSDOS
	if (namep -> st_mode & S_IREAD) buf[1] = buf[4] = buf[7] = 'r';
	if (namep -> st_mode & S_IWRITE) buf[2] = buf[5] = buf[8] = 'w';
	if (namep -> st_mode & S_IEXEC) buf[3] = buf[6] = buf[9] = 'x';
#else
	if (namep -> st_mode & S_IRUSR) buf[1] = 'r';
	if (namep -> st_mode & S_IWUSR) buf[2] = 'w';
	if (namep -> st_mode & S_ISUID) buf[3] = 's';
	else if (namep -> st_mode & S_IXUSR) buf[3] = 'x';
	if (namep -> st_mode & S_IRGRP) buf[4] = 'r';
	if (namep -> st_mode & S_IWGRP) buf[5] = 'w';
	if (namep -> st_mode & S_ISGID) buf[6] = 's';
	else if (namep -> st_mode & S_IXGRP) buf[6] = 'x';
	if (namep -> st_mode & S_IROTH) buf[7] = 'r';
	if (namep -> st_mode & S_IWOTH) buf[8] = 'w';
	if (namep -> st_mode & S_ISVTX) buf[9] = 't';
	else if (namep -> st_mode & S_IXOTH) buf[9] = 'x';
#endif

	cprintf2("%-10.10s ", buf);
#if	!MSDOS
	cprintf2("%2d ", namep -> st_nlink);
	if (uid) cprintf2("%-8.8s ", uid -> pw_name);
	else cprintf2("%-8d ", namep -> st_uid);
	if (gid) cprintf2("%-8.8s ", gid -> gr_name);
	else cprintf2("%8d ", namep -> st_gid);
#endif
	cprintf2("%8d %02d-%02d-%02d %02d:%02d ",
		namep -> st_size,
		timep -> tm_year, timep -> tm_mon + 1, timep -> tm_mday,
		timep -> tm_hour, timep -> tm_min);
	cprintf2("%-24.24s", namep -> name);

	tflush();
}

static VOID stylebar(namep)
namelist *namep;
{
	char buf[82];
	FILE *fp;
	int len = 0;

	locate(0, FILEPERLOW + 3);
	if (namep -> isdir > 0) {
		putterm(l_clear);
		return;
	}

	if (!(fp = fopen(namep -> name, "r"))) {
		warning(-1, namep -> name);
		return;
	}
	if (!fgets(buf, 80, fp)) {
		if (ferror(fp)) error(-1);
	}
	else if (*buf == ';') {
		len = strlen(buf) - 1;
		if (buf[len] == '\n') buf[len] = '\0';
		
	}
	fclose(fp);

	if (len) cprintf2("%-*.*s", n_column, n_column, &buf[1]);
	else putterm(l_clear);

	tflush();
}

static VOID calclocate(i)
int i;
{
	int x, y;

	i %= FILEPERPAGE;
	x = (i / FILEPERLOW) * (80 / FILEPERLINE);
	y = i % FILEPERLOW;
	locate(x + 1, y + 2);
}

static VOID putname(i, name, isdir, so)
int i;
char *name;
int isdir, so;
{
	char buf[MAXPATHLEN + 2 + 1];

	calclocate(i);
	strcpy(&buf[1], name);
	if (isdir != 1) *buf = ' ';
	else {
		*buf = '<';
		strcat(buf, ">");
	}
	if (so) putterm(t_standout);
	cputs2(buf);
	if (so) putterm(end_standout);

	tflush();
}

static namelist *listupfile(startp, def)
namelist *startp;
char *def;
{
	namelist *namep, *ret;
	int i;

	for (i = 0; i < FILEPERLOW; i++) {
		locate(0, i + 2);
		putterm(l_clear);
	}
	ret = NULL;

	i = 0;
	if (def) for (namep = startp; namep; namep = namep -> next) {
		if (!strcmp(def, namep -> name)) break;
		if (++i > FILEPERPAGE) {
			i = 0;
			startp = namep;
		}
	}

	i = 0;
	for (namep = startp; namep; namep = namep -> next) {
		if ((def && !strcmp(def, namep -> name))
		|| (!def && !(namep -> no % FILEPERPAGE))) {
			ret = namep;
			putname(namep -> no, namep -> name, namep -> isdir, 1);
		}
		else putname(namep -> no, namep -> name, namep -> isdir, 0);
		if (++i >= FILEPERPAGE) break;
	}

	tflush();
	return(ret ? ret : startp);
}

static int selectfile(file, ext, def, save)
char *file, *ext, *def;
int save;
{
	static int statuson = 0;
	namelist *filelist;
	namelist *new, *old;
	int no;
	char *cp;
	int ch, c;

	no = 0;
	filelist = newlist(NULL);

	new = (save) ? addlist(filelist, NEWN_K, no++, 2)
		: filelist;

	while ((c = searchdir(file)) >= 0) {
		if (!(strcmp(file, "."))) continue;
		if (!c && ext && (!(cp = strrchr(file, '.'))
			|| (strcmp(++cp, ext)))) continue;
		new = addlist(new, file, no, c);
		no++;
	}

	(new -> prev) -> next = NULL;
	free(new);
	filelist = sortlist(filelist);
	if (statuson) {
		locate(1, 1);
		putch2('+');
	}

	helpbar();
	old = new = listupfile(filelist, def);

	keyflush();
	do {
		if (statuson) {
			if (ext) stylebar(old);
			else statusbar(old);
		}
		calclocate(old -> no);
		tflush();

		ch = getkey2(0);
		if (ch >= 'a' && ch <= 'z') ch += 'A' - 'a';
		keyflush();
		switch (ch) {
			case CTRL('P'):
			case K_UP:
				if (old -> prev) new = old -> prev;
				break;
			case CTRL('N'):
			case K_DOWN:
				if (old -> next) new = old -> next;
				break;
			case CTRL('F'):
			case K_RIGHT:
				new = old;
				for (c = 0; c < FILEPERLOW; c++) {
					if (new -> next) new = new -> next;
					else {
						new = old;
						break;
					}
				}
				break;
			case CTRL('B'):
			case K_LEFT:
				new = old;
				for (c = 0; c < FILEPERLOW; c++) {
					if (new -> prev) new = new -> prev;
					else {
						new = old;
						break;
					}
				}
				break;
			case CTRL('C'):
				new = old;
				for (c = 0; c < FILEPERPAGE; c++) {
					if (new -> next) new = new -> next;
					else {
						new = old;
						break;
					}
				}
				break;
			case CTRL('R'):
				new = old;
				for (c = 0; c < FILEPERPAGE; c++) {
					if (new -> prev) new = new -> prev;
					else {
						new = old;
						break;
					}
				}
				break;
			case K_BS:
				free(old -> name);
				old -> name = strdup2("..");
				old -> no = -1;
				old -> isdir = 1;
				ch = K_CR;
				break;
			case '\t':
				locate(1, 1);
				if ((statuson = 1 - statuson)) {
					putch2('+');
					if (ext) stylebar(old);
					else statusbar(old);
				}
				else {
					putch2(' ');
					locate(0, n_line - 1);
					putterm(l_clear);
				}
				break;
			case '/':
			case 'L':
				*old -> name = '\0';
				old -> isdir = 0;
				ch = K_CR;
				break;
			case ' ':
			case 'V':
				if (old -> isdir > 0) break;
				putterm(t_clear);
				if (!system3("PAGER", old -> name)) {
#ifdef	PAGER
						system2(PAGER, old -> name);
#else
					do {
						dump(old -> name);
					} while(!yesno(PEND_K));
#endif
				}

				title();
				pathbar();
				helpbar();
				if (statuson) {
					locate(1, 1);
					putch2('+');
				}
				old = NULL;
				break;
			case 'Q':
				ch = K_ESC;
				break;
			default:
				break;
		}

		if (!old
		|| old -> no / FILEPERPAGE != new -> no / FILEPERPAGE) {
			old = new;
			while (old -> no % FILEPERPAGE) old = old -> prev;
			old = listupfile(old, new -> name);
		}
		else if (old != new) {
			putname(new -> no, new -> name, new -> isdir, 1);
			putname(old -> no, old -> name, old -> isdir, 0);
			old = new;
		}
	} while (ch != K_CR && ch != K_ESC);

	strcpy(file, old -> name);
	new = filelist;
	c = old -> isdir;
	do {
		if (new -> prev) free(new -> prev);
		free(new -> name);
		new = new -> next;
	} while(new);
	if (ch == K_ESC) return(-1);

	if (c > 1) {
		if ((cp = inputstr2("FileName: "))) {
			if (*cp) {
				strcpy(file, cp);
				free(cp);
				if ((cp = strrchr(file, '.'))) *(++cp) = '\0';
				else strcat(file, ".");
				strcat(file, POLSEXT);
				c = 0;
			}
			else {
				free(cp);
				strcpy(file, ".");
				c = 1;
			}
		}
		else {
			strcpy(file, ".");
			c = 1;
		}
	}
	return(c);
}

char *getfilename(cur, ext, save)
char *cur, *ext;
int save;
{
	char *fullpath, *path, *def, *cwd;
	char file[MAXNAMLEN + 1];
	char prev[MAXNAMLEN + 1];
	int i;
#if	MSDOS
	unsigned drv, curdrv;
	struct diskfree_t diskspace;

	_dos_getdrive(&curdrv);
#endif

	def = NULL;
	if (cur) {
#if	MSDOS
		drv = *cur;
		if (drv >= 'a' && drv <= 'z') drv += 'A' - 'a';
		drv -= 'A' - 1;
		_dos_setdrive(drv, &drv);
#endif
		def = strrdelim(cur);
		if (def) {
			if (def == cur) {
				file[0] = _SC_;
				file[1] = '\0';
				chdir(file);
			}
			else {
				*def = '\0';
				chdir(cur);
				*def = _SC_;
			}
			def++;
		}
	}

	cwd = getworkdir();
	fullpath = NULL;

	strcpy(file, ".");
	for (;;) {
		if (!strcmp(file, "..")) {
			path = getworkdir();
			def = strrdelim(path);
			if (def) def++;
			else def = path;
			strcpy(prev, def);
			free(path);
			if (*prev) def = prev;
			else {
				strcpy (file, ".");
				def = "..";
			}
		}

		chdir(file);
		pathbar();

		i = selectfile(file, ext, def, save);
		if (i < 0) break;
		if (!*file) {
#if	MSDOS
			if (path = inputstr2("Drive: ")) {
				drv = *path;
				if (drv >= 'a' && drv <= 'z') drv += 'A' - 'a';
				drv -= '@';
				if (!*path);
				else if (_dos_getdiskfree(drv, &diskspace)) {
					while (!warning(-1, path));
				}
				else {
					_dos_setdrive(drv, &drv);
					if (*(path + 1) == ':' && *(path + 2)
					&& chdir(path + 2) < 0) {
						while (!warning(-1, path));
					}
				}
				free(path);
			}
#else
			if ((path = inputstr2("Path: "))) {
				if (*path && chdir(path)) {
					while (!warning(-1, path));
				}
				free(path);
			}
#endif
			strcpy(file, ".");
		}
		else if (!i) {
			path = getworkdir();
			fullpath = (char *)malloc(strlen(path)
				+ strlen(file) + 2);
			if (!fullpath) error(-1);
			strcpy(fullpath, path);
			free(path);
			if (!isdelim(fullpath, (int)strlen(fullpath) - 1))
				strcat(fullpath, _SS_);
			strcat(fullpath, file);
			break;
		}
		def = NULL;
	}

	chdir(cwd);
	free(cwd);

#if	MSDOS
	_dos_setdrive(curdrv, &drv);
#endif
	return(fullpath);
}
