/*
 *	print.c
 *
 *	Print Out with Text Restructure
 */

#include "lipsf.h"
#include "var.h"
#include <sys/timeb.h>

#if	!MSDOS
#include <sys/time.h>
#endif

#ifdef	USETIMEH
#include <time.h>
#endif

#if 	MSDOS || defined (__STDC__)
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#define MAXCOLS	512

#if	MSDOS
extern int lputc(int, FILE *);
extern int lprintf(FILE *, CONST u_char *, ...);
#else
#define	lputc	fputc
#define	lprintf	fprintf
#endif

static int halfline;
static u_char linebuf[MAXCOLS];
static int inrange;

int column;
int line;
int logicalline;
long totalline;
int step;
int page;
int lastch;
int nextch;
int linep;
int inheader;

extern FILE *infile;
extern int kanjiflag;
extern int kanaflag;
extern int kanjimode;
extern int buffer;
extern struct tm *nowtime;

static u_char *str2chr __P_((u_char *, int, int));
static VOID oneline __P_((FILE *, u_char *));
static VOID header __P_((FILE *));
static VOID footer __P_((FILE *));
static VOID columnstep __P_((FILE *));
VOID bufflush __P_((FILE *));
int bufputc __P_((int, FILE *));
static int isoverline __P_((int));
VOID linefeed __P_((FILE *));
VOID forcedlinefeed __P_((int, FILE *));
int foldputc __P_((int, FILE *));
VOID printout __P_((FILE *));

#if	MSDOS
int bufprintf(FILE *, CONST u_char *, ...);
int foldprintf(FILE *, CONST u_char *, ...);
#else
int bufprintf __P_((FILE *, CONST u_char *, ...));
int foldprintf __P_((FILE *, CONST u_char *, ...));
#endif

extern VOID error __P_((int));
extern VOID output __P_((int, FILE *));
extern VOID lips_unit __P_((FILE *, int));
extern VOID resetcursor __P_((FILE *, int, int));
extern VOID stackvar __P_((int));


static u_char *str2chr(s, c1, c2)
u_char *s;
int c1, c2;
{
	for (; *s; s += 2) if (*s == c1 && *(s + 1) == c2) return(s);
	return(NULL);
}

static VOID oneline(stream, str)
FILE *stream;
u_char *str;
{
	int i;
	int c, duplastch;
	int dupcolumn, duplinep, dupkanjiflag, dupkanaflag;

	duplastch = lastch;
	dupcolumn = column;
	duplinep = linep;
	dupkanjiflag = kanjiflag;
	dupkanaflag = kanaflag;
	lastch = '\0';
	lastch = buffer = '\0';
	column = linep = kanjiflag = kanaflag = 0;
	inheader = 1;
	for (i = 0; (c = str[i]); i++) {
		output(c, stream);
		lastch = c;
	}
	if (kanjiflag) kanjiout(stream);
	if (linep) bufputc('\r', stream);
	inheader = 0;
	lastch = duplastch;
	column = dupcolumn;
	linep = duplinep;
	kanjiflag = dupkanjiflag;
	kanaflag = dupkanaflag;
}

static VOID header(stream)
FILE *stream;
{
	if (headerstr) {
		maxvmi = -1;
		oneline(stream, headerstr);
		lprintf(stream, "\033[?6 I");
		lprintf(stream, "\033[11h");
		lputc('\r', stream);
		lprintf(stream, "\033[%lde", (long)headermargin * 100);
		lips_unit(stream, 0);
		lprintf(stream, "\033[11h");
		lprintf(stream, "\033[%de", lettersize);
	}
}

static VOID footer(stream)
FILE *stream;
{
	if (footerstr) {
		resetcursor(stream, 0, 0);
		lips_unit(stream, 0);
		lprintf(stream, "\033[11h");
		lprintf(stream, "\033[%de", dotprintheight - lettersize);
		maxvmi = -1;
		oneline(stream, footerstr);
	}
}

static VOID columnstep(stream)
FILE *stream;
{
	long tmp;

	if (maxcolumns) {
		tmp = maxcolumns;
		tmp *= columnwidth + lettersize / 2;
		tmp -= columnwidth;
		tmp += (dotprintwidth - tmp * maxsteps) / (maxsteps - 1);
	}
	else tmp = dotprintwidth / maxsteps;
	tmp = tmp * step;
	resetcursor(stream, (int)tmp, (headerstr && step) ? headermargin : 0);
}

VOID bufflush(stream)
FILE *stream;
{
	int i, j, indent;
	int flag;
	int col1, len1, col2, len2;
	u_char *tmp;

	flag = 0;

	if (inheader) {
		if (linebuf[linep - 1] == '\r') linep--;
		col1 = len1 = col2 = len2 = 0;

		if ((tmp = (u_char *)memchr(linebuf, '\0', linep))) {
			col1 = tmp[1] + tmp[2] * 0x100;
			if ((tmp = (u_char *)memchr(&tmp[3], '\0',
			linep - (int)(&tmp[3] - linebuf)))) {
				col2 = tmp[1] + tmp[2] * 0x100;
				len1 = col2 - col1;
				len2 = column - col2;
			}
			else len1 = column - col1;
			col1 = (realmaxcolumns - len1) / 2 - col1;
			col2 = realmaxcolumns - len2 - col2 - col1;
			if (col2 < 0) {
				col1 += col2;
				if (col1 > 0) {
					col2 = col1 / 2;
					col1 -= col2;
				}
			}
		}
		for (i = 0; i < linep; i++) {
			if (linebuf[i]) lputc(linebuf[i], stream);
			else {
				switch (flag++) {
					case 0:
						for (j = 0; j < col1; j++)
							lputc(' ', stream);
						break;
					case 1:
						for (j = 0; j < col2; j++)
							lputc(' ', stream);
						break;
					default:
						break;
				}
				i += 2;
			}
		}
	}
	else {
		if (centering) indent = (maxcolumns - column) / 2;
		else if (flushright) indent = maxcolumns - column;
		else if (leftindent) indent = leftindent;
		else indent = 0;

		if (linep && linebuf[linep - 1] == '\f') {
			if (--linep || line > 1) flag = 1;
			line = halfline = 0;
		}
		else if (maxlines && line >= maxlines - 1
		&& *linebuf != '\n') {
			if (linebuf[linep - 1] == '\r') linep--;
		}
		else if (maxlines && line >= maxlines) {
			line -= maxlines;
			halfline = 0;
			linep = 0;
			if (!step && inrange) footer(stream);
			if (maxsteps > 1) {
				if (++step >= maxsteps) step = 0;
				if (inrange) columnstep(stream);
			}
			if (maxsteps < 2 || !step ) {
				if (inrange) lputc('\r', stream);
				page++;
				i = inrange;
				inrange = (startpage == AUTOVALUE
					|| page >= startpage)
					&& (endpage == AUTOVALUE
					|| page <= endpage);
				if (inrange) {
					if (i) {
						lputc(P_FF, stream);
						resetcursor(stream, 0, 0);
						lastvmi = lettersize;
					}
					header(stream);
				}
			}
		}

		if (inrange) {
			if (maxvmi > lastvmi) {
				lips_unit(stream, 0);
				lprintf(stream, "\033[11h");
				lprintf(stream, "\033[%de", maxvmi - lastvmi);
			}
			if (linep && *linebuf != '\n' && *linebuf != '\r')
				for (i = 0; i < indent; i++)
					lputc(' ', stream);
			for (i = 0; i < linep; i++) lputc(linebuf[i], stream);
		}

		if (flag) {
			if (!step && inrange) footer(stream);
			if (maxsteps > 1) {
				if (++step >= maxsteps) step = 0;
				if (inrange) columnstep(stream);
			}
			if (maxsteps < 2 || !step) {
				if (inrange) lputc('\r', stream);
				page++;
				i = inrange;
				inrange = (startpage == AUTOVALUE
					|| page >= startpage)
					&& (endpage == AUTOVALUE
					|| page <= endpage);
				if (inrange) {
					if (i) {
						lputc(P_FF, stream);
						resetcursor(stream, 0, 0);
					}
					header(stream);
				}
			}
		}
		centering = flushright = 0;
		maxvmi = lastvmi = lettersize;
	}
	linep = 0;
}

int bufputc(c, stream)
int c;
FILE *stream;
{
	linebuf[linep++] = c;
	if (linep >= MAXCOLS || c == '\r' || c == '\n' || c == '\f')
		bufflush(stream);
	else if (linep > 1 && linebuf[linep - 2] == '\033'
		&& strchr("KML", c)) bufflush(stream);
	return(c);
}

#ifndef	NOVSPRINTF
/*VARARGS1*/
#if	MSDOS || defined (__STDC__)
int bufprintf(FILE *stream, CONST u_char *fmt, ...)
#else
int bufprintf(stream, fmt, va_alist)
FILE *stream;
u_char *fmt;
va_dcl
#endif
{
	va_list args;
	int i;
	u_char buf[MAXCOLS];

#if	MSDOS || defined (__STDC__)
	va_start(args, fmt);
#else
	va_start(args);
#endif

	vsprintf(buf, fmt, args);
#else	/* NOVSPRINTF */
int bufprintf(stream, fmt, arg1, arg2, arg3, arg4, arg5, arg6)
FILE *stream;
u_char *fmt;
{
	int i;
	u_char buf[MAXCOLS];

	sprintf(buf, fmt, arg1, arg2, arg3, arg4, arg5, arg6);
#endif	/* NOVSPRINTF */

	for (i = 0; buf[i]; i++) bufputc(buf[i], stream);
	va_end(args);
	return(i);
}

static int isoverline(c)
int c;
{
	int max;

	if (kanjiflag == 2) return(0);

	max = maxcolumns;
	if (!inheader) max -= rightindent + leftindent;
	if (kanjiflag) max--;

	if (iskinsoku) {
		if (kanjiflag == 1) {
			if (str2chr((u_char *)KINSOKUBOLJIS, c, nextch))
				max += 2;
			else if (str2chr((u_char *)KINSOKUEOLJIS, c, nextch))
				max -= 2;
		}
		else {
			if (strchr((u_char *)KINSOKUBOL, c)) max++;
			else if (strchr((u_char *)KINSOKUEOL, c)) max--;
			else if (strchr((u_char *)KINSOKUBOLKANA, c)) max++;
			else if (strchr((u_char *)KINSOKUEOLKANA, c)) max--;
		}
	}
	if (column >= max) return(1);
	return(0);
}

VOID linefeed(stream)
FILE *stream;
{
	switch (returnheight) {
		case 0:
			bufputc('\n', stream);
			break;
		case 1:
			if (halfline) {
				halfline = 0;
				line--;
				totalline--;
			}
			else halfline = 1;
			bufprintf(stream, "\033K");
			break;
		default:
			line--;
			totalline--;
			break;
	}
	returnheight = 0;
}

VOID forcedlinefeed(c, stream)
int c;
FILE *stream;
{
	if (!inheader && maxcolumns && isoverline(c)) {
		if (kanjiflag) {
			if (linep > 2
			&& !strncmp(&linebuf[linep - 2], "\033n", 2))
				linep -= 2;
			else kanjiout(stream);
		}
		bufputc('\r', stream);
		column = 0;
		line++;
		totalline++;
		linefeed(stream);
		if (kanjiflag) kanjiin(stream);
	}
}

int foldputc(c, stream)
int c;
FILE *stream;
{
	int ret;

	if (c >= ' ') {
		forcedlinefeed(c, stream);
		if (broadsize) column++;
		else if (widesize && !isvertical) column++;
		else if (longsize && isvertical) column++;
		column++;
	}
	ret = bufputc(c, stream);
	if (c == '\0') {
		linebuf[linep++] = column % 0xff;
		linebuf[linep++] = column / 0xff;
	}
	if (c == '\r') column = 0;
	return(ret);
}

#ifndef	NOVSPRINTF
/*VARARGS1*/
#if	MSDOS || defined (__STDC__)
int foldprintf(FILE *stream, CONST u_char *fmt, ...)
#else
int foldprintf(stream, fmt, va_alist)
FILE *stream;
u_char *fmt;
va_dcl
#endif
{
	va_list args;
	int i;
	u_char buf[MAXCOLS];

#if	MSDOS || defined (__STDC__)
	va_start(args, fmt);
#else
	va_start(args);
#endif

	vsprintf(buf, fmt, args);
#else	/* NOVSPRINTF */
int foldprintf(stream, fmt, arg1, arg2, arg3, arg4, arg5, arg6)
FILE *stream;
u_char *fmt;
{
	int i;
	u_char buf[MAXCOLS];

	sprintf(buf, fmt, arg1, arg2, arg3, arg4, arg5, arg6);
#endif	/* NOVSPRINTF */

	for (i = 0; buf[i]; i++) foldputc(buf[i], stream);
	va_end(args);
	return(i);
}

VOID printout(stream)
FILE *stream;
{
#if	!MSDOS
	struct timeval t_val;
	struct timezone tz;
#endif
	time_t count;
	int c;

	kanjiflag = kanaflag = 0;
	kanjimode = ASCII;
	totalline = 0;
	column = line = logicalline = step = page =
	linep = halfline = leftindent = rightindent = 0;
	inheader = 0;
	if (controlchar) controlmode = 1;
	lastch = buffer = '\0';
	stackvar(1);

#if	MSDOS
	count = time(NULL);
#else
	gettimeofday(&t_val, &tz);
	count = t_val.tv_sec;
#endif
	nowtime = localtime(&count);

	inrange = (startpage == AUTOVALUE || page >= startpage)
		&& (endpage == AUTOVALUE || page <= endpage);

	if (inrange) {
		header(stream);
		maxvmi = lastvmi = lettersize;
	}

	while ((c = fgetc(infile)) != EOF) {
		output(c, stream);
		lastch = c;
	}

	if (kanjiflag) kanjiout(stream);
	if (linep) bufputc('\r', stream);
	halfline = 0;

	if (!step && inrange) footer(stream);
	stackvar(0);
}
