/*
 *	getopt.c
 *
 *	getopt() for MS-DOS
 */

#include <stdio.h>
#include <string.h>

char *optarg = NULL;
int optind = 1;

int getopt(int, char *[], char *);


int getopt(argc, argv, optstring)
int argc;
char *argv[], *optstring;
{
	char *str, *cp;
	int c;

	if (argc <= optind) return(EOF);
	str = argv[optind];
	if (*str != '-') return(EOF);
	c = *(str + 1);
	if (!c) return(EOF);
	optind++;
	if (c == '-' && !*(str + 2)) return(EOF);

	if (c == ':' || !(cp = strchr(optstring, c))) {
		fprintf(stderr, "%s: illegal option -- %c\n", argv[0], c);
		return('?');
	}
	if (*(cp + 1) == ':') {
		if (*(str + 2)) optarg = str + 2;
		else if (argc > optind) optarg = argv[optind++];
		else {
			fprintf(stderr, "%s: option requires an argument -- %c\n", argv[0], c);
			return('?');
		}
	}
	return(c);
}
