/*
 *	LIPSF (LBP Image Processing System Filter)
 *
 *			by T.Shirai
 */

#include "lipsf.h"
#include "var.h"
#include "version.h"
#include <time.h>

#if	MSDOS
extern char *strrdelim __P_((char *));
#else
#define	lprintf	fprintf
#define	lputc	fputc
#define	strrdelim(s)	strrchr(s, _SC_)
#endif

static char *progname;
FILE *infile = stdin;
FILE *null;
int pagesum;

extern int line;
extern int step;
extern int page;
extern char filenamebody[];

VOID error __P_((int));
VOID usage __P_((int));
int main __P_((int, char *[]));

extern VOID getfileinfo __P_((char *, FILE *));
extern VOID resetcursor __P_((FILE *, int, int));
extern FILE *lpropen __P_((VOID_A));
extern VOID frontprocess __P_((FILE *));
extern VOID backprocess __P_((FILE *));
extern int getarg __P_((int, char *[], int));
extern VOID printout __P_((FILE *));
#if	MSDOS
extern int lputc(int, FILE *);
extern int lprintf(FILE *, CONST u_char *, ...);
#endif


VOID error(no)
int no;
{
	if (no >= 0) errno = no;
	perror(progname);
	fputc(0x07, stderr);
	usage(no);
}

VOID usage(no)
int no;
{
	fprintf(stderr, "Usage: %s ", progname);
	fprintf(stderr, "[-pmdfJshwCA#tclTBLRHFOSrPvkKi234@?] [file ...]");
	fputc('\n', stderr);
	fprintf(stderr, "    -p: Paper Size            ");
	fprintf(stderr, "{A3, A4(default), A5, B4, B5, Hagaki}");
	fputc('\n', stderr);
	fprintf(stderr, "    -m: Mode of Paper Supply  ");
	fprintf(stderr, "{Auto(default), Manual, Lower, Upper}");
	fputc('\n', stderr);
	fprintf(stderr, "    -d: Direction of Paper    ");
	fprintf(stderr, "{Portrait(default), Landscape}");
	fputc('\n', stderr);
	fprintf(stderr, "    -f: Font of Letter        ");
	fprintf(stderr, "{Mincho(default), Gothic, Round-Gothic}");
	fputc('\n', stderr);
	fprintf(stderr, "    -J: Japanese Kanji Code   ");
	fprintf(stderr, (DEF_KCODE == SJIS) ?
		"{SJIS(default), EUC, JIS}" : "{EUC(default), SJIS, JIS}");
	fputc('\n', stderr);
	fprintf(stderr, "    -s: Size of Letter        ");
	fprintf(stderr, "(default = %d dots)", LETTERSIZE);
	fputc('\n', stderr);
	fprintf(stderr, "    -h: Hight between Lines   ");
	fprintf(stderr, "(default = %d dots)", LINEHEIGHT);
	fputc('\n', stderr);
	fprintf(stderr, "    -w: Width between Columns ");
	fprintf(stderr, "(default = %d dots)", COLUMNWIDTH);
	fputc('\n', stderr);
	fprintf(stderr, "    -C: Control Code Prefix   ");
	fprintf(stderr, "(default = None)");
	fputc('\n', stderr);
	fprintf(stderr, "    -N: Name of Printer       ");
	fprintf(stderr, "(default = \"%s\")",
#if	MSDOS
		"local");
#else
		LPRPRINTER);
#endif
	fputc('\n', stderr);
	fprintf(stderr, "    -A: Arrange Header&Footer ");
	fprintf(stderr, "(default = H.Margin: %d mm, F.Margin: %d mm, ...)"
		, HEADERMARGIN, FOOTERMARGIN);
	fputc('\n', stderr);
	fprintf(stderr, "    -#: Number of Copies ");
	fprintf(stderr, "(def. %3d)  ", PRINTNUM);
	fprintf(stderr, "    -t: Tab Position     ");
	fprintf(stderr, "(def. %2d)   ", TABPOSITION);
	fputc('\n', stderr);
	fprintf(stderr, "    -c: Columns per Line ");
	fprintf(stderr, "(def. Auto) ");
	fprintf(stderr, "    -l: Lines per Page   ");
	fprintf(stderr, "(def. Auto) ");
	fputc('\n', stderr);
	fprintf(stderr, "    -T: Top Margin       ");
	fprintf(stderr, "(def. %02d mm)", TOPMARGIN);
	fprintf(stderr, "    -B: Bottom Margin    ");
	fprintf(stderr, "(def. Auto)");
	fputc('\n', stderr);
	fprintf(stderr, "    -L: Left Margin      ");
	fprintf(stderr, "(def. %02d mm)", LEFTMARGIN);
	fprintf(stderr, "    -R: Right Margin     ");
	fprintf(stderr, "(def. Auto)");
	fputc('\n', stderr);
	fprintf(stderr, "    -H: Header Strings   ");
	fprintf(stderr, "(def. None) ");
	fprintf(stderr, "    -F: Footer Strings   ");
	fprintf(stderr, "(def. None) ");
	fputc('\n', stderr);
	fprintf(stderr, "    -O: Overlay Mode     ");
	fprintf(stderr, "(def. 0)    ");
	fprintf(stderr, "    -S: Steps of Column  ");
	fprintf(stderr, "(def. %1d)    ", MAXSTEPS);
	fputc('\n', stderr);
	fprintf(stderr, "    -r: Range of Pages   ");
	fprintf(stderr, "(def. all)  ");
	fprintf(stderr, "    -P: Page No. on 1st  ");
	fprintf(stderr, "(def. %3d P) ", FIRSTPAGE);
	fputc('\n', stderr);
	fprintf(stderr, "    -v: Virtical Kanji Mode          ");
	fprintf(stderr, "    -k: Keisen Concatinate Mode      ");
	fputc('\n', stderr);
	fprintf(stderr, "    -K: Kinsoku Mode                 ");
	fprintf(stderr, "    -i: Info. Only Mode              ");
	fputc('\n', stderr);
	fprintf(stderr, "    -2: LIPS II+ Mode    ");
	fprintf(stderr, "    -3: LIPS III Mode    ");
	fprintf(stderr, "    -4: LIPS IV Mode     ");
	fputc('\n', stderr);
	fprintf(stderr, "    -@: Argument List File           ");
	fprintf(stderr, "    -?: help (Show This)");
#if	!MSDOS
	fputc('\n', stderr);
#endif
	exit(no);
}

int main(argc, argv)
int argc;
char *argv[];
{
	int n;
	long ttyin = ftell(stdin);
	long ttyout = ftell(stdout);
	FILE *outfile = stdout;
#if	!MSDOS
	char tmpfile[L_tmpnam];
	int c;

	*tmpfile = '\0';
#endif

	progname = strrdelim(argv[0]);
	if (progname) progname++;
	else progname = argv[0];
	n = getarg(argc, argv, 0);
	if (n == argc) infile = stdin;
	else if (!(infile = fopen(argv[n], "r"))) error(-1);

	if (!(null = fopen(NULLDEVICE, "w"))) error(-1);

	if (infile == stdin && (ttyin > 0 || ttyin < -1))
		execlp(POLS, argv[0], NULL);

	if (isinfo) outfile = null;
#if	MSDOS
	else if (outputprinter) {
		if (!(outfile = fopen(outputprinter, "w"))) error(-1);
	}
#endif
	else if (ttyout > 0 || ttyout < -1) outfile = lpropen();

	tzset();

	frontprocess(outfile);
	do {
		if ((headerstr && strstr(headerstr, "%P"))
		|| (footerstr && strstr(footerstr, "%P"))) {
#if	!MSDOS
			if (infile == stdin) {
				if (!(infile = fopen(tmpnam(tmpfile), "w")))
					error(-1);
				while ((c = fgetc(stdin)) != EOF)
					fputc(c, infile);
				fclose(infile);
				if (!(infile = fopen(tmpfile, "r")))
					error(-1);
			}
#endif
			getfileinfo(argv[n], infile);
			printout(null);
			if (fseek(infile, 0L, 0)) error(-1);
			pagesum = page;
		}
		else getfileinfo(argv[n], infile);

		printout(outfile);
		if (infile != stdin) fclose(infile);
#if	!MSDOS
		if (*tmpfile) unlink(tmpfile);
		*tmpfile = '\0';
#endif

		if (isinfo) {
			printf("%4dP + %1dS + %3dL %-60.60s\n",
				page, step, line, filenamebody);
		}

		if (++n < argc) {
			getarg(argc, argv, 0);
			if (!(infile = fopen(argv[n], "r"))) error(-1);
			resetcursor(outfile, 0, 0);
			lputc(P_FF, outfile);
			lprintf(outfile, "\033[0;0;0x");
			lprintf(outfile, "\033%%@");
		}
	} while (n < argc);
	backprocess(outfile);

#if	MSDOS
	if (outfile && outfile != stdout && outfile != null) fclose(outfile);
#else
	if (outfile != stdout && outfile != null) pclose(outfile);
#endif
	fclose(null);
	return(0);
}
