/*
 *	control.c
 *
 *	Control Code Analize
 */

#include "lipsf.h"
#include "var.h"
#include <time.h>

u_char keisen_line[] = {
	0x06, 0x09, 0x0c, 0x0a, 0x03, 0x05, 0x0d, 0x0e,
	0x0b, 0x07, 0x0f, 0x60, 0x90, 0xc0, 0xa0, 0x30,
	0x50, 0xd0, 0xe0, 0xb0, 0x70, 0xf0, 0x94, 0x68,
	0x92, 0x61, 0x69, 0x49, 0x86, 0x29, 0x16, 0x96
};

u_char keisen_line98[] = {
	0x06, 0x60, 0x09, 0x90, 0x06, 0x60, 0x09, 0x90,
	0x06, 0x60, 0x09, 0x90, 0x0c, 0x48, 0x84, 0xc0,
	0x0a, 0x28, 0x82, 0xa0, 0x05, 0x41, 0x14, 0x50,
	0x03, 0x21, 0x12, 0x30, 0x0d, 0x49, 0x1c, 0x85,
	0x94, 0x58, 0xc1, 0xd0, 0x0b, 0x29, 0x1a, 0x83,
	0x92, 0x38, 0xa1, 0xb0, 0x0e, 0x2c, 0x4a, 0x68,
	0x86, 0xa4, 0xc2, 0xe0, 0x07, 0x25, 0x34, 0x61,
	0x16, 0x34, 0x52, 0x70, 0x0f, 0x2d, 0x4b, 0x69,
	0x1e, 0x87, 0x96, 0x3c, 0x5a, 0xa5, 0xc3, 0x78,
	0xe1, 0xb4, 0xd2, 0xf0
};

static u_char parenbuf[80];
static int parenptr;
struct tm *nowtime;

int buffer;

extern FILE *infile;
extern int kanjiflag;
extern int kanjimode;
extern int column;
extern int page;
extern int pagesum;
extern int lastch;
extern int nextch;
extern int linep;
extern int inheader;
extern struct stat filebuf;
extern char fullpathbody[];
extern char filenamebody[];
extern int dpitable[];

static VOID keisen __P_((int, int, int, int, FILE *));
static VOID chgsize __P_((int, int, FILE *));
static int control __P_((int, FILE *));
static VOID kanjinum __P_((int, FILE *));
static int percent __P_((int, FILE *));
static VOID controlparen __P_((int, FILE *));
int filterputc __P_((int, FILE *));

extern VOID chgmaxlinecol __P_((VOID_A));
extern VOID bufflush __P_((FILE *));
extern int bufputc __P_((int, FILE *));
extern VOID linefeed __P_((FILE *));
extern VOID forcedlinefeed __P_((int, FILE *));
extern int foldputc __P_((int, FILE *));
extern VOID lips_unit __P_((FILE *, int));

#if	MSDOS
extern int bufprintf(FILE *, CONST u_char *, ...);
extern int foldprintf(FILE *, CONST u_char *, ...);
#else
extern int bufprintf __P_((FILE *, CONST u_char *, ...));
extern int foldprintf __P_((FILE *, CONST u_char *, ...));
#endif


static VOID keisen(start, end, width, mode, stream)
int start, end, width, mode;
FILE *stream;
{
	bufprintf(stream, "\033[%d;%d;%d{", width, mode, start);
	bufprintf(stream, "\033[%d}", end);
}

static VOID chgsize(vert, side, stream)
int vert, side;
FILE *stream;
{
	int i;

	if (isvertical) {
		i = vert;
		vert = side;
		side = i;
	}
	bufprintf(stream, "\033[%d;%d B", vert, side);
	kanjiin(stream);
	bufprintf(stream, "\033[%d;%d B", vert, side);
	kanjiout(stream);
}

static int control(c, stream)
int c;
FILE *stream;
{
	int n;
	int ch;

	if (!controlmode && c != '{') {
		foldputc(controlchar, stream);
		return(c);
	}
	else switch (c) {
		case 'w':
			widesize = 1 - widesize;
			if (widesize) n = 200;
			else n = 100;
			chgsize(100, n, stream);
			break;
		case 'l':
			longsize = 1 - longsize;
			if (longsize) n = 200;
			else n = 100;
			chgsize(n, 100, stream);
			break;
		case 'b':
			broadsize = 1 - broadsize;
			if (broadsize) n = 200;
			else n = 100;
			chgsize(n, n, stream);
			break;
		case 't':
			topscript = 1 - topscript;
			if (topscript) {
				n = 50;
				ch = 'k';
			}
			else {
				n = 100;
				ch = 'e';
			}
			chgsize(n, 100, stream);
			lips_unit(stream, 1);
			bufprintf(stream, "\033[11h");
			bufprintf(stream, "\033[%d%c", lettersize / 2, ch);
			break;
		case 's':
			subscript = 1 - subscript;
			if (subscript) n = 50;
			else n = 100;
			chgsize(n, 100, stream);
			break;
		case 'u':
			underline = 1 - underline;
			if (underline) n = 4;
			else n = 24;
			bufprintf(stream, "\033[%dm", n);
			break;
		case 'd':
			doubleunder = 1 - doubleunder;
			if (doubleunder) n = 21;
			else n = 24;
			bufprintf(stream, "\033[%dm", n);
			break;
		case 'f':
			forcedchar = 1 - forcedchar;
			if (forcedchar) n = 1;
			else n = 22;
			bufprintf(stream, "\033[%dm", n);
			kanjiin(stream);
			bufprintf(stream, "\033[%dm", n);
			kanjiout(stream);
			break;
		case 'a':
			amikake = 1 - amikake;
			if (amikake) n = 5;
			else n = 25;
			bufprintf(stream, "\033[%dm", n);
			break;
		case 'x':
			exclusive = 1 - exclusive;
			if (exclusive) n = 7;
			else n = 27;
			bufprintf(stream, "\033[%dm", n);
			break;
		case 'o':
			outline = 1 - outline;
			if (outline) n = 7;
			else n = 27;
			bufprintf(stream, "\033[?%dm", n);
			break;
		case 'p':
			patternfill = 1 - patternfill;
			if (patternfill) n = 5;
			else n = 25;
			bufprintf(stream, "\033[?%dm", n);
			break;
		case 'q':
			shadow = 1 - shadow;
			if (shadow) n = 6;
			else n = 26;
			bufprintf(stream, "\033[?%dm", n);
			break;
		case 'z':
			returnheight = 2;
			break;
		case 'h':
			returnheight = 1;
			break;
		case 'c':
			centering = 1;
			break;
		case 'r':
			flushright = 1;
			break;
		case 'k':
			if (isvertical) kumimoji = 1;
			break;
		case '@':
			break;
		case ';':
			while ((n = fgetc(infile)) != EOF && n != '\n');
			lastch = n;
			break;
		case '{':
			parentheses = -1;
			break;
		default:
			return(c);
			/*NOTREACHED*/
			break;
	}
	return(0);
}

static VOID kanjinum(n, stream)
int n;
FILE *stream;
{
	u_char *str;

	switch (kanjimode) {
		case SJIS:
			str = (u_char *)"\201Z\210\352\223\361\216O\216l\214\334\230Z\216\265\224\252\213\343";
			break;
		default:
			str = (u_char *)"!;0lFs;0;M8^O;<7H,6e";
			break;
	}
	str += (n % 10) * 2;
	kanjiflag = 1;
	nextch = str[1];
	foldputc(str[0], stream);
	kanjiflag = 2;
	foldputc(str[1], stream);
}

static int percent(c, stream)
int c;
FILE *stream;
{
	long num;
	u_char *str;
	int flag, field;
	struct tm *timep;

	num = 0;
	str = NULL;
	flag = 0;
	field = 2;

	timep = localtime(&filebuf.st_mtime);

	switch (c) {
		case 'y':
			num = nowtime -> tm_year % 100;
			break;
		case 'Y':
			num = nowtime -> tm_year + 1900;
			field = 4;
			break;
		case 'm':
			num = nowtime -> tm_mon + 1;
			if (iszerosup) field = 0;
			break;
		case 'N':
			switch (nowtime -> tm_mon + 1) {
				case 1:	str = (u_char *)"Jan";
					break;
				case 2:	str = (u_char *)"Feb";
					break;
				case 3:	str = (u_char *)"Mar";
					break;
				case 4:	str = (u_char *)"Apr";
					break;
				case 5:	str = (u_char *)"May";
					break;
				case 6:	str = (u_char *)"Jun";
					break;
				case 7:	str = (u_char *)"Jul";
					break;
				case 8:	str = (u_char *)"Aug";
					break;
				case 9:	str = (u_char *)"Sep";
					break;
				case 10:
					str = (u_char *)"Oct";
					break;
				case 11:
					str = (u_char *)"Nov";
					break;
				case 12:
					str = (u_char *)"Dec";
					break;
				default:
					break;
			}
			break;
		case 'd':
			num = nowtime -> tm_mday;
			if (iszerosup) field = 0;
			break;
		case 'w':
			switch (kanjimode) {
				case SJIS:
					str = (u_char *)"\223\372\214\216\211\316\220\205\226\330\213\340\223y";
					break;
				default:
					str = (u_char *)"F|7n2P?eLZ6bEZ";
					break;
			}
			str += (nowtime -> tm_wday) * 2;
			flag = 1;
			break;
		case 'W':
			switch (nowtime -> tm_wday) {
				case 0:	str = (u_char *)"Sun";
					break;
				case 1:	str = (u_char *)"Mon";
					break;
				case 2:	str = (u_char *)"Tue";
					break;
				case 3:	str = (u_char *)"Wed";
					break;
				case 4:	str = (u_char *)"Thu";
					break;
				case 5:	str = (u_char *)"Fri";
					break;
				case 6:	str = (u_char *)"Sat";
					break;
				default:
					break;
			}
			break;
		case 'H':
			num = nowtime -> tm_hour;
			if (iszerosup) field = 0;
			break;
		case 'h':
			num = nowtime -> tm_hour % 12;
			if (iszerosup) field = 0;
			break;
		case 'n':
			str = (nowtime -> tm_hour < 12)
				? (u_char *)"AM" : (u_char *)"PM";
			break;
		case 'M':
			num = nowtime -> tm_min;
			break;
		case 'S':
			num = nowtime -> tm_sec;
			break;
		case 'F':
			str = (u_char *)fullpathbody;
			break;
		case 'f':
			str = (u_char *)filenamebody;
			break;
		case 's':
			num = filebuf.st_size;
			field = 1;
			break;
		case 't':
			foldprintf(stream, "%02d-%02d-%02d %2d:%02d",
				timep -> tm_year % 100,
				timep -> tm_mon + 1,
				timep -> tm_mday,
				timep -> tm_hour,
				timep -> tm_min);
			return(0);
			/*NOTREACHED*/
			break;
		case 'p':
			num = page + firstpage;
			field = 1;
			break;
		case 'P':
			num = pagesum + firstpage;
			field = 1;
			break;
		default:
			return(c);
			/*NOTREACHED*/
			break;
	}
	if (str) {
		if (!flag) foldprintf(stream, str);
		else {
			kanjiin(stream);
			kanjiflag = 1;
			nextch = str[1];
			foldputc(str[0], stream);
			kanjiflag = 2;
			foldputc(str[1], stream);
			kanjiout(stream);
			kanjiflag = 0;
		}
	}
	else {
		switch (field) {
			case 0:	if (!isvertical || !iskanjinum)
					foldprintf(stream, "%2ld", num);
				else {
					kanjiin(stream);
					if (num > 9)
						kanjinum(num / 10, stream);
					kanjinum(num, stream);
					kanjiout(stream);
					kanjiflag = 0;
				}
				break;
			case 2:	if (!isvertical || !iskanjinum)
					foldprintf(stream, "%02ld", num);
				else {
					kanjiin(stream);
					kanjinum(num / 10, stream);
					kanjinum(num, stream);
					kanjiout(stream);
					kanjiflag = 0;
				}
				break;
			default:
				foldprintf(stream, "%ld", num);
				break;
		}
	}
	return(0);
}

static VOID controlparen(c, stream)
int c;
FILE *stream;
{
	u_char *cp;
	int dpi;

	if (!controlmode && c != '+')
		foldprintf(stream, "%c{%c%s}", controlchar, c, parenbuf);
	else switch (c) {
		case 'z':
			dpi = dpitable[lipsmode];
			lettersize = atoi(parenbuf);
			lips_unit(stream, 1);
			bufprintf(stream, "\033[?%d K",
				((long)dpi * 100 * 2) / lettersize);
			bufprintf(stream, "\033[%d C", lettersize);
			bufprintf(stream, "\033[%d;%d G",
				lineheight + lettersize,
				columnwidth + lettersize / 2);
			kanjiin(stream);
			bufprintf(stream, "\033[?%d K",
				((long)dpi * 100) / lettersize);
			bufprintf(stream, "\033[%d C", lettersize);
			bufprintf(stream, "\033[%d;%d G",
				lineheight + lettersize,
				(columnwidth + lettersize / 2) * 2);
			kanjiout(stream);
			chgmaxlinecol();
			break;
		case 'g':
			fontpattern = 80 + *parenbuf - '0';
			bufprintf(stream, "\033[%dy", fontpattern);
			kanjiin(stream);
			bufprintf(stream, "\033[%dy", fontpattern);
			kanjiout(stream);
			break;
		case 'j':
			isvertical = (*parenbuf == '0') ? 0 : 4;
			bufprintf(stream, "\033[%d S", isvertical);
			bufprintf(stream, "\033[?29%c",
				(isvertical) ? 'h' : 'l');
			break;
		case 'c':
			columnwidth = atoi(parenbuf);
			lips_unit(stream, 1);
			bufprintf(stream, "\033[%d;%d G",
				lineheight + lettersize,
				columnwidth + lettersize / 2);
			kanjiin(stream);
			bufprintf(stream, "\033[%d;%d G",
				lineheight + lettersize,
				(columnwidth + lettersize / 2) * 2);
			kanjiout(stream);
			chgmaxlinecol();
			break;
		case 'f':
			lineheight = atoi(parenbuf);
			lips_unit(stream, 1);
			bufprintf(stream, "\033[%d;%d G",
				lineheight + lettersize,
				columnwidth + lettersize / 2);
			kanjiin(stream);
			bufprintf(stream, "\033[%d;%d G",
				lineheight + lettersize,
				(columnwidth + lettersize / 2) * 2);
			kanjiout(stream);
			chgmaxlinecol();
			break;
		case 't':
			tabposition = atoi(parenbuf);
			break;
		case 'T':
			leftindent = atoi(parenbuf);
			if ((cp = (u_char *)strchr(parenbuf, ',')))
				rightindent = atoi(++cp);
			break;
		case 'k':
			isconcat = *parenbuf - '0';
			break;
		case 'o':
			iskinsoku = *parenbuf - '0';
			break;
		case 'W':
			iswordwrap = *parenbuf - '0';
			break;
		case 'J':
			isjustify = *parenbuf - '0';
			break;
		case '+':
			controlmode = 1;
			break;
		case '-':
			controlmode = 0;
			break;
		case ' ':
			break;
		default:
			foldprintf(stream, "%c{}", controlchar);
			buffer = '\0';
			break;
	}
}

int filterputc(c, stream)
int c;
FILE *stream;
{
	unsigned short kanji;
	int keisenno;
	int i, c1, c2;
	int direction;
	int width[4];
	int mode;

	c1 = c2 = 0;
	if (parentheses) {
		if (c == '}') {
			parenbuf[parenptr] = '\0';
			controlparen(parentheses, stream);
			parentheses = 0;
			return(c);
		}
		else if (parentheses < 0) {
			if (strchr("zgjcftTkoWJ+- ", c)) {
				parenptr = 0;
				parentheses = c;
				return(c);
			}
			else {
				foldprintf(stream, "%c{", controlchar);
				buffer = '\0';
				parentheses = 0;
			}
		}
		else {
			if (((c >= '0' && c <= '9'
			&& (strchr("zcftT", parentheses)
			|| (strchr("gjkoWJ", parentheses) && !parenptr)))
			|| (c == ',' && parenptr && parentheses == 'T')
			|| (c == '-' && !parenptr
			&& strchr("zcftT", parentheses))
			|| (c == ' ' && parentheses == ' '))
			&& parenptr < 79) {
				parenbuf[parenptr++] = c;
				return(c);
			}
			else {
				parenbuf[parenptr] = '\0';
				foldprintf(stream, "%c{%c%s",
					controlchar, parentheses, parenbuf);
				buffer = '\0';
				parentheses = 0;
			}
		}
	}

	if (inheader) {
		if (buffer == '%') {
			buffer = '\0';
			c = percent(c, stream);
			if (!c) return(c);
		}
		else if (!kanjiflag && c == '%') {
			buffer = c;
			return(c);
		}
		else if (c == '|') c = '\0';
	}

	if (controlchar) {
		if (c == '\r' || c == '\n' || c == '\f') {
			kanjiflag = 0;
			if (buffer) {
				if (kumimoji) {
					bufprintf(stream, "\033[%d S",
						isvertical | 3);
					bufprintf(stream, "\033[1;%d$q",
						lettersize);
					kanjiflag = 0;
					foldputc(buffer, stream);
					kanjiflag = 1;
					column++;
					bufprintf(stream, "\033[%d S ",
						isvertical);
				}
				else foldputc(buffer, stream);
			}
			buffer = '\0';
			if (widesize || longsize || broadsize
			|| topscript || subscript )
				chgsize(100, 100, stream);
			if (topscript) {
				lips_unit(stream, 1);
				bufprintf(stream, "\033[11h");
				bufprintf(stream, "\033[%de", lettersize / 2);
			}
			if (underline || doubleunder)
				bufprintf(stream, "\033[24m");
			if (forcedchar) {
				bufprintf(stream, "\033[%22m");
				kanjiin(stream);
				bufprintf(stream, "\033[%22m");
				kanjiout(stream);
			}
			if (amikake) bufprintf(stream, "\033[25m");
			if (exclusive) bufprintf(stream, "\033[27m");
			if (outline) bufprintf(stream, "\033[?27m");
			if (patternfill) bufprintf(stream, "\033[?25m");
			if (shadow) bufprintf(stream, "\033[?26m");

			widesize = longsize = broadsize = topscript =
			subscript = underline = doubleunder = forcedchar =
			amikake = exclusive = outline = patternfill = shadow =
			kumimoji = parentheses = 0;

			if (!column && linep) {
				bufflush(stream);
				return(c);
			}
			else if (c == '\n') {
				linefeed(stream);
				return(c);
			}
		}
		else if (buffer == controlchar) {
			buffer = '\0';
			c = control(c, stream);
			if (!c) return(c);
		}
		else if (!kanjiflag && c == controlchar) {
			buffer = c;
			return(c);
		}
		else if (kumimoji) {
			if (buffer) {
				if (kanjiflag) linep -= 2;
				bufprintf(stream, "\033[%d S", isvertical | 3);
				if (kanjiflag) {
					bufprintf(stream, "\033[1;%d$q",
						lettersize);
					kanjiflag = 0;
					foldputc(buffer, stream);
					kanjiflag = 1;
					column++;
				}
				else {
					bufprintf(stream, "\033[2;%d$q",
						lettersize);
					kanjiflag = 1;
					foldputc(buffer, stream);
					kanjiflag = 0;
					foldputc(c, stream);
				}
				bufprintf(stream, "\033[%d S ", isvertical);
				buffer = '\0';
				kumimoji = 0;
				if (kanjiflag) kanjiin(stream);
				else return(c);
			}
			else if (kanjiflag) kumimoji = 0;
			else {
				buffer = c;
				return(c);
			}
		}
	}

	if (!kanjiflag) {
		buffer = '\0';
		return(foldputc(c, stream));
	}
	else if (kanjiflag == 1) {
		buffer = c;
		return(c);
	}

	if (kanjimode == EUC) {
		if (buffer == 0x8e) {
			buffer = '\0';
			kanjiflag = 0;
			return(foldputc(c, stream));
		}
		buffer &= 0x7f;
		c &= 0x7f;
	}
	else if (kanjimode == SJIS) {
		c1 = buffer * 2 - ((buffer <= 0x9f) ? 0xe1 : 0x161);
		c2 = c;
		if (c < 0x9f) c2 -= (c > 0x7f) ? 0x20 : 0x1f;
		else {
			c1++;
			c2 -= 0x7e;
		}
		buffer = c1;
		c = c2;
	}

	kanjiflag = 1;
	keisenno = -1;
	if (isconcat) {
		kanji = buffer * 0x100 + c;
		if (kanji >= 0x2821 && kanji <= 0x2840)
			keisenno = kanji - 0x2821;
		else if (kanji >= 0x2c24 && kanji <= 0x2c6f)
			keisenno = kanji - 0x2c24 + 98;
		c1 = c2 = 0x21;
	}
	if (keisenno >= 0) {
		buffer = c1;
		nextch = c = c2;
		mode = 0;
		if (keisenno < 98) direction = keisen_line[keisenno];
		else {
			keisenno -= 98;
			direction = keisen_line98[keisenno];
			if (keisenno >= 4 && keisenno <= 11)
				mode = 3 - (keisenno / 4);
		}
		for (i = 0; i < 4; i++) {
			if (direction & 0x01) width[i] = THINKEISEN;
			else if (direction & 0x10) width[i] = THICKKEISEN;
			else width[i] = 0;
			direction /= 2;
		}
		forcedlinefeed(buffer, stream);
		if (width[0] && width[0] == width[3]) {
			keisen(1, 7, width[0], mode, stream);
			width[0] = width[3] = 0;
		}
		if (width[1] && width[1] == width[2]) {
			keisen(3, 5, width[1], mode, stream);
			width[1] = width[2] = 0;
		}
		for (i = 0; i < 4; i++) if (width[i])
			keisen(4, i * 2 + 1, width[i], mode, stream);
	}
	nextch = c;
	foldputc(buffer, stream);
	buffer = '\0';
	kanjiflag = 2;
	return(foldputc(c, stream));
}
