/*
 *	dosprn.c
 *
 *	MS-DOS Printer Driver
 */

#include "lipsf.h"
#include <dos.h>
#include <stdarg.h>
#include <errno.h>

#define MAXCOLS 512
#define	RETRY	32

#define	PRN98	0x1a
#define	PRNJ31	0x17
#define	PRNDOSV	0x17

extern FILE *null;

#ifdef	PC98
int nohighreso;
#endif

int lopen(VOID_A);
int lputc(int, FILE *);
int lprintf(FILE *, CONST u_char *, ...);


int lopen(VOID_A)
{
	union REGS in, out;

#ifdef	PC98
	nohighreso = ((*(char far *)0x00000501) & 0x08) ? 0x00 : 0x01;
	in.h.ah = 0x10;
	int86(PRN98, &in, &out);
	return(out.h.al);
#else
	in.h.ah = 0x01;
	in.x.dx = 0;
	int86(PRNDOSV, &in, &out);
	return(out.h.ah);
#endif
} 

int lputc(c, stream)
int c;
FILE *stream;
{
	union REGS in, out;
	int i;

	if (stream) {
		if (stream != null) c = fputc(c, stream);
	}
	else {
		for (i = 0; i < RETRY; i++) {
			in.h.al = (u_char)c;
#ifdef	PC98
			in.h.ah = 0x11;
			int86(PRN98, &in, &out);
			if (out.h.ah == nohighreso) break;
#endif
#ifdef	J3100
			in.h.ah = 0x84;
			in.x.dx = 0;
			int86(PRNJ31, &in, &out);
			if (!(out.h.ah & 0x29)) break;
#endif
#ifdef	DOSV
			in.h.ah = 0x00;
			in.x.dx = 0;
			int86(PRNDOSV, &in, &out);
			if (out.h.ah == 0x90) break;
#endif
		}
		if (i >= RETRY) {
			errno = ENODEV;
			return(EOF);
		}
	}
	return(c);
}

int lprintf(FILE *stream, CONST u_char *fmt, ...)
{
	va_list args;
	int i, len;
	u_char buf[MAXCOLS];

	va_start(args, fmt);

	if (stream) {
		if (stream != null) {
			if ((len = vfprintf(stream, fmt, args)) == EOF)
				return(EOF);
		}
		else {
			vsprintf(buf, fmt, args);
			len = strlen(buf);
		}
	}
	else {
		vsprintf(buf, fmt, args);
		for (i = 0; buf[i]; i++)
			if (lputc(buf[i], NULL) == EOF) return(EOF);
		len = i;
	}
	va_end(args);
	return(len);
}
