/*
 *	input.c
 *
 *	Input Module
 */

#include "lipsf.h"
#include "term.h"
#include "var.h"
#include "kanji.h"

#if	MSDOS
#include <conio.h>
#endif

#define	MAXLINESTR	80

#ifndef	DECLERRLIST
extern char *sys_errlist[];
#endif

int menu __P_((int));
static int onkanji1 __P_((u_char *, int));
static int rightchar __P_((u_char *, int, int, int, int, int, int));
static int leftchar __P_((u_char *, int, int, int, int, int, int));
static VOID insertchar __P_((u_char *, int, int, int, int, int, int));
static VOID deletechar __P_((u_char *, int, int, int, int, int, int));
static VOID truncline __P_((int, int, int, int, int));
static VOID displaystr __P_((u_char *, int, int, int, int));
int inputstr __P_((u_char *, int, int, int, int, int));
char *inputstr2 __P_((char *));
int yesno __P_((char *));
int warning __P_((int, char *));
VOID shownum __P_((int, int, int, int, int, int));
int inputnum __P_((int *, int, int, int, int, int, int));
int selectstr __P_((int *, int, int, int, char *[], int [], int));

extern VOID error __P_((int));
extern char *strdup2 __P_((char *));


int menu(no)
int no;
{
	char *str[8];
	char key[8];
	int i, new, old;
	int ch;

	key[0] = 'F'; str[0] = FILE_K;
	key[1] = 'H'; str[1] = HEAD_K;
	key[2] = 'L'; str[2] = LOAD_K;
	key[3] = 'P'; str[3] = PRINT_K;
	key[4] = 'S'; str[4] = STYLE_K;
	key[5] = 'O'; str[5] = OPTIO_K;
	key[6] = 'R'; str[6] = SAVE_K;
	key[7] = 'Q'; str[7] = OVER_K;

	for (i = 0; i < 8; i++) {
		locate((i % 4) * 18 + 6, (i / 4) + n_line - 3);
		if (i == no) putterm(t_standout);
		cprintf2("%c: %s", key[i], str[i]);
		if (i == no) putterm(end_standout);
	}

	new = old = no;

	do {
		if (old != new) {
			locate((new % 4) * 18 + 6, (new / 4) + n_line - 3);
			putterm(t_standout);
			cprintf2("%c: %s", key[new], str[new]);
			putterm(end_standout);
			locate((old % 4) * 18 + 6, (old / 4) + n_line - 3);
			cprintf2("%c: %s", key[old], str[old]);
		}

		old = new;
		locate((old % 4) * 18 + 6, (old / 4) + n_line - 3);
		tflush();

		keyflush();
		ch = getkey2(0);
		if (ch >= 'a' && ch <= 'z') ch += 'A' - 'a';
		for (i = 0; i < 8; i++) {
			if (ch == key[i]) {
				locate((i % 4) * 18 + 6, (i / 4) + n_line - 3);
				putterm(t_underline);
				cprintf2("%c: %s", key[i], str[i]);
				putterm(end_underline);
				return(i);
			}
		}
		switch (ch) {
			case ESC:
				return(7);
				/*NOTREACHED*/
				break;
			case CTRL('P'):
			case K_UP:
				if (old > 3) new = old - 4;
				break;
			case CTRL('N'):
			case K_DOWN:
				if (old < 4) new = old + 4;
				break;
			case CTRL('F'):
			case K_RIGHT:
				new = (old + 1) % 8;
				break;
			case CTRL('B'):
			case K_LEFT:
				new = (old + 7) % 8;
				break;
			default:
				break;
		}
	} while (ch != CR);

	locate((old % 4) * 18 + 6, (old / 4) + n_line - 3);
	putterm(t_underline);
	cprintf2("%c: %s", key[old], str[old]);
	putterm(end_underline);

	tflush();
	return(old);
}

static int onkanji1(str, cx)
u_char *str;
int cx;
{
	int i;

	if (cx < 0) return(0);
	if (!cx) return(iskanji1(str[0]));

	for (i = 0; i < cx; i++) if (iskanji1(str[i])) i++;
	if (i > cx) return(0);
	return(iskanji1(str[cx]));
}

static int rightchar(str, x, y, cx, len, linemax, max)
u_char *str;
int x, y, cx, len, linemax, max;
{
	int i;

	if (iskanji1(str[cx])) {
		if (cx + 1 >= len) {
			putterm(t_bell);
			return(cx);
		}
		cx += 2;
		i = cx % linemax;
		if (i <= 1 && cx < max) locate(x + i, y + cx / linemax);
		{
			putterm(c_right);
			putterm(c_right);
		}
	}
	else {
		if (++cx % linemax || cx >= max)
			putterm(c_right);
		else locate(x, y + cx / linemax);
	}
	return(cx);
}

/*ARGSUSED*/
static int leftchar(str, x, y, cx, len, linemax, max)
u_char *str;
int x, y, cx, len, linemax, max;
{
	int i;

	if (onkanji1(str, cx - 2)) {
		i = cx % linemax;
		cx -= 2;
		if (i <= 1) locate(x + linemax + i - 2, y + cx / linemax);
		else {
			putterm(c_left);
			putterm(c_left);
		}
	}
	else {
		if (cx-- % linemax) putterm(c_left);
		else locate(x + linemax - 1, y + cx / linemax);
	}
	return(cx);
}

static VOID insertchar(str, x, y, cx, len, linemax, ins)
u_char *str;
int x, y, cx, len, linemax, ins;
{
	int dy, i, j, f1, f2;

	len += ins;
	dy = cx / linemax;
	i = (dy + 1) * linemax;

	if (*c_insert) {
		for (j = 0; j < ins; j++) putterm(c_insert);

		if (i < len) {
			while (i < len) {
				f1 = (onkanji1(str, i - ins - 1)) ? 1 : 0;
				f2 = (onkanji1(str, i - 1)) ? 1 : 0;
				if (x + linemax < n_column) {
					locate(x + linemax, y + dy);
					if (f1) putterm(c_right);
					else putch2(' ');
					for (j = 1; j < ins + f2; j++)
						putch2(' ');
				}
				locate(x, y + ++dy);
				for (j = 0; j < ins; j++) putterm(c_insert);
				if (f1) putterm(c_right);
				else putch2(str[i - ins]);
				for (j = 1; j < ins + f2; j++)
					putch2(str[i + j - ins]);
				i += linemax;
			}
			locate (x + cx % linemax, y + cx / linemax);
		}
	}
	else {
		for (j = 0; j < ins; j++) putch2(' ');

		if (i >= len) i = cx + ins;
		else {
			f1 = (onkanji1(str, i - ins - 1)) ? 1 : 0;
			f2 = (onkanji1(str, i - 1)) ? 1 : 0;

			j = linemax - cx % linemax - ins + f1;
			if (j > 0) cprintf2("%-*.*s", j, j, &str[cx]);
			if (f2 && !f1) putch2(' ');

			locate(x, y + ++dy);
			if (f1) putch2(' ');
			else putch2(str[i - ins]);
			i += linemax;

			while (i < len) {
				f1 = (onkanji1(str, i - ins - 1)) ? 1 : 0;
				f2 = (onkanji1(str, i - 1)) ? 1 : 0;
				j = linemax + f1 - 1;
				cprintf2("%-*.*s", j, j,
					&str[i - linemax - ins + 1]);
				if (f2 && !f1) putch2(' ');

				locate(x, y + ++dy);
				if (f1) putch2(' ');
				else putch2(str[i - ins]);
				i += linemax;
			}
			i -= linemax - 1;
		}

		j = len - i;
		if (j > 0) cprintf2("%-*.*s", j, j, &str[i - ins]);
		locate (x + cx % linemax, y + cx / linemax);
	}
}

static VOID deletechar(str, x, y, cx, len, linemax, del)
u_char *str;
int x, y, cx, len, linemax, del;
{
	int dy, i, j, f1, f2;

	len -= del;
	dy = cx / linemax;
	i = (dy + 1) * linemax;

	if (*c_delete) {
		for (j = 0; j < del; j++) putterm(c_delete);

		if (i < len) {
			while (i < len) {
				f1 = (onkanji1(str, i + del - 1)) ? 1 : 0;
				f2 = (onkanji1(str, i - 1)) ? 1 : 0;
				locate(x + linemax - del, y + dy);
				if (f2) putterm(c_right);
				else putch2(str[i]);
				for (j = 1; j < del + f1; j++)
					putch2(str[i + j]);
				locate(x, y + ++dy);
				for (j = 0; j < del; j++) putterm(c_delete);
				if (f1) putch2(' ');
				i += linemax;
			}
			locate (x + cx % linemax, y + cx / linemax);
		}
	}
	else {
		if (i >= len) i = cx;
		else {
			f1 = (onkanji1(str, i + del - 1)) ? 1 : 0;
			f2 = (onkanji1(str, i - 1)) ? 1 : 0;

			j = linemax - cx % linemax + f1;
			cprintf2("%-*.*s", j, j, &str[cx + del]);
			if (f2 && !f1) putch2(' ');

			locate(x, y + ++dy);
			if (f1) putch2(' ');
			else putch2(str[i + del]);
			i += linemax;

			while (i < len) {
				f1 = (onkanji1(str, i + del - 1)) ? 1 : 0;
				f2 = (onkanji1(str, i - 1)) ? 1 : 0;
				j = linemax + f1 - 1;
				cprintf2("%-*.*s", j, j,
					&str[i - linemax + del + 1]);
				if (f2 && !f1) putch2(' ');

				locate(x, y + ++dy);
				if (f1) putch2(' ');
				else putch2(str[i - linemax + del]);
				i += linemax;
			}
			i -= linemax - 1;
		}

		j = len - i;
		if (j > 0) {
			cprintf2("%-*.*s", j, j, &str[i + del]);
			if (!(len % linemax)) locate(x, y + ++dy);
		}
		for (j = 0; j < del; j++) putch2(' ');

		locate (x + cx % linemax, y + cx / linemax);
	}
}

static VOID truncline(x, y, cx, len, linemax)
int x, y, cx, len, linemax;
{
	int dy, i;

	putterm(l_clear);

	dy = cx / linemax;
	if ((dy + 1) * linemax < len) {
		for (i = (dy + 1) * linemax; i < len; i += linemax) {
			locate(x, y + ++dy);
			putterm(l_clear);
		}
		locate (x + cx % linemax, y + cx / linemax);
	}
}

static VOID displaystr(str, x, y, len, linemax)
u_char *str;
int x, y, len, linemax;
{
	int cx, i;

	locate(x, y);
	putterm(l_clear);
	if (len) {
		i = linemax;
		for (cx = 0; cx + linemax < len; cx += i) {
			i = linemax;
			if (onkanji1(str, cx + linemax - 1)) i++;
			cprintf2("%-*.*s", i, i, str + cx);
			locate(x + i - linemax, y + cx / linemax + 1);
		}
		cputs2(str + cx);
	}
}

int inputstr(str, x, y, max, linemax, flag)
u_char *str;
int x, y, max, linemax, flag;
{
	int len, cx, i;
	int ch, ch2;

	displaystr(str, x, y, len = strlen(str), linemax);

	if (!flag) return('\0');
	keyflush();
	cx = len;

	do {
		tflush();
		switch (ch = getkey2(0)) {
			case CTRL('F'):
			case K_RIGHT:
				keyflush();
				if (cx >= len) putterm(t_bell);
				else cx = rightchar(str, x, y, cx,
					len, linemax, max);
				break;
			case CTRL('B'):
			case K_LEFT:
				keyflush();
				if (cx <= 0) putterm(t_bell);
				else cx = leftchar(str, x, y, cx,
					len, linemax, max);
				break;
			case CTRL('A'):
				keyflush();
				locate(x, y);
				cx = 0;
				break;
			case CTRL('E'):
				keyflush();
				cx = len;
				if (cx < max) locate(x + cx % linemax,
					y + cx / linemax);
				else {
					locate(x + cx % linemax + linemax - 1,
						y + cx / linemax - 1);
					putterm(c_right);
				}
				break;
			case K_BS:
				keyflush();
				if (cx <= 0) {
					putterm(t_bell);
					break;
				}
				cx = leftchar(str, x, y, cx,
					len, linemax, max);
			case K_DC:
			case CTRL('D'):
				keyflush();
				if (cx >= len) {
					putterm(t_bell);
					break;
				}
				if (iskanji1(str[cx])) {
					if (cx + 1 >= len) {
						putterm(t_bell);
						break;
					}
					deletechar(str, x, y, cx,
						len, linemax, 2);
					for (i = cx; i < len - 2; i++)
						str[i] = str[i + 2];
					len -= 2;
					break;
				}
				deletechar(str, x, y, cx, len, linemax, 1);
				for (i = cx; i < len - 1; i++)
					str[i] = str[i + 1];
				len--;
				break;
			case CTRL('K'):
				keyflush();
				if (cx >= len) putterm(t_bell);
				else {
					truncline(x, y, cx, len, linemax);
					len = cx;
				}
				break;
			case CTRL('L'):
				keyflush();
				displaystr(str, x, y, len, linemax);
				locate (x + cx % linemax, y + cx / linemax);
				break;
			case CTRL('P'):
				ch = K_UP;
			case K_UP:
				keyflush();
				if (cx < linemax) break;
				ch = '\0';
				cx -= linemax;
				putterm(c_up);
				if (onkanji1(str, cx - 1)) {
					putterm(c_left);
					cx--;
				}
				break;
			case CTRL('N'):
				ch = K_DOWN;
			case K_DOWN:
				keyflush();
				if (cx + linemax >= len) break;
				ch = '\0';
				cx += linemax;
				putterm(c_down);
				if (onkanji1(str, cx - 1)) {
					putterm(c_left);
					cx--;
				}
				break;
			case CR:
			case ESC:
				keyflush();
				break;
			default:
				if (iskanji1(ch)) {
					ch2 = getkey2(0);
					if (len + 1 >= max) {
						putterm(t_bell);
						keyflush();
						break;
					}
					insertchar(str, x, y, cx,
						len, linemax, 2);
					for (i = len + 1; i > cx; i--)
						str[i] = str[i - 2];
					len += 2;
					str[cx] = ch;
					str[++cx] = ch2;
					putch2(ch);
					putch2(ch2);
					i = (++cx % linemax);
					if (i < 2 && len < max)
						locate(x + i,
							y + cx / linemax);
					break;
				}

				if (ch < ' ' || len >= max) {
					putterm(t_bell);
					keyflush();
					break;
				}

				insertchar(str, x, y, cx, len, linemax, 1);
				for (i = len; i > cx; i--)
					str[i] = str[i - 1];
				len++;

				str[cx] = ch;
				putch2(ch);
				if (!(++cx % linemax) && len < max)
					locate(x, y + cx / linemax);
				break;
		}
	} while (ch != ESC && ch != CR && ch != K_UP && ch != K_DOWN);

	if (ch == ESC) len = 0;
	str[len] = '\0';

	tflush();
	return(ch);
}

char *inputstr2(prompt)
char *prompt;
{
	char *dup; 
	u_char input[MAXLINESTR + 2];
	int len;
	int ch;

	locate(0, 1);
	cputs2("  ");
	putterm(t_standout);
	cputs2(prompt);
	putterm(end_standout);
	putterm(l_clear);
	tflush();

	len = strlen(prompt);
	*input = '\0';
	ch = inputstr(input, len + 2, 1,
		MAXLINESTR - len - 3, MAXLINESTR - len - 3, 1);
	locate(0, 1);
	putterm(l_clear);

	if (ch == ESC) return(NULL);
	if (!(dup = strdup2((char *)input))) error(-1);

	tflush();
	return(dup);
}

int yesno(str)
char *str;
{
	int len;
	int ret = 1;
	int ch;

	locate(0, n_line - 1);
	putterm(l_clear);
	cputs2("  ");
	putterm(t_standout);
	cputs2(str);
	putterm(end_standout);
	len = strlen(str);
	locate(len + 2, n_line - 1);
	putterm(t_standout);
	cputs2("[Y/N]");
	putterm(end_standout);
	tflush();

	do {
		keyflush();
		locate(len + 3 + (1 - ret) * 2, n_line - 1);
		tflush();
		ch = getkey2(0);
		if (ch >= 'a' && ch <= 'z') ch += 'A' - 'a';
		switch (ch) {
			case 'Y':
				ret = 1;
				ch = CR;
				break;
			case 'N':
			case ' ':
			case ESC:
				ret = 0;
				ch = CR;
				break;
			case CTRL('F'):
			case K_RIGHT:
				ret = 0;
				break;
			case CTRL('B'):
			case K_LEFT:
				ret = 1;
				break;
			default:
				break;
		}
	} while (ch != CR);

	locate(0, n_line - 1);
	putterm(l_clear);

	tflush();
	return(ret);
}

int warning(no, str)
int no;
char *str;
{
	char *tmp, *err;
	int ret;

	if (no < 0) no = errno;
	err = (char *)sys_errlist[no];
	if (!str) tmp = err;
	else {
		if (!(tmp = (char *)malloc(strlen(str) + strlen(err) + 3)))
			error(-1);
		strcpy(tmp, str);
		strcat(tmp, ": ");
		strcat(tmp, err);
	}
	putterm(t_bell);
	ret = yesno(tmp);
	if (str) free(tmp);
	return(ret);
}

VOID shownum(num, x, y, maxcol, def, so)
int num, x, y, maxcol, def, so;
{
	char tmp[10];

	locate(x, y);
	if (so) putterm(t_standout);
	sprintf(tmp, "%d", num);
	if (def <= -9999) {
		cprintf2("%*.*s", maxcol, maxcol, tmp);
		putterm(end_standout);
	}
	else {
		if (num < 0) {
			if (def >= 0) sprintf(tmp, "%d", def);
			else {
				strcpy(tmp, "!!!!!");
				putterm(t_standout);
			}
		}
		cprintf2("%*.*s", maxcol, maxcol, tmp);
		putterm(end_standout);
		locate(x + maxcol + 6, y);
		if (num >= 0) cputs2("      ");
		else {
			putterm(t_underline);
			cputs2("(AUTO)");
			putterm(end_underline);
		}
		locate(x + maxcol, y);
	}
	tflush();
}

int inputnum(num, min, max, x, y, maxcol, def)
int *num, min, max, x, y, maxcol, def;
{
	static int old, col, oldcol;
	int ch;

	if (!maxcol) {
		old = *num;
		col = 0;
		oldcol = 1;
		return('\0');
	}

	if (col) locate(x + col, y);
	else {
		if (oldcol <= 0 && *num == old) locate(x + maxcol, y);
		else shownum(*num, x, y, maxcol, def, 1);
	}
	tflush();
	old = *num;
	oldcol = col;

	switch (keyflush(), ch = getkey2(0)) {
		case CTRL('F'):
		case K_RIGHT:
			col = 0;
			if (def > 0 && old >= max) *num = -1;
			else if (old >= min && old < max) *num = old + 1;
			else *num = min;
			break;
		case CTRL('B'):
		case K_LEFT:
			col = 0;
			if (def > 0 && old <= min && old >= 0) *num = -1;
			else if (old <= max && old > min) *num = old - 1;
			else *num = max;
			break;
		case '\t':
			if (def == -9999) break;
			col = 0;
			*num = -1;
			break;
		case '-':
			if (col > 0)  break;
			col++;
			*num = 0;
			locate(x, y);
			cprintf2("%*s", maxcol, " ");
			locate(x, y);
			putterm(t_underline);
			putch2(ch);
			putterm(end_underline);
			break;
		case CTRL('P'):
			ch = K_UP;
			break;
		case CTRL('N'):
			ch = K_DOWN;
			break;
		case '0':
			if (!col) break;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			if (col >= maxcol) break;
			else if (!col) old = 0;
			*num = old * 10;
			if ((col > 0 && !old) || old < 0)
				*num -= ch - '0';
			else *num += ch - '0';
			if (!col) {
				locate(x, y);
				cprintf2("%*s", maxcol, " ");
			}
			locate(x + col, y);
			putterm(t_underline);
			putch2(ch);
			putterm(end_underline);
			col++;
			break;
		default:
			break;
	}

	if (ch != ESC && ch != CR && ch != K_UP && ch != K_DOWN) ch = '\0';
	else {
		if (*num > max) *num = max;
		if (*num < min && (!def || *num >= 0)) *num = min;
		shownum(*num, x, y, maxcol, def, 0);
	}

	tflush();
	return(ch);
}

int selectstr(num, max, x, y, str, val, flag)
int *num, max, x, y;
char *str[];
int val[], flag;
{
	int i, xx[11];
	static int old, new;
	int ch;

	xx[0] = 0;
	for (i = 0; i < max; i++)
		xx[i + 1] = xx[i] + strlen(str[i]) + 1;

	if (flag < 0) {
		for (i = 0; i < max; i++) if (val[i] == *num) {
			locate(x + xx[i], y);
			cputs2(str[i]);
			return('\0');
		}
	}
	else if (!flag) {
		for (i = 0; i < max; i++) {
			locate(x + xx[i], y);
			if (val[i] != *num) cputs2(str[i]);
			else {
				new = old = i;
				putterm(t_standout);
				cputs2(str[i]);
				putterm(end_standout);
			}
		}
		return('\0');
	}

	if (new != old) {
		locate(x + xx[new], y);
		putterm(t_standout);
		cputs2(str[new]);
		putterm(end_standout);
		locate(x + xx[old], y);
		cputs2(str[old]);
	}

	locate(x + xx[new + 1] - 1, y);
	tflush();
	old = new;

	switch (keyflush(), ch = getkey2(0)) {
		case CTRL('F'):
		case K_RIGHT:
			if (old < max - 1) new = old + 1;
			else new = 0;
			break;
		case CTRL('B'):
		case K_LEFT:
			if (old > 0) new = old - 1;
			else new = max - 1;
			break;
		case CTRL('P'):
			ch = K_UP;
			break;
		case CTRL('N'):
			ch = K_DOWN;
			break;
		default:
			break;
	}
	*num = val[new];
	if (ch != ESC && ch != CR && ch != K_UP && ch != K_DOWN) ch = '\0';
	else for (i = 0; i < max; i++) {
		locate(x + xx[i], y);
		if (val[i] == *num) cputs2(str[i]);
		else cprintf2("%*s", strlen(str[i]), " ");
	}

	tflush();
	return(ch);
}
