/*
 *	Configuration File for LIPSF
 */


/*
 *	2: LIPS II+, 3: LIPS III
 */
#define	LIPSMODE	3

/*
 *	0: Auto Cassette, 1: Manual Tray, 2: Lower Cassette, 3: Upper Cassette
 */
#define	CASSETTE	0

/*
 *	0: Portrait, 1: Landscape
 */
#define	ISLANDSCAPE	0

/*
 *	0: Horizontal Kanji Mode, 4: Virtical Kanji Mode
 */
#define	ISVERTICAL	0

/*
 *	0: Normal Keisen Mode, 1: Keisen Concatination Mode
 */
#define	ISCONCAT	0

/*
 *	80: Mincho, 81: Gothic, 82: Round Gothic
 */
#define	FONTPATTERN	80

/*
 *	12: A3, 14: A4, 16: A5, 18: Hagaki, 24: B4, 26: B5
 */
#define	PAPERSIZE	14

#define	LETTERSIZE	40
#define	LINEHEIGHT	8
#define	COLUMNWIDTH	2
#define	PRINTNUM	1
#define	TOPMARGIN	10
#define	BOTTOMMARGIN	10
#define	LEFTMARGIN	10
#define	RIGHTMARGIN	10
#define	TABPOSITION	8
#define	CONTROLCHAR	'\0'
#define	HEADERMARGIN	10
#define	FOOTERMARGIN	10
#define	MAXSTEPS	1
#define	FIRSTPAGE	1

/*
 *	0: Normal Numeric Mode, 1: Zero Suppress Mode
 */
#define	ISZEROSUP	0

/*
 *	0: Normal Numeric Mode, 1: Kanji Numeric Mode
 */
#define	ISKANJINUM	0

/*
 *	0: Normal Filename Mode, 1: Uppercase Filename Mode
 */
#define	ISTOUPPER	0

/*
 *	0: Normal Filename Mode, 1: Lowercase Filename Mode
 */
#define	ISTOLOWER	0

/*
 *	0: No Overlay, 1: Registor on 1, 2: Registor on 2
 *	3: Printout from 1, 4: Printout from 2, 5: Printout from 1 + 2
 */
#define	OVERLAY		0

/*
 *	A4 printer owner should better comment out bellow
 */
#define	A3PRINTER

/*
 *	Revive this comment out to print EUC file
 */
/* #define	CODEEUC */


/*                              */
/* DO NOT DELETE or EDIT BELLOW */
/*                              */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "machine.h"

#ifndef	NOSTDLIBH
#include <stdlib.h>
#endif

#ifdef	A3PRINTER
#define	MAXPAPERWIDTH	297
#define	MAXPAPERHEIGHT	432
#else
#define	MAXPAPERWIDTH	257
#define	MAXPAPERHEIGHT	364
#endif

#define	MINPAPERWIDTH	100
#define	MINPAPERHEIGHT	148

#define	MINLETTERSIZE	10
#define	MAXLETTERSIZE	420
#define	MINMAXCOLUMNS	0
#define	MAXMAXCOLUMNS	372
#define	MINMAXLINES	0
#define	MAXMAXLINES	263
#define	MINLINEHEIGHT	-99
#define	MAXLINEHEIGHT	999
#define	MINCOLUMNWIDTH	-99
#define	MAXCOLUMNWIDTH	999
#define	MINPRINTNUM	1
#define	MAXPRINTNUM	999
#define	MINTOPMARGIN	5
#define	MAXTOPMARGIN	200
#define	MINBOTTOMMARGIN	6
#define	MAXBOTTOMMARGIN	200
#define	MINLEFTMARGIN	5
#define	MAXLEFTMARGIN	200
#define	MINRIGHTMARGIN	6
#define	MAXRIGHTMARGIN	200
#define	MINHEADERMARGIN	0
#define	MAXHEADERMARGIN	99
#define	MINFOOTERMARGIN	0
#define	MAXFOOTERMARGIN	99
#define	MINTABPOSITION	0
#define	MAXTABPOSITION	80
#define	MAXMAXSTEPS	4
#define	MINMAXSTEPS	1
#define	MINSTEPCOLUMNS	0
#define	MAXSTEPCOLUMNS	200
#define	MINFIRSTPAGE	-9
#define	MAXFIRSTPAGE	999
#define	MINSTARTPAGE	1
#define	MAXSTARTPAGE	999
#define	MINENDPAGE	1
#define	MAXENDPAGE	999

#define	ASCII	0
#define	SJIS	1
#define	JIS	2
#define	EUC	3

#define	KINSOKUBOL	"!),.>?]}"
#define	KINSOKUBOLKANA	"\241\243\244"
#define	KINSOKUBOLSJIS	"\201A\201B\201C\201D\201H\201I\201f\201h\201j\201l\201n\201p\201r\201t\201v\201x\201z\201\204"
#define	KINSOKUBOLJIS	"!\"!#!$!%!)!*!G!I!K!M!O!Q!S!U!W!Y![!d"
#define	KINSOKUBOLEUC	"\241\242\241\243\241\244\241\245\241\251\241\252\241\307\241\311\241\313\241\315\241\317\241\321\241\323\241\325\241\327\241\331\241\333\241\344\216\241\216\243\216\244"
#define	KINSOKUEOL	"(<[{"
#define	KINSOKUEOLKANA	"\242"
#define	KINSOKUEOLSJIS	"\201e\201g\201i\201k\201m\201o\201q\201s\201u\201w\201y\201\203"
#define	KINSOKUEOLJIS	"!F!H!J!L!N!P!R!T!V!X!Z!c"
#define	KINSOKUEOLEUC	"\241\306\241\310\241\312\241\314\241\316\241\320\241\322\241\324\241\326\241\330\241\332\241\343\216\242"

#define	A3WIDTH		297
#define	A3HEIGHT	420
#define	A4WIDTH		210
#define	A4HEIGHT	297
#define	A5WIDTH		148
#define	A5HEIGHT	210
#define	HAGAKIWIDTH	100
#define	HAGAKIHEIGHT	148
#define	B4WIDTH		257
#define	B4HEIGHT	364
#define	B5WIDTH		182
#define	B5HEIGHT	257

#define	THINKEISEN	2
#define	THICKKEISEN	5

#ifdef	NOUID_T
typedef u_short	uid_t;
typedef u_short	gid_t;
#endif

#ifdef	NOVOID
#define	VOID
#define	VOID_T	int
#define	VOID_P	char *
#else
#define	VOID	void
#define	VOID_T	void
#define	VOID_P	void *
#endif

#ifdef	USEDIRECT
#define	dirent	direct
#endif

#ifdef	NOFILEMODE
#define	S_IRUSR	00400
#define	S_IWUSR	00200
#define	S_IXUSR	00100
#define	S_IRGRP	00040
#define	S_IWGRP	00020
#define	S_IXGRP	00010
#define	S_IROTH	00004
#define	S_IWOTH	00002
#define	S_IXOTH	00001
#endif

#ifdef	NOERRNO
extern int errno;
#endif

#if	MSDOS
#define	LPRPRINTER	NULL
#define	NULLDEVICE	"NUL"
#define	LIPSF		"LIPSF.EXE"
#define	POLS		"POLS.EXE"
#define	POLSEXT		"PLS"
#include <jctype.h>
#define	issjis1(c)	iskanji(c)
#else
#define	LPRPRINTER	"lipsf"
#define	NULLDEVICE	"/dev/null"
#define	LIPSF		"lipsf"
#define	POLS		"pols"
#define	POLSEXT		"pls"
#endif

#if defined (IRIX)
#define	LPRPATH	"/usr/bsd/lpr"
#endif
#if defined (LINUX) \
|| defined (FREEBSD) || defined (NETBSD) || defined (OPENBSD)
#define	LPRPATH	"/usr/bin/lpr"
#endif
#ifndef	LPRPATH
#define	LPRPATH	"/usr/ucb/lpr"
#endif

#ifdef	CODEEUC
#define	DEF_KCODE	EUC
#define	iskanji1(c)	iseuc(c)
#else
#define	DEF_KCODE	SJIS
#define	iskanji1(c)	issjis1(c)
#endif

#ifndef	issjis1
#define	issjis1(c)	((0x81 <= (c) && (c) <= 0x9f) || (0xe0 <= (c) && (c) <= 0xfc))
#endif

#ifndef	iseuc
#define	iseuc(c)	(0xa1 <= (c) && (c) <= 0xfe)
#endif

#define	issjkana(c)	(0xa1 <= (c) && (c) <= 0xdf)

#define	P_FF	0x0c	/* \014 */
#define	P_SO	0x0e	/* \016 */
#define	P_SI	0x0f	/* \017 */
#define	P_ESC	0x1b	/* \033 */

#define	kanjiin(fp)	bufprintf(fp, "\033n")
#define	kanjiout(fp)	bufputc(P_SI, fp)
