/*
 *	style.c
 *
 *	Style Arrangement Module
 */

#include "lipsf.h"
#include "term.h"
#include "var.h"
#include "kanji.h"

#if	MSDOS
#include <dos.h>
#endif

#define	MAXHEADLEN	120
#define	MAXFILELEN	16
#define	MAXTITLELEN	60
#define	STYLENUM	23
#define	HEADFOOTNUM	9
#define	OPTIONNUM	9
#define	DOPRINTNUM	7
#define	AUTOSNUM	13
#define	NITEM(ar)	(sizeof(ar) / sizeof(char *))

typedef struct _styleinfo {
	int *obj, min, max, x, y, col;
	char *name, *unit, kind;
} styleinfo;

static int stepwidth;
static int printwidth;
static int printheight;
static int charwidth;
static int charheight;
static int autorightmargin;
static int autobottommargin;
static int isredirect = 0;
static int outputmode = 0;
static u_char headerbody[MAXHEADLEN + 1] = "";
static u_char footerbody[MAXHEADLEN + 1] = "";
static u_char styletitlebody[MAXTITLELEN + 1] = "";
#if	MSDOS
static int outputlptno = 0;
static char *outputlpt[] = {
	"local",
	"LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"
};
#endif
static u_char outputprn[MAXFILELEN + 1] = "";
static u_char outputfile[MAXFILELEN + 1] = "";

static char *ifdo[] = {NOTDO_K, DODO_K};
static int sequence[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
#ifdef	A3PRINTER
static char *size[] = {A3SIZ_K, A4SIZ_K, A5SIZ_K,
		HAGAK_K, B4SIZ_K, B5SIZ_K, FREE_K};
static int nsize[] = {12, 14, 16, 18, 24, 26, 80};
#else
static char *size[] = {A4SIZ_K, A5SIZ_K, HAGAK_K, B4SIZ_K, B5SIZ_K, FREE_K};
static int nsize[] = {14, 16, 18, 24, 26, 80};
#endif
static char *land[] = {PORTR_K, LANDS_K};
static char *font[] = {MINCH_K, GOTH_K, RGOTH_K};
static int nfont[] = {80, 81, 82};
static char *vert[] = {HORIZ_K, VERTI_K};
static int nvert[] = {0, 4};
static char *lips[] = {"LIPS II+", "LIPS III", "LIPS IV"};
static char *cass[] = {AUTO_K, MANU_K, UPPER_K, LOWER_K};
static char *kanji[] = {NUMER_K, KNUM_K};
static u_char *nhead[] = {NULL, headerbody};
static u_char *nfoot[] = {NULL, footerbody};
static char *uplow[] = {NOCHG_K, UPCAS_K, DWCAS_K};
static int *nuplow[] = {NULL, &istoupper, &istolower};
static char *over[] = {NOTDO_K, REG1_K, REG2_K, PRT1_K, PRT2_K, PRT12_K};
static char *outdev[] = {TOPRN_K, TOFIL_K, CONFM_K};
static char *outindex[] = {OUTD_K, OUTF_K, OUTD_K};
static u_char *outf[] = {outputprn, outputfile};
static char *omode[] = {OVWRT_K, APPEN_K};
static char *kcode[] = {"SJIS", "EUC", "JIS"};
static int nkcode[] = {SJIS, EUC, JIS};

static int *autos[] = {
	&automaxcolumns,
	&automaxlines,
	&autostepcolumns,
	&paperwidth,
	&stepwidth,
	&printwidth,
	&printheight,
	&charwidth,
	&charheight,
	&headermargin,
	&footermargin,
	&autorightmargin,
	&autobottommargin
};
static char **sel[] = {
	ifdo, size, land, font, vert,
	ifdo, ifdo, lips, cass,
	kanji, uplow, over,
	outdev, omode, kcode
#if	MSDOS
	, outputlpt
#endif
};
static int *nsel[] = {
	sequence, nsize, sequence, nfont, nvert,
	(int *)nhead, (int *)nfoot, &sequence[2], sequence,
	sequence, (int *)nuplow, sequence,
	sequence, sequence, nkcode
#if	MSDOS
	, sequence
#endif
};

extern char *printfile;
extern u_char *styletitle;
extern int kanjicode;
extern int dpitable[];

static int dot2milli __P_((int));
static VOID calcmisc __P_((VOID_A));
static VOID listupstyle __P_((styleinfo [], int, int, int, int));
static int inputloop __P_((styleinfo [], int, int, int, int));
static int selectloop __P_((styleinfo [], int, int, int));
VOID changestyle __P_((VOID_A));
VOID changeheadfoot __P_((VOID_A));
VOID changeoption __P_((VOID_A));
FILE *selectprint __P_((VOID_A));
VOID loadstyle __P_((char *));

extern VOID varinit __P_((VOID_A));
extern VOID chgmaxlinecol __P_((VOID_A));
extern VOID chgwidheight __P_((VOID_A));
extern VOID argfile __P_((char *));
extern int inputstr __P_((u_char *, int, int, int, int, int));
extern int yesno __P_((char *));
extern int warning __P_((int, char *));
extern VOID shownum __P_((int, int, int, int, int, int));
extern int inputnum __P_((int *, int, int, int, int, int, int));
extern int selectstr __P_((int *, int, int, int, char *[], int [], int));


static int dot2milli(dot)
int dot;
{
	long tmp;

	tmp = (long)dot;
	tmp *= 2540;
	tmp /= dpitable[lipsmode];
	tmp /= 100;
	return((int)tmp);
}

static VOID calcmisc(VOID_A)
{
	long tmp;

	chgwidheight();
	chgmaxlinecol();

	if (maxsteps > 1) {
		tmp = (stepcolumns < 0) ? autostepcolumns : stepcolumns;
		if (!tmp) stepwidth = 0;
		else {
			tmp *= columnwidth + lettersize / 2;
			tmp -= columnwidth;
			tmp = dotprintwidth - tmp * maxsteps;
			tmp /= maxsteps - 1;
			stepwidth = dot2milli((int)tmp);
		}

		printwidth = dot2milli(dotprintwidth);
	}
	else {
		stepwidth = (int)((1UL << (8 * sizeof(int) - 1)) - 1);

		tmp = columnwidth + lettersize / 2;
		tmp *= (usrmaxcolumns < 0) ? automaxcolumns : usrmaxcolumns;
		tmp -= columnwidth;
		printwidth = dot2milli((int)tmp);
	}
	tmp = lineheight + lettersize;
	tmp *= (usrmaxlines < 0) ? automaxlines : usrmaxlines;
	tmp -= lineheight;
	printheight = dot2milli((int)tmp);
	charwidth = dot2milli(columnwidth * 2);
	charheight = dot2milli(lineheight);

	if (islandscape) {
		autorightmargin = paperheight;
		autobottommargin = paperwidth;
	}
	else {
		autorightmargin = paperwidth;
		autobottommargin = paperheight;
	}
	autorightmargin -= printwidth + leftmargin;
	autobottommargin -= printheight + topmargin;
}

static VOID listupstyle(style, num, col, obj, flag)
styleinfo style[];
int num, col, obj, flag;
{
	int i, tmp;
	styleinfo st;
	static int dupl[AUTOSNUM];
	static int stepdup;
	static int controldup;
	static int redirectdup;
	static u_char *headdup;
	static u_char *footdup;

	calcmisc();
	if (flag) {
		for (i = 0; i < AUTOSNUM; i++) dupl[i] = -1;
		stepdup = maxsteps;
		controldup = controlmode;
		redirectdup = isredirect;
		headdup = NULL;
		footdup = NULL;
	}
	for (i = 0; i < num; i++) {
		st = style[i];
		if (!flag && (!(st.kind & 1) || i == obj)) continue;
		switch (st.kind) {
			case 5:
			case 9:
				if (maxsteps <= 1) {
					if (stepdup > 1) {
						locate(st.x + col, st.y);
						cprintf2("%15s", " ");
					}
					continue;
				}
				break;
			case 19:
			case 27:
				if (!flag
				&& style[obj].obj != (int *)&headerstr)
					continue;
				if (!headerstr) {
					locate(st.x + col, st.y);
					putterm(l_clear);
					continue;
				}
				break;
			case 21:
			case 29:
				if (!flag
				&& style[obj].obj != (int *)&footerstr)
					continue;
				if (!footerstr) {
					locate(st.x + col, st.y);
					putterm(l_clear);
					continue;
				}
				break;
			case 31:
				if (!flag && style[obj].obj != &controlmode)
					continue;
				if (!controlmode) {
					locate(st.x + col, st.y);
					putch2(' ');
					continue;
				}
				break;
			case 33:
				if (!flag && style[obj].obj != &isredirect)
					continue;
				st.name = outindex[isredirect];
				locate(st.x, st.y);
				putterm(l_clear);
				cprintf2("%-14.14s: ", st.name);
				if (isredirect == 2) continue;
				break;
			case 35:
				if (!flag && style[obj].obj != &isredirect)
					continue;
				if (isredirect != 1) {
					locate(st.x + col, st.y);
					putterm(l_clear);
					continue;
				}
				break;
			default:
				break;
		}
		switch (st.kind) {
			case 0:
			case 1:
			case 3:
			case 4:
			case 7:
			case 11:
			case 13:
			case 15:
			case 17:
			case 23:
			case 25:
				if (!(st.kind & 1)) tmp = -9999;
				else {
					tmp = *autos[st.kind / 2];
					if (tmp == dupl[st.kind / 2]) break;
					if (autos[st.kind / 2] == st.obj
					|| *(st.obj) >= 0) tmp = -9999;
				}
				shownum(*(st.obj),
					st.x + col + 3 - st.col, st.y,
					st.col, tmp, 0);
				if (flag) {
					locate(st.x + col + 3, st.y);
					putch2(' ');
					cputs2(st.unit);
				}
				break;
			case 2:
			case 35:
				selectstr(st.obj, st.max,
					st.x + col, st.y,
					sel[st.min], nsel[st.min], -1);
				break;
			case 5:
			case 9:
				if (autos[st.kind / 2] == st.obj) tmp = -9999;
				else {
					tmp = *autos[st.kind / 2];
					if (maxsteps > 1
					&& stepdup > 1
					&& tmp == dupl[st.kind / 2]) break;
				}
				shownum(*(st.obj),
					st.x + col + 3 - st.col, st.y,
					st.col, tmp, 0);
				if (flag || (maxsteps > 1 && stepdup <= 1)) {
					locate(st.x + col + 3, st.y);
					putch2(' ');
					cputs2(st.unit);
				}
				break;
			case 6:
				shownum(*(st.obj),
					st.x + col + 3 - st.col, st.y,
					st.col, st.min, 0);
				break;
			case 8:
				shownum(*(st.obj),
					st.x + col + 3 - st.col, st.y,
					st.col, st.max, 0);
				break;
			case 19:
			case 21:
				shownum(*(st.obj),
					st.x + col + 3 - st.col, st.y,
					st.col, 0, 0);
				locate(st.x + col + 3, st.y);
				putch2(' ');
				cputs2(st.unit);
				break;
			case 10:
			case 27:
			case 29:
				inputstr((u_char *)(st.obj), st.x + col, st.y,
					st.max, st.min, 0);
				break;
			case 31:
				if (!*(st.obj)) *st.obj = '\\';
				locate(st.x + col, st.y);
				putch2(*(st.obj));
				break;
			case 33:
				inputstr(((u_char **)(st.obj))[isredirect],
					st.x + col, st.y, st.max, st.min, 0);
				break;
			default:
				break;
		}
	}
	for (i = 0; i < AUTOSNUM; i++) dupl[i] = *autos[i];
	stepdup = maxsteps;
	headdup = headerstr;
	footdup = footerstr;
	controldup = controlmode;
	redirectdup = isredirect;
}

static int inputloop(st, num, col, i, tmp)
styleinfo st[];
int num, col, i, tmp;
{
	int ch;

	inputnum(st[i].obj, 0, 0, 0, 0, 0, 0);
	do {
		ch = inputnum(st[i].obj, st[i].min, st[i].max,
			st[i].x + col + 3 - st[i].col, st[i].y,
			st[i].col, tmp);
		listupstyle(st, num, col, i, 0);
	} while (!ch);

	return(ch);
}

static int selectloop(st, num, col, i)
styleinfo st[];
int num, col, i;
{
	int ch;

	selectstr(st[i].obj, st[i].max, st[i].x + col, st[i].y,
		sel[st[i].min], nsel[st[i].min], 0);
	do {
		ch = selectstr(st[i].obj, st[i].max, st[i].x + col, st[i].y,
			sel[st[i].min], nsel[st[i].min], 1);
		listupstyle(st, num, col, i, 0);
	} while (!ch);

	return(ch);
}

VOID changestyle(VOID_A)
{
	styleinfo st[STYLENUM];
	int dupl[STYLENUM];
	int i;
	int ch, oldch;

	st[0].col = 0; st[0].kind = 2; st[0].obj = &papersize;
	st[1].col = 3; st[1].kind = 7; st[1].obj = &paperwidth;
	st[2].col = 3; st[2].kind = 7; st[2].obj = &paperheight;
	st[3].col = 0; st[3].kind = 2; st[3].obj = &islandscape;
	st[4].col = 3; st[4].kind = 1; st[4].obj = &usrmaxcolumns;
	st[5].col = 3; st[5].kind = 3; st[5].obj = &usrmaxlines;
	st[6].col = 3; st[6].kind = 0; st[6].obj = &columnwidth;
	st[7].col = 3; st[7].kind = 0; st[7].obj = &lineheight;
	st[8].col = 3; st[8].kind = 0; st[8].obj = &topmargin;
	st[9].col = 3; st[9].kind = 25; st[9].obj = &bottommargin;
	st[10].col = 3; st[10].kind = 0; st[10].obj = &leftmargin;
	st[11].col = 3; st[11].kind = 23; st[11].obj = &rightmargin;
	st[12].col = 2; st[12].kind = 0; st[12].obj = &tabposition;
	st[13].col = 3; st[13].kind = 0; st[13].obj = &lettersize;
	st[14].col = 0; st[14].kind = 2; st[14].obj = &fontpattern;
	st[15].col = 0; st[15].kind = 2; st[15].obj = &isvertical;
	st[16].col = 1; st[16].kind = 4; st[16].obj = &maxsteps;
	st[17].col = 3; st[17].kind = 5; st[17].obj = &stepcolumns;
	st[18].col = 3; st[18].kind = 9; st[18].obj = &stepwidth;
	st[19].col = 3; st[19].kind = 11; st[19].obj = &printwidth;
	st[20].col = 3; st[20].kind = 13; st[20].obj = &printheight;
	st[21].col = 3; st[21].kind = 15; st[21].obj = &charwidth;
	st[22].col = 3; st[22].kind = 17; st[22].obj = &charheight;

	st[0].x =  2; st[0].y =  4; st[0].name = PSIZE_K;
	st[1].x = 50; st[1].y =  6; st[1].name = PWID_K;
	st[2].x = 50; st[2].y =  7; st[2].name = PHIGH_K;
	st[3].x =  2; st[3].y =  5; st[3].name = PTURN_K;
	st[4].x =  2; st[4].y =  6; st[4].name = COLUM_K;
	st[5].x =  2; st[5].y =  7; st[5].name = LINE_K;
	st[6].x =  2; st[6].y =  8; st[6].name = CWID_K;
	st[7].x =  2; st[7].y =  9; st[7].name = LHIGH_K;
	st[8].x =  2; st[8].y = 10; st[8].name = TMARG_K;
	st[9].x =  2; st[9].y = 11; st[9].name = BMARG_K;
	st[10].x =  2; st[10].y = 12; st[10].name = LMARG_K;
	st[11].x =  2; st[11].y = 13; st[11].name = RMARG_K;
	st[12].x =  2; st[12].y = 14; st[12].name = TABP_K;
	st[13].x =  2; st[13].y = 15; st[13].name = LSIZE_K;
	st[14].x =  2; st[14].y = 16; st[14].name = FPATT_K;
	st[15].x =  2; st[15].y = 17; st[15].name = KMODE_K;
	st[16].x =  2; st[16].y = 18; st[16].name = NSTEP_K;
	st[17].x =  2; st[17].y = 19; st[17].name = STCOL_K;
	st[18].x = 32; st[18].y = 19; st[18].name = STWID_K;
	st[19].x = 50; st[19].y =  9; st[19].name = PRWID_K;
	st[20].x = 50; st[20].y = 10; st[20].name = PRHIG_K;
	st[21].x = 50; st[21].y = 11; st[21].name = ZCWID_K;
	st[22].x = 50; st[22].y = 12; st[22].name = LHIGH_K;

	st[0].unit = st[3].unit = st[14].unit = st[15].unit = "";
	st[1].unit = st[2].unit =
	st[8].unit = st[9].unit = st[10].unit = st[11].unit =
	st[18].unit =
	st[19].unit = st[20].unit = st[21].unit = st[22].unit = MILLI_K;
	st[4].unit = st[17].unit = CHARS_K;
	st[5].unit = LINES_K;
	st[6].unit = st[7].unit = st[13].unit = DOTS_K;
	st[12].unit = PDOT_K;
	st[16].unit = STEPS_K;

	st[0].min = 1;			st[0].max = NITEM(size);
	st[1].min = MINPAPERWIDTH;	st[1].max = MAXPAPERWIDTH;
	st[2].min = MINPAPERHEIGHT;	st[2].max = MAXPAPERHEIGHT;
	st[3].min = 2;			st[3].max = NITEM(land);
	st[4].min = MINMAXCOLUMNS;	st[4].max = MAXMAXCOLUMNS;
	st[5].min = MINMAXLINES;	st[5].max = MAXMAXLINES;
	st[6].min = MINCOLUMNWIDTH;	st[6].max = MAXCOLUMNWIDTH;
	st[7].min = MINLINEHEIGHT;	st[7].max = MAXLINEHEIGHT;
	st[8].min = MINTOPMARGIN;	st[8].max = MAXTOPMARGIN;
	st[9].min = MINBOTTOMMARGIN;	st[9].max = MAXBOTTOMMARGIN;
	st[10].min = MINLEFTMARGIN;	st[10].max = MAXLEFTMARGIN;
	st[11].min = MINRIGHTMARGIN;	st[11].max = MAXRIGHTMARGIN;
	st[12].min = MINTABPOSITION;	st[12].max = MAXTABPOSITION;
	st[13].min = MINLETTERSIZE;	st[13].max = MAXLETTERSIZE;
	st[14].min = 3;			st[14].max = NITEM(font);
	st[15].min = 4;			st[15].max = NITEM(vert);
	st[16].min = 1;			st[16].max = MAXMAXSTEPS;
	st[17].min = MINSTEPCOLUMNS;	st[17].max = MAXSTEPCOLUMNS;
	st[18].min = 0;			st[18].max = 0;
	st[19].min = 0;			st[19].max = 0;
	st[20].min = 0;			st[20].max = 0;
	st[21].min = 0;			st[21].max = 0;
	st[22].min = 0;			st[22].max = 0;

	for (i = 0; i < STYLENUM; i++) dupl[i] = *(st[i].obj);

	calcmisc();
	for (i = 0; i < STYLENUM; i++) {
		locate(st[i].x, st[i].y);
		cprintf2("%-12.12s: ", st[i].name);
	}
	listupstyle(st, STYLENUM, 14, -1, 1);

	i = 0;
	oldch = K_DOWN;
	do {
		ch = '\0';
		switch (st[i].kind) {
			case 5:
				if (maxsteps <= 1) break;
			case 0:
			case 1:
			case 3:
			case 4:
			case 23:
			case 25:
				if (st[i].kind & 1) ch = inputloop(st,
					STYLENUM, 14, i,
					*autos[st[i].kind / 2]);
				else ch = inputloop(st,
					STYLENUM, 14, i, -9999);
				break;
			case 2:
				ch = selectloop(st, STYLENUM, 14, i);
				break;
			case 7:
				if (papersize != 80) break;
				ch = inputloop(st, STYLENUM, 14, i, -9999);
				break;
			default:
				break;
		}

		if (ch == ESC) {
			for (i = 0; i < STYLENUM; i++) *(st[i].obj) = dupl[i];
			calcmisc();
			return;
		}
		else if (ch == '\0') ch = oldch;

		switch (ch) {
			case K_UP:
				if (i > 0) i--;
				else i = STYLENUM - 1;
				break;
			case K_DOWN:
				if (i < STYLENUM - 1) i++;
				else i = 0;
				break;
			default:
				break;
		}
		oldch = ch;
		calcmisc();
	} while (ch != CR);
}

VOID changeheadfoot(VOID_A)
{
	styleinfo st[HEADFOOTNUM];
	int dupl[HEADFOOTNUM - 2];
	u_char dupl2[2][MAXHEADLEN + 1];
	int i;
	int *istouplow;
	int ch, oldch;

	st[0].col = 0; st[0].kind = 27; st[0].obj = (int *)headerbody;
	st[1].col = 0; st[1].kind = 29; st[1].obj = (int *)footerbody;
	st[2].col = 0; st[2].kind =  2; st[2].obj = (int *)&headerstr;
	st[3].col = 2; st[3].kind = 19; st[3].obj = &headermargin;
	st[4].col = 0; st[4].kind =  2; st[4].obj = (int *)&footerstr;
	st[5].col = 2; st[5].kind = 21; st[5].obj = &footermargin;
	st[6].col = 0; st[6].kind =  2; st[6].obj = &iszerosup;
	st[7].col = 0; st[7].kind =  2; st[7].obj = &iskanjinum;
	st[8].col = 0; st[8].kind =  2; st[8].obj = (int *)&istouplow;

	st[0].x =  2; st[0].y =  4; st[0].name = SHEAD_K;
	st[1].x =  2; st[1].y =  6; st[1].name = SFOOT_K;
	st[2].x =  2; st[2].y = 10; st[2].name = PHEAD_K;
	st[3].x =  2; st[3].y = 11; st[3].name = MHEAD_K;
	st[4].x =  2; st[4].y = 12; st[4].name = PFOOT_K;
	st[5].x =  2; st[5].y = 13; st[5].name = MFOOT_K;
	st[6].x =  2; st[6].y = 15; st[6].name = ZEROS_K;
	st[7].x =  2; st[7].y = 16; st[7].name = VNUM_K;
	st[8].x =  2; st[8].y = 17; st[8].name = FCHG_K;

	st[0].unit = st[1].unit = st[2].unit = st[4].unit =
	st[6].unit = st[7].unit = st[8].unit = "";
	st[3].unit = st[5].unit = MILLI_K;

	st[0].min = MAXHEADLEN / 2;	st[0].max = MAXHEADLEN;
	st[1].min = MAXHEADLEN / 2;	st[1].max = MAXHEADLEN;
	st[2].min = 5;			st[2].max = NITEM(ifdo);
	st[3].min = MINHEADERMARGIN;	st[3].max = MAXHEADERMARGIN;
	st[4].min = 6;			st[4].max = NITEM(ifdo);
	st[5].min = MINFOOTERMARGIN;	st[5].max = MAXFOOTERMARGIN;
	st[6].min = 0;			st[6].max = NITEM(ifdo);
	st[7].min = 9;			st[7].max = NITEM(kanji);
	st[8].min = 10;			st[8].max = NITEM(uplow);

	istouplow = NULL;
	if (istoupper) istouplow = &istoupper;
	if (istolower) istouplow = &istolower;

	for (i = 0; i < 2; i++) strcpy(dupl2[i], (char *)(st[i].obj));
	for (i = 2; i < HEADFOOTNUM; i++) dupl[i - 2] = *(st[i].obj);

	for (i = 0; i < HEADFOOTNUM; i++) {
		locate(st[i].x, st[i].y);
		cprintf2("%-14.14s: ", st[i].name);
	}
	listupstyle(st, HEADFOOTNUM, 16, -1, 1);

	i = 0;
	oldch = K_DOWN;
	do {
		ch = '\0';

		switch (st[i].kind) {
			case 2:
				ch = selectloop(st, HEADFOOTNUM, 16, i);
				break;
			case 19:
				if (!headerstr) break;
				ch = inputloop(st, HEADFOOTNUM, 16, i, -9999);
				break;
			case 21:
				if (!footerstr) break;
				ch = inputloop(st, HEADFOOTNUM, 16, i, -9999);
				break;
			case 27:
				if (!headerstr) break;
				ch = inputstr((u_char *)(st[i].obj),
					st[i].x + 16, st[i].y,
					st[i].max, st[i].min, 1);
				break;
			case 29:
				if (!footerstr) break;
				ch = inputstr((u_char *)(st[i].obj),
					st[i].x + 16, st[i].y,
					st[i].max, st[i].min, 1);
				break;
			default:
				break;
		}

		if (ch == ESC) {
			for (i = 0; i < 2; i++)
				strcpy((char *)(st[i].obj), dupl2[i]);
			for (i = 2; i < HEADFOOTNUM; i++)
				*(st[i].obj) = dupl[i - 2];
			return;
		}
		else if (ch == '\0') ch = oldch;

		switch (ch) {
			case K_UP:
				if (i > 0) i--;
				else i = HEADFOOTNUM - 1;
				break;
			case K_DOWN:
				if (i < HEADFOOTNUM - 1) i++;
				else i = 0;
				break;
			default:
				break;
		}
		oldch = ch;
	} while (ch != CR);

	istoupper = istolower = 0;
	if (istouplow) *istouplow = 1;
}

VOID changeoption(VOID_A)
{
	styleinfo st[OPTIONNUM];
	int dupl[OPTIONNUM - 1];
	char dupl2[MAXTITLELEN + 1];
	u_char tmp[2];
	int i;
	int ch, oldch;

	st[0].col = 0; st[0].kind = 10; st[0].obj = (int *)styletitlebody;
	st[1].col = 0; st[1].kind =  2; st[1].obj = &lipsmode;
	st[2].col = 0; st[2].kind =  2; st[2].obj = &cassette;
	st[3].col = 0; st[3].kind =  2; st[3].obj = &overlay;
	st[4].col = 0; st[4].kind =  2; st[4].obj = &controlmode;
	st[5].col = 1; st[5].kind = 31; st[5].obj = &controlchar;
	st[6].col = 0; st[6].kind =  2; st[6].obj = &isconcat;
	st[7].col = 0; st[7].kind =  2; st[7].obj = &iskinsoku;
	st[8].col = 0; st[8].kind =  2; st[8].obj = &kanjicode;

	st[0].x =  2; st[0].y =  4; st[0].name = STYN_K;
	st[1].x =  2; st[1].y =  6; st[1].name = LMODE_K;
	st[2].x =  2; st[2].y =  7; st[2].name = PAPER_K;
	st[3].x =  2; st[3].y =  8; st[3].name = OVRAY_K;
	st[4].x =  2; st[4].y = 10; st[4].name = CONTR_K;
	st[5].x =  2; st[5].y = 11; st[5].name = CTPRE_K;
	st[6].x =  2; st[6].y = 13; st[6].name = CONC_K;
	st[7].x =  2; st[7].y = 14; st[7].name = ISKIN_K;
	st[8].x =  2; st[8].y = 15; st[8].name = KCODE_K;


	st[0].unit = st[1].unit = st[2].unit = st[3].unit =
	st[4].unit = st[5].unit = st[6].unit = st[7].unit = st[8].unit = "";

	st[0].min = MAXTITLELEN;	st[0].max = MAXTITLELEN;
	st[1].min = 7;			st[1].max = NITEM(lips);
	st[2].min = 8;			st[2].max = NITEM(cass);
	st[3].min = 11;			st[3].max = NITEM(over);
	st[4].min = 0;			st[4].max = NITEM(ifdo);
	st[5].min = 0;			st[5].max = 1;
	st[6].min = 0;			st[6].max = NITEM(ifdo);
	st[7].min = 0;			st[7].max = NITEM(ifdo);
	st[8].min = 14;			st[8].max = NITEM(kcode);

	strcpy(dupl2, (char *)(st[0].obj));
	for (i = 1; i < OPTIONNUM; i++) dupl[i - 1] = *(st[i].obj);

	for (i = 0; i < OPTIONNUM; i++) {
		locate(st[i].x, st[i].y);
		cprintf2("%-14.14s: ", st[i].name);
	}
	listupstyle(st, OPTIONNUM, 16, -1, 1);

	i = 0;
	oldch = K_DOWN;
	do {
		ch = '\0';
		switch (st[i].kind) {
			case 2:
				ch = selectloop(st, OPTIONNUM, 16, i);
				break;
			case 10:
				ch = inputstr((u_char *)(st[i].obj),
					st[i].x + 16, st[i].y,
					st[i].max, st[i].min, 1);
				break;
			case 31:
				if (!controlmode) break;
				tmp[0] = *((u_char *)(st[i].obj));
				tmp[1] = '\0';
				ch = inputstr(tmp, st[i].x + 16, st[i].y,
					st[i].max, st[i].max, 1);
				*(st[i].obj) = (int)(tmp[0]);
				break;
			default:
				break;
		}

		if (ch == ESC) {
			for (i = 1; i < OPTIONNUM; i++)
				*(st[i].obj) = dupl[i - 1];
			strcpy((char *)(st[0].obj), dupl2);
			return;
		}
		else if (ch == '\0') ch = oldch;

		switch (ch) {
			case K_UP:
				if (i > 0) i--;
				else i = OPTIONNUM - 1;
				break;
			case K_DOWN:
				if (i < OPTIONNUM - 1) i++;
				else i = 0;
				break;
			default:
				break;
		}
		oldch = ch;
	} while (ch != CR);

	styletitle = (*styletitlebody) ? styletitlebody : NULL;
}

FILE *selectprint(VOID_A)
{
	styleinfo st[DOPRINTNUM];
	int dupl[DOPRINTNUM];
	char dupl2[2][MAXFILELEN];
	int i, sp, ep;
	int ch, oldch;
	FILE *fp;

	if ((sp = startpage) >= 0) sp++;
	if ((ep = endpage) >= 0) ep++;

	if (!*outputprn) {
		if (outputprinter) strcpy(outputprn, outputprinter);
#if	MSDOS
		else strcpy(outputprn, "local");
#endif
	}

	st[0].col = 0; st[0].kind =  2; st[0].obj = &isredirect;
	st[1].col = 0; st[1].kind = 33; st[1].obj = (int *)outf;
	st[2].col = 0; st[2].kind = 35; st[2].obj = &outputmode;
	st[3].col = 3; st[3].kind =  0; st[3].obj = &printnum;
	st[4].col = 3; st[4].kind =  6; st[4].obj = &sp;
	st[5].col = 3; st[5].kind =  8; st[5].obj = &ep;
	st[6].col = 3; st[6].kind =  0; st[6].obj = &firstpage;

	st[0].x =  2; st[0].y =  4; st[0].name = OUTP_K;
	st[1].x =  2; st[1].y =  5; st[1].name = outindex[isredirect];
	st[2].x =  2; st[2].y =  6; st[2].name = OUTM_K;
	st[3].x =  2; st[3].y =  8; st[3].name = PNUM_K;
	st[4].x =  2; st[4].y =  9; st[4].name = SPAGE_K;
	st[5].x =  2; st[5].y = 10; st[5].name = EPAGE_K;
	st[6].x =  2; st[6].y = 11; st[6].name = FPAGE_K;

	st[0].unit = st[1].unit = st[2].unit = "";
	st[3].unit = COPYS_K;
	st[4].unit = st[5].unit = st[6].unit = PAGES_K;

	st[0].min = 12;			st[0].max = NITEM(outdev);
	st[1].min = MAXFILELEN;		st[1].max = MAXFILELEN;
	st[2].min = 13;			st[2].max = NITEM(omode);
	st[3].min = MINPRINTNUM;	st[3].max = MAXPRINTNUM;
	st[4].min = MINSTARTPAGE;	st[4].max = MAXSTARTPAGE;
	st[5].min = MINENDPAGE;		st[5].max = MAXENDPAGE;
	st[6].min = MINFIRSTPAGE;	st[6].max = MAXFIRSTPAGE;

	for (i = 0; i < 2; i++) strcpy(dupl2[i], outf[i]);
	for (i = 0; i < DOPRINTNUM; i++) dupl[i] = *(st[i].obj);

	for (i = 0; i < DOPRINTNUM; i++) {
		locate(st[i].x, st[i].y);
		cprintf2("%-14.14s: ", st[i].name);
	}
	listupstyle(st, DOPRINTNUM, 16, -1, 1);

	i = 0;
	oldch = K_DOWN;
	do {
		ch = '\0';
		switch (st[i].kind) {
			case 0:
				ch = inputloop(st, STYLENUM, 16, i, -9999);
				break;
			case 6:
				ch = inputloop(st, STYLENUM, 16, i, st[i].min);
				break;
			case 8:
				ch = inputloop(st, STYLENUM, 16, i, st[i].max);
				break;
			case 35:
				if (isredirect != 1) break;
			case 2:
				ch = selectloop(st, DOPRINTNUM, 16, i);
				break;
			case 33:
				if (isredirect == 2) break;
#if	MSDOS
				if (!isredirect) {
					if (bdos(0x30, 0, 0) < 7) break;
					st[i].obj = &outputlptno;
					st[i].min = 15;
					st[i].max = NITEM(outputlpt);
					ch = selectloop(st, DOPRINTNUM, 16, i);
					st[i].obj = (int *)outf;
					st[i].min = st[i].max = MAXFILELEN;
					strcpy(outputprn,
						outputlpt[outputlptno]);
					locate(st[i].x + 16, st[i].y);
					putterm(l_clear);
					cputs2(outputprn);
				}
				else
#endif
				ch = inputstr(
					((u_char **)(st[i].obj))[isredirect],
					st[i].x + 16, st[i].y,
					st[i].max, st[i].max, 1);
				break;
			default:
				break;
		}

		if (ch == ESC) {
			for (i = 0; i < DOPRINTNUM; i++)
				*(st[i].obj) = dupl[i];
			for (i = 0; i < 2; i++) strcpy(outf[i], dupl2[i]);
			return(NULL);
		}
		else if (ch == '\0') ch = oldch;

		switch (ch) {
			case K_UP:
				if (i > 0) i--;
				else i = DOPRINTNUM - 1;
				break;
			case K_DOWN:
				if (i < DOPRINTNUM - 1) i++;
				else i = 0;
				break;
			default:
				break;
		}
		oldch = ch;
	} while (ch != CR);

	if ((startpage = sp) >= 0) startpage--;
	if ((endpage = ep) >= 0) endpage--;

	fp = stdout;
	if (printfile) {
		isinfo = 0;
		if (isredirect == 2) isinfo = 1;
		else if (!yesno(PRTOK_K)) fp = NULL;
		else if (isredirect == 1) {
			if (!(fp = fopen(outputfile,
			(outputmode ? "a" : "w"))))
				warning(-1, outputfile);
		}
		else
#if	MSDOS
		if (outputlptno) {
			if (!(fp = fopen(outputprn, "w")))
				warning(-1, outputprn);
		}
#else
		outputprinter = (char *)outputprn;
#endif
	}

	return(fp);
}

VOID loadstyle(file)
char *file;
{
	varinit();
	argfile(file);

	if (headerstr) {
		if (strlen(headerstr) <= MAXHEADLEN)
			strcpy(headerbody, headerstr);
		else {
			strncpy(headerbody, headerstr, MAXHEADLEN);
			headerbody[MAXHEADLEN] = '\0';
		}
		free(headerstr);
		headerstr = headerbody;
	}
	else {
		headermargin = HEADERMARGIN;
		*headerbody = '\0';
	}
	if (footerstr) {
		if (strlen(footerstr) <= MAXHEADLEN)
			strcpy(footerbody, footerstr);
		else {
			strncpy(footerbody, footerstr, MAXHEADLEN);
			footerbody[MAXHEADLEN] = '\0';
		}
		free(footerstr);
		footerstr = footerbody;
	}
	else {
		footermargin = FOOTERMARGIN;
		*footerbody = '\0';
	}
	if (!styletitle) *styletitlebody = '\0';
	else {
		if (strlen(styletitle) <= MAXHEADLEN)
			strcpy(styletitlebody, styletitle);
		else {
			strncpy(styletitlebody, styletitle, MAXHEADLEN);
			styletitlebody[MAXHEADLEN] = '\0';
		}
		free(styletitle);
		styletitle = styletitlebody;
	}
}
