/*
 *	output.c
 *
 *	Output LIPS Command Sequence
 */

#include "lipsf.h"
#include "var.h"

#if 	MSDOS
#include <dos.h>
#include <direct.h>
char *strrdelim __P_((char *));
#else
#include <sys/param.h>
#ifdef	USEDIRECT
#include <sys/dir.h>
#else
#include <dirent.h>
#endif
#define	strrdelim(s)	strrchr(s, _SC_)
#endif

#if	MSDOS
#define	MAXNAMLEN	255
#define	MAXPATHLEN	260
#else
#define	lputc	fputc
#define	lprintf	fprintf
#endif

#ifndef	USEGETWD
#define	getwd(path)	getcwd(path, MAXPATHLEN);
#endif

int kanjiflag;
int kanaflag;
int kanjimode;
int kanjicode = DEF_KCODE;
struct stat filebuf;
char fullpathbody[MAXPATHLEN + 1];
char filenamebody[MAXNAMLEN + 1];
int dpitable[] = { -1, -1, 240, 300, 600};

extern FILE *infile;
extern int column;
extern int line;
extern int logicalline;
extern long totalline;
extern int lastch;

char *strdup2 __P_((char *));
VOID getfileinfo __P_((char *, FILE *));
static VOID ungetchar __P_((int));
int iskanjiin __P_((int));
int iskanjiout __P_((int));
FILE *lpropen __P_((VOID_A));
VOID output __P_((int, FILE *));
VOID lips_unit __P_((FILE *, int));
VOID lips_weight __P_((FILE *, int, int));
VOID resetcursor __P_((FILE *, int, int));
VOID frontprocess __P_((FILE *));
VOID backprocess __P_((FILE *));

extern VOID error __P_((int));
extern int bufputc __P_((int, FILE *));
extern VOID printout __P_((FILE *));
extern int filterputc __P_((int, FILE *));
#if	MSDOS
extern int lopen(VOID_A);
extern int lputc(int, FILE *);
extern int lprintf(FILE *, CONST u_char *, ...);
extern int bufprintf(FILE *, CONST u_char *, ...);
#else
extern int bufprintf __P_((FILE *, CONST u_char *, ...));
#endif


#if	MSDOS
char *strrdelim(s)
char *s;
{
	int i;
	char *cp;

	cp = NULL;
	for (i = 0; s[i]; i++) {
		if (s[i] == _SC_) cp = &s[i];
		if (issjis1((u_char)(s[i])) && !s[++i]) break;
	}
	return(cp);
}
#endif

char *strdup2(str)
char *str;
{
	char *tmp;

	if (!str) return(NULL);
	if (!(tmp = (char *)malloc(strlen(str) + 1))) error(-1);
	strcpy(tmp, str);
	return(tmp);
}

VOID getfileinfo(file, fp)
char *file;
FILE *fp;
{
	char cwd[MAXPATHLEN + 1];
	char *tmp, *tmp2, *cp;
#if	MSDOS
	int drive, curdrive, dammy;
#endif

	if (file) {
		if (!(tmp = tmp2 = strdup2(file))) error(-1);
#if	MSDOS
		_dos_getdrive(&curdrive);
		if (cp = strchr(tmp, ':')) {
			tmp2 = cp + 1;
			drive = *tmp;
			if (drive >= 'a' && drive <= 'z') drive += 'A' - 'a';
			drive -= 'A' - 1;
			_dos_setdrive(drive, &dammy);
		}
#endif
		getwd(cwd);
		cp = strrdelim(tmp2);
		if (!cp) strcpy(filenamebody, tmp2);
		else {
			strcpy(filenamebody, cp + 1);
			if (cp == tmp2) cp++;
			*cp = '\0';
			if (chdir(tmp2)) error(-1);
		}
		getwd(fullpathbody);
		chdir(cwd);
#if	MSDOS
		_dos_setdrive(curdrive, &dammy);
#endif
		free(tmp);
	}
	else {
		strcpy(filenamebody, "( STDIN )");
		*fullpathbody = '\0';
	}
	if (istoupper) {
		for (cp = filenamebody; *cp; cp++)
			if (*cp >= 'a' && *cp <= 'z') *cp += 'A' - 'a';
		for (cp = fullpathbody; *cp; cp++)
			if (*cp >= 'a' && *cp <= 'z') *cp += 'A' - 'a';
	}
	if (istolower) {
		for (cp = filenamebody; *cp; cp++)
			if (*cp >= 'A' && *cp <= 'Z') *cp += 'a' - 'A';
		for (cp = fullpathbody; *cp; cp++)
			if (*cp >= 'A' && *cp <= 'Z') *cp += 'a' - 'A';
	}

	if (fstat(fileno(fp), &filebuf)) error(-1);
}

static VOID ungetchar(c)
int c;
{
	if (c != EOF) ungetc(c, infile);
}

int iskanjiin(c)
int c;
{
	int c1, c2, c3, c4, c5;

	if (c == P_ESC) {
		c1 = fgetc(infile);
		if (c1 == '$') {
			c2 = fgetc(infile);
			if (c2 == '@' || c2 == 'B') return(1);
			else if (c2 == '(') {
				c3 = fgetc(infile);
				if (c3 == '@' || c3 == 'B' || c3 == 'O')
					return(1);
				ungetchar(c3);
			}
			ungetchar(c2);
		}
		else if (c1 == '&') {
			c2 = fgetc(infile);
			if (c2 == '@') {
				c3 = fgetc(infile);
				if (c3 == P_ESC) {
					c4 = fgetc(infile);
					if (c4 == '$') {
						c5 = fgetc(infile);
						if (c5 == 'B') return(1);
						ungetchar(c5);
					}
					ungetchar(c4);
				}
				ungetchar(c3);
			}
			ungetchar(c2);
		}
		ungetchar(c1);
	}
	return(0);
}

int iskanjiout(c)
int c;
{
	int c1, c2;

	if (c == P_ESC) {
		c1 = fgetc(infile);
		if (c1 == '(') {
			c2 = fgetc(infile);
			if (c2 == 'J' || c2 == 'B' || c2 == 'H') return(1);
			else if (c2 == 'I') return(2);
			ungetchar(c2);
		}
		ungetchar(c1);
	}
	return(0);
}

FILE *lpropen(VOID_A)
{
#if	MSDOS
	lopen();
	return(NULL);
#else
	FILE *fp;
	char tmp[MAXPATHLEN + 1];

	sprintf(tmp, "%s -P%s", LPRPATH, outputprinter);
	if (!(fp = popen(tmp, "w"))) error(-1);

	return(fp);
#endif
}

VOID output(c, stream)
int c;
FILE *stream;
{
	int n, kcode;

	kcode = kanjicode;
	if (kcode != SJIS && kcode != EUC) kcode = DEF_KCODE;

	if (kanjimode == ASCII) {
		if (c == '\016') {
			/* SO */
			kanjimode = JIS;
			kanjiflag = 0;
			kanaflag = 2;
			return;
		}
		else if (c == '\017') {
			/* SI */
			kanjimode = JIS;
			kanjiflag = kanaflag = 0;
			return;
		}
		else if (iskanjiin(c)) {
			kanjimode = JIS;
			kanjiflag = 2;
			kanaflag = 0;
			kanjiin(stream);
			return;
		}
		else if ((n = iskanjiout(c))) {
			kanjimode = JIS;
			kanjiflag = 0;
			kanaflag = (n == 2) ? 1 : 0;
			return;
		}
		else if (kcode == SJIS) {
			if (issjis1(c)) {
				kanjimode = SJIS;
				kanjiflag = 1;
				kanjiin(stream);
			}
			else if (!issjkana(c) && iseuc(c)) {
				kanjimode = EUC;
				kanjiflag = 1;
				kanjiin(stream);
			}
		}
		else {
			if (c == 0x8e) {
				kanjimode = EUC;
				kanjiflag = 1;
			}
			else if (iseuc(c)) {
				kanjimode = EUC;
				kanjiflag = 1;
				kanjiin(stream);
			}
			else if (issjis1(c)) {
				kanjimode = SJIS;
				kanjiflag = 1;
				kanjiin(stream);
			}
		}
	}
	else if (kanjimode == SJIS) {
		switch (kanjiflag) {
			case 0:
				if (issjis1(c)) {
					kanjiflag = 1;
					kanjiin(stream);
				}
				break;
			case 1:
				kanjiflag++;
				break;
			case 2:
				if (issjis1(c)) kanjiflag = 1;
				else {
					kanjiflag = 0;
					kanjiout(stream);
				}
				break;
			default:
				break;
		}
	}
	else if (kanjimode == EUC) {
		switch (kanjiflag) {
			case 0:
				if (c == 0x8e) kanjiflag = 1;
				else if (iseuc(c)) {
					kanjiflag = 1;
					kanjiin(stream);
				}
				break;
			case 1:
				kanjiflag++;
				break;
			case 2:
				if (c == 0x8e) {
					kanjiflag = 1;
					kanjiout(stream);
				}
				else if (iseuc(c)) kanjiflag = 1;
				else {
					kanjiflag = 0;
					kanjiout(stream);
				}
				break;
			default:
				break;
		}
	}
	else {
		switch (kanjiflag) {
			case 0:
				if (c == '\016') {
					/* SO */
					kanaflag |= 2;
					return;
				}
				else if (c == '\017') {
					/* SI */
					if (kanaflag & 4) {
						kanjiflag = 2;
						kanjiin(stream);
					}
					kanaflag &= ~6;
					return;
				}
				else if (iskanjiin(c)) {
					if (kanaflag & 2) kanaflag |= 4;
					else {
						kanjiflag = 2;
						kanjiin(stream);
					}
					kanaflag &= ~1;
					return;
				}
				else if ((n = iskanjiout(c))) {
					kanaflag &= ~4;
					if (n == 2) kanaflag |= 1;
					else kanaflag &= ~1;
					return;
				}
				break;
			case 1:
				kanjiflag++;
				break;
			case 2:
				if (c == '\016') {
					/* SO */
					kanjiflag = 0;
					kanaflag |= 6;
					kanjiout(stream);
					return;
				}
				else if (c == '\017') {
					/* SI */
					kanaflag &= ~6;
					return;
				}
				else if (iskanjiin(c)) {
					kanaflag &= ~1;
					return;
				}
				else if ((n = iskanjiout(c))) {
					kanjiflag = 0;
					if (n == 2) kanaflag |= 1;
					else kanaflag &= ~1;
					kanjiout(stream);
					return;
				}
				kanjiflag = 1;
				break;
			default:
				break;
		}
		if (kanaflag) c |= 0x80;
	}

	if (c == '\t') {
		do filterputc(' ', stream);
		while (column % tabposition);
		return;
	}
	else if (c == '\n') {
		if (lastch != '\r') filterputc('\r', stream);
		line++;
		totalline++;
		logicalline++;
	}
	else if (c == '\f') {
		line++;
		totalline++;
	}
	filterputc(c, stream);
}

VOID lips_unit(stream, isbuf)
FILE *stream;
int isbuf;
{
	if (isbuf) {
		if (lipsmode < 4) bufprintf(stream, "\033[7 I");
		else bufprintf(stream, "\033[?7;%d I", dpitable[lipsmode]);
	}
	else {
		if (lipsmode < 4) lprintf(stream, "\033[7 I");
		else lprintf(stream, "\033[?7;%d I", dpitable[lipsmode]);
	}
}

VOID lips_weight(stream, isbuf, isbold)
FILE *stream;
int isbuf, isbold;
{
	char *cp;

	if (fontpattern != 82) cp = (isbold) ? "1" : "22";
	else cp = (isbold) ? "2" : "2;2;2";

	if (isbuf) bufprintf(stream, "\033[%sm", cp);
	else lprintf(stream, "\033[%sm", cp);
}

VOID resetcursor(stream, x, y)
FILE *stream;
int x, y;
{
	int min;

	min = ((long)(dpitable[lipsmode]) * HOMENUMERATOR) / HOMEDENOMINATOR;
	lprintf(stream, "\033[?6 I");
	lprintf(stream, "\033[11h");
	lprintf(stream, "\033[%ld;%ldf",
		((long)topmargin - MINTOPMARGIN + (long)y) * 100,
		((long)leftmargin - MINLEFTMARGIN) * 100);

	lips_unit(stream, 0);
	lprintf(stream, "\033[11h");
	lprintf(stream, "\033[%da", x);
	lips_unit(stream, 0);
	lprintf(stream, "\033[11h");
	if (lettersize < min) lprintf(stream, "\033[%dk", min - lettersize);
	else lprintf(stream, "\033[%de", lettersize - min);
	lprintf(stream, "\033[0;2t");
}

VOID frontprocess(stream)
FILE *stream;
{
	int dpi;

	dpi = dpitable[lipsmode];
	lprintf(stream, "\033%%@");
	lprintf(stream, "\033P%1d1;%d;1J\033\\", lipsmode, dpi);
	lprintf(stream, "\033<");
	lprintf(stream, "\033[%1dq", cassette);

	lprintf(stream, "\033[?6 I");
	lprintf(stream, "\033[%d", papersize + islandscape);
	if (papersize == 80) lprintf(stream, ";%ld;%ld",
		(long)paperheight * 100, (long)paperwidth * 100);
	lputc('p', stream);

	lprintf(stream, "\033(J");
	lprintf(stream, "\033)I");
	lprintf(stream, "\033$*,0");
	lprintf(stream, "\033[?35l");

	lips_unit(stream, 0);
	lprintf(stream, "\033[?%d K",
		(int)(((long)dpi * 100 * 2) / lettersize));
	lprintf(stream, "\033[%d C", lettersize);
	lips_weight(stream, 0, 0);
	lprintf(stream, "\033[%dy", fontpattern);
	lprintf(stream, "\033n");
	lprintf(stream, "\033[?%d K", (int)(((long)dpi * 100) / lettersize));
	lprintf(stream, "\033[%d C", lettersize);
	lips_weight(stream, 0, 0);
	lprintf(stream, "\033[%dy", fontpattern);
	lputc(P_SI, stream);

	lprintf(stream, "\033[%d S", isvertical);
	lprintf(stream, "\033[?29%c", (isvertical) ? 'h' : 'l');

	lips_unit(stream, 0);
	lprintf(stream, "\033[%d;%d G",
		lineheight + lettersize, columnwidth + lettersize / 2);
	lprintf(stream, "\033n");
	lprintf(stream, "\033[%d;%d G",
		lineheight + lettersize, (columnwidth + lettersize / 2) * 2);
	lputc(P_SI, stream);

	lprintf(stream, "\033[?23h");
	lprintf(stream, "\033[?25h");
	lprintf(stream, "\033[0%%u");

	lprintf(stream, "\033[%dv", printnum);

	switch (overlaymode) {
		case 1:
		case 2:
			lprintf(stream, "\033[1;%1d;1&s", overlaymode - 1);
			break;
		case 3:
		case 4:
			lprintf(stream, "\033[1;%1d&w", overlaymode - 3);
			break;
		case 5:
			lprintf(stream, "\033[1;0;1&w");
			break;
		default:
			break;
	}

	resetcursor(stream, 0, 0);
	maxvmi = lastvmi = lettersize;
}

VOID backprocess(stream)
FILE *stream;
{
	lputc(P_FF, stream);
	lprintf(stream, "\033P0J\033\\");
	if (overlaymode != 1 && overlaymode != 2) lprintf(stream, "\033c");
	lprintf(stream, "\033H");
}
