/*
 *	POLS (Print Out program for Laser Shot)
 *
 *			by T.Shirai
 */

#include "lipsf.h"
#include "term.h"
#include "var.h"
#include "kanji.h"
#include "pversion.h"
#include <time.h>

#if	MSDOS
#include <dos.h>
extern char *strrdelim __P_((char *));
#else
#define	strrdelim(s)	strrchr(s, _SC_)
#endif

static char *stylefile = NULL;
char *printfile = NULL;
FILE *infile;
FILE *null;
int pagesum;

extern int line;
extern int step;
extern int page;
extern u_char *styletitle;
extern int kanjicode;

VOID error __P_((int));
VOID usage __P_((int));
VOID title __P_((VOID_A));
static VOID showfilename __P_((char *, char *));
static VOID savestring __P_((FILE *, char *));
static VOID savestyle __P_((char *));
static VOID doprintout __P_((char *, FILE *));
static VOID mainloop __P_((VOID_A));
int main __P_((int, char *[]));

extern int warning __P_((int, char *));
extern VOID varinit __P_((VOID_A));
extern VOID argfile __P_((char *));
extern int menu __P_((int));
extern int yesno __P_((char *));
extern VOID changestyle __P_((VOID_A));
extern VOID changeheadfoot __P_((VOID_A));
extern VOID changeoption __P_((VOID_A));
extern FILE *selectprint __P_((VOID_A));
extern VOID loadstyle __P_((char *));
extern char *getfilename __P_((char *, char *, int));

extern VOID getfileinfo __P_((char *, FILE *));
extern FILE *lpropen __P_((VOID_A));
extern VOID frontprocess __P_((FILE *));
extern VOID backprocess __P_((FILE *));
extern VOID printout __P_((FILE *));
#if	MSDOS
extern VOID initdir __P_((int));
extern VOID far fatalerr __P_((VOID_A));
extern VOID setfatalorg __P_((VOID_A));
#endif


VOID error(no)
int no;
{
	char *cp;

	if (no < 0) {
#if	MSDOS
		initdir(0);
#endif
		stdiomode();
		endterm();
		perror("\007\n");
		inittty(1);
		exit(127);
	}

	cp = strrdelim(stylefile);
	if (cp) cp++;
	else cp = stylefile;
	warning(no, cp);
}

/*ARGSUSED*/
VOID usage(no)
int no;
{
	error(EINVAL);
}

VOID title(VOID_A)
{
	putterm(t_clear);
	putterm(t_standout);
	cputs2("  POLS(PrintOut for LaserShot)   ");
	cprintf2("Version%-17.17s", strchr(version, ' '));
	cputs2("(c)1994-2002 T.Shirai  ");
	putterm(end_standout);
}

static VOID showfilename(prompt, file)
char *prompt, *file;
{
	int ch;

	ch = '\0';
	if (!file) file = "(none)";
	else if (strlen(file) > 61) {
		ch = file[61];
		file[61] = '\0';
	}
	cputs2("  ");
	putterm(t_standout);
	cprintf2("%s:", prompt);
	putterm(end_standout);
	cputs2(file);
	if (ch) file[61] = ch;
}

static VOID savestring(fp, str)
FILE *fp;
char *str;
{
	int i, len;

	len = strlen(str);
	for (i = 0; i < len; i++) {
		if (str[i] == '\\') fprintf(fp, "\\\\");
		else fputc(str[i], fp);
	}
}

static VOID savestyle(file)
char *file;
{
	FILE *fp;

	if (!(fp = fopen(file, "w"))) {
		warning(-1, file);
		return;
	}

	if (styletitle) fprintf(fp, ";%s\n", styletitle);

	if (papersize != PAPERSIZE) {
		fprintf(fp, "-p ");
		switch (papersize) {
			case 12:
				fprintf(fp, "A3");
				break;
			case 14:
				fprintf(fp, "A4");
				break;
			case 16:
				fprintf(fp, "A5");
				break;
			case 18:
				fprintf(fp, "Hagaki");
				break;
			case 24:
				fprintf(fp, "B4");
				break;
			case 26:
				fprintf(fp, "B5");
				break;
			default:
				fprintf(fp, "%dx%d", paperwidth, paperheight);
				break;
		}
		fputc('\n', fp);
	}

	if (cassette != CASSETTE) {
		fprintf(fp, "-m ");
		switch (cassette) {
			case 1:
				fprintf(fp, "Manual");
				break;
			case 2:
				fprintf(fp, "Lower");
				break;
			case 3:
				fprintf(fp, "Upper");
				break;
			default:
				fprintf(fp, "Auto");
				break;
		}
		fputc('\n', fp);
	}

	if (islandscape != ISLANDSCAPE) {
		fprintf(fp, "-d ");
		if (islandscape) fprintf(fp, "Landscape");
		else fprintf(fp, "Portrait");
		fputc('\n', fp);
	}

	if (fontpattern != FONTPATTERN) {
		fprintf(fp, "-f ");
		switch (fontpattern) {
			case 81:
				fprintf(fp, "Gothic");
				break;
			case 82:
				fprintf(fp, "Round-Gothic");
				break;
			default:
				fprintf(fp, "Mincho");
				break;
		}
		fputc('\n', fp);
	}

	if (kanjicode != DEF_KCODE) {
		if (kanjicode == SJIS) fprintf(fp, "-J sjis\n");
		else if (kanjicode == EUC) fprintf(fp, "-J euc\n");
	}

	if (lettersize != LETTERSIZE) fprintf(fp, "-s %d\n", lettersize);
	if (lineheight != LINEHEIGHT) fprintf(fp, "-h %d\n", lineheight);
	if (columnwidth != COLUMNWIDTH) fprintf(fp, "-w %d\n", columnwidth);
	if (controlmode) {
		if (controlchar == '\\') fprintf(fp, "-C \\\\\n");
		else fprintf(fp, "-C %c\n", controlchar);
	}
	if (headerstr && headermargin != HEADERMARGIN)
		fprintf(fp, "-A H%d\n", headermargin);
	if (footerstr && footermargin != FOOTERMARGIN)
		fprintf(fp, "-A F%d\n", footermargin);
	if (iszerosup != ISZEROSUP) fprintf(fp, "-A z\n");
	if (iskanjinum != ISKANJINUM) fprintf(fp, "-A k\n");
	if (istoupper != ISTOUPPER) fprintf(fp, "-A U\n");
	if (istolower != ISTOLOWER) fprintf(fp, "-A L\n");
	if (tabposition != TABPOSITION) fprintf(fp, "-t %d\n", tabposition);
	if (usrmaxcolumns >= 0) fprintf(fp, "-c %d\n", usrmaxcolumns);
	if (usrmaxlines >= 0) fprintf(fp, "-l %d\n", usrmaxlines);
	if (topmargin != TOPMARGIN) fprintf(fp, "-T %d\n", topmargin);
	if (bottommargin != -1) fprintf(fp, "-B %d\n", bottommargin);
	if (leftmargin != LEFTMARGIN) fprintf(fp, "-L %d\n", leftmargin);
	if (rightmargin != -1) fprintf(fp, "-R %d\n", rightmargin);
	if (headerstr) {
		fprintf(fp, "-H \"");
		savestring(fp, headerstr);
		fprintf(fp, "\"\n");
	}
	if (footerstr) {
		fprintf(fp, "-F \"");
		savestring(fp, footerstr);
		fprintf(fp, "\"\n");
	}
	if (overlaymode != OVERLAYMODE) fprintf(fp, "-O %d\n", overlaymode);

	if ((maxsteps > 1 && maxsteps != MAXSTEPS)
	|| (maxsteps == 1 && MAXSTEPS > 1)) {
		fprintf(fp, "-S %d", maxsteps);
		if (stepcolumns > -1) fprintf(fp, ",%d", stepcolumns);
		fputc('\n', fp);
	}
	if (isvertical != ISVERTICAL) fprintf(fp, "-v\n");
	if (isconcat != ISCONCAT) fprintf(fp, "-k\n");
	if (iskinsoku) fprintf(fp, "-K\n");
	if (lipsmode != LIPSMODE) fprintf(fp, "-%1d\n", lipsmode);

	fclose(fp);
}

static VOID doprintout(file, fp)
char *file;
FILE *fp;
{
	FILE *outfile;

	if (!file || !fp) return;

	if (!(infile = fopen(file, "r"))) {
		warning(-1, file);
		return;
	}

	if (!(null = fopen(NULLDEVICE, "w"))) error(-1);

	if (isinfo) outfile = null;
	else if (fp != stdout) outfile = fp;
	else outfile = lpropen();

	tzset();
	frontprocess(outfile);
	getfileinfo(file, infile);

	if ((headerstr && strstr(headerstr, "%P"))
	|| (footerstr && strstr(footerstr, "%P"))) {
		printout(null);
		if (fseek(infile, 0L, 0)) error(-1);
		pagesum = page;
	}

	printout(outfile);
	fclose(infile);
	if (isinfo) {
		if (line == 0) {
			line = maxlines;
			if (--step < 0) {
				step = maxsteps - 1;
				if (--page < 0) page = step = line = 0;
			}
		}
		locate(2, 13);
		cprintf2("%-24.24s: %4d %s\n", PAGSM_K, page + 1, PAGES_K);
		locate(2, 14);
		cprintf2("%-24.24s: %4d %s\n", STPSM_K, step + 1, STEPS_K);
		locate(2, 15);
		cprintf2("%-24.24s: %4d %s\n", LINSM_K, line, LINES_K);
		yesno(CNFOK_K);
	}
	backprocess(outfile);

	if (!isinfo) {
		if (fp != stdout) fclose(outfile);
#if	!MSDOS
		else if (pclose(outfile)) warning(EPIPE, NULL);
#endif
	}
	fclose(null);
}

static VOID mainloop(VOID_A)
{
	int no;
	char *name;

	no = 0;

	for (;;) {
		title();
		locate(0, 1);
		showfilename(FILEN_K, printfile);
		locate(0, 2);
		showfilename(STYF_K, stylefile);

		if (stylefile || stylefile) {
			locate(0, 4);
			showfilename(STYN_K, styletitle);
		}

		switch (no = menu(no)) {
			case 0:
				name = getfilename(printfile, NULL, 0);
				if (name) {
					if (printfile) free(printfile);
					printfile = name;
				}
				break;
			case 1:
				locate(0, 4);
				putterm(l_clear);
				changeheadfoot();
				break;
			case 2:
				name = getfilename(stylefile, POLSEXT, 0);
				if (name) {
					if (stylefile) free(stylefile);
					stylefile = name;
					loadstyle(name);
				}
				break;
			case 3:
				locate(0, 4);
				putterm(l_clear);
				doprintout(printfile, selectprint());
				break;
			case 4:
				locate(0, 4);
				putterm(l_clear);
				changestyle();
				break;
			case 5:
				locate(0, 4);
				putterm(l_clear);
				changeoption();
				break;
			case 6:
				name = getfilename(stylefile, POLSEXT, 1);
				if (name) {
					if (!yesno(REGOK_K)) free(name);
					else {
						if (stylefile) free(stylefile);
						stylefile = name;
						savestyle(name);
					}
				}
				break;
			case 7:
				if (yesno(OVROK_K)) return;
				break;
			default:
				break;
		}
	}
}

int main(argc, argv)
int argc;
char *argv[];
{
	char *path;
#if	MSDOS
	int drv;
#endif

	inittty(0);
	getterment();
	ttyiomode();
	initterm();
	getwsize(80, 24);

	path = (argc > 1) ? argv[1] : NULL;

#if	MSDOS
	initdir(1);
	setfatalorg();
	_dos_setvect(0x24, (VOID (far *)(VOID_A))fatalerr);

	if (path && isalpha(drv = path[0]) && path[1] == ':') {
		path += 2;
		if (drv >= 'a' && drv <= 'z') drv += 'A' - 'a';
		drv -= 'A' - 1;
		_dos_setdrive(drv, &drv);
	}
#endif
	if (path && chdir(path) < 0 && access(path, 0) >= 0) {
		printfile = (char *)malloc(strlen(path) + 1);
		strcpy(printfile, path);
	}

	varinit();
	headermargin = HEADERMARGIN;
	footermargin = FOOTERMARGIN;

	mainloop();

	locate(0, n_line);
#if	MSDOS
	initdir(0);
#endif
	exit2(0);
	return(0);
}
