/*
 *	argv.c
 *
 *	argument variable parser
 */

#include "mhpopd.h"
#include "kctype.h"

#define	ARGV_NORMAL	0
#define	ARGV_OPQUOTE	1
#define	ARGV_CLQUOTE	2
#define	ARGV_SQUOTE	3
#define	ARGV_DQUOTE	4
#define	ARGV_WORD	5
#define	ARGV_META	6

static int argv_ismeta __P_((char *, ALLOC_T, int));
static int argv_parse __P_((char *, ALLOC_T, int *));
static char *argv_addch __P_((char *, ALLOC_T *, int));


static int argv_ismeta(s, len, quote)
char *s;
ALLOC_T len;
int quote;
{
	if (s[0] != '\\' || quote == '\'') return(0);

	if (len <= (ALLOC_T)1) return(0);
	if (quote == '"' && (s[1] != quote || len <= 2)) return(0);

	return(1);
}

static int argv_parse(s, len, quotep)
char *s;
ALLOC_T len;
int *quotep;
{
	if (*s == *quotep) {
		*quotep = '\0';
		return(ARGV_CLQUOTE);
	}
	else if (iskanji1(s, 0)) return(ARGV_WORD);
#ifdef	CODEEUC
	else if (isekana(s, 0)) return(ARGV_WORD);
#endif
	else if (*quotep == '\'') return(ARGV_SQUOTE);
	else if (argv_ismeta(s, len, *quotep)) return(ARGV_META);
	else if (*quotep) return(ARGV_DQUOTE);
	else if (*s == '\'' || *s == '"') {
		*quotep = *s;
		return(ARGV_OPQUOTE);
	}

	return(ARGV_NORMAL);
}

static char *argv_addch(s, sizep, c)
char *s;
ALLOC_T *sizep;
int c;
{
	char *new;

	new = Xrealloc(s, (*sizep + 1) * sizeof(char));
	if (!new) {
		Xfree(s);
		return(NULL);
	}

	s = new;
	new[(*sizep)++] = c;

	return(s);
}

char **argv_getargv(s, len)
char *s;
ALLOC_T len;
{
	char *cp, *new, **argv;
	ALLOC_T size;
	int argc, quote;

	if (len == (ALLOC_T)-1) len = strlen(s);

	if (!(argv = list_init())) return(NULL);
	argc = 0;

	quote = '\0';
	cp = NULL;
	size = (ALLOC_T)0;
	while (len) {
		new = nullstr;
		switch (argv_parse(s, len, &quote)) {
			case ARGV_OPQUOTE:
				if (!cp) cp = new = Xmalloc(1);
				break;
			case ARGV_CLQUOTE:
				break;
			case ARGV_SQUOTE:
			case ARGV_DQUOTE:
				cp = new = argv_addch(cp, &size, *s);
				break;
			case ARGV_WORD:
				if (!(cp = argv_addch(cp, &size, *(s++)))) {
					list_free(argv);
					return(NULL);
				}
				len--;
				cp = new = argv_addch(cp, &size, *s);
				break;
			case ARGV_META:
				cp = new = argv_addch(cp, &size, *(++s));
				len--;
				break;
			default:
				if (!isspace2(*s)) {
					cp = new = argv_addch(cp, &size, *s);
					break;
				}
				if (!cp) break;
				argv = list_add(argv, argc++, cp, size);
				Xfree(cp);
				if (!argv) return(NULL);
				cp = NULL;
				size = (ALLOC_T)0;
				break;
		}

		if (!new) {
			list_free(argv);
			return(NULL);
		}
		s++;
		len--;
	}

	if (cp) argv = list_add(argv, argc++, cp, size);
	Xfree(cp);

	return(argv);
}

#ifdef	TEST
/*ARGSUSED*/
int main(argc, argv)
int argc;
char *argv[];
{
	XFILE *fp;
	ALLOC_T len;
	char *buf, **args;
	int i;

	nosyslog++;
	interactive++;
	if (sig_init() < 0) return(1);

	if (!(fp = Xfdopen(STDIN_FILENO, "r", -1, XF_NOCLOSE, pathstdin)))
		return(1);

	for (; (buf = Xfgets(fp, &len, XF_TRUNC)); Xfree(buf)) {
		if (!(args = argv_getargv(buf, len))) continue;

		for (i = 0; args[i]; i++)
			fprintf(stdout, "argv[%d] = <%s>\n", i, args[i]);
		list_free(args);
	}

	Xfclose(fp);

	return(0);
}
#endif
