/*
 *	dirent.c
 *
 *	directory entry managing
 */

#include "mhpopd.h"
#include "kctype.h"
#include "printf.h"
#include "fileio.h"

static int dir_isdot __P_((char *));
static int dir_isnumeric __P_((char *, int *));
static int dir_cmplist __P_((CONST VOID_P, CONST VOID_P));


static int dir_isdot(s)
char *s;
{
	if (!s || *s != '.') return(0);
	if (s[1] && (s[1] != '.' || s[2])) return(0);

	return(1);
}

static int dir_isnumeric(s, np)
char *s;
int *np;
{
	char buf[MAXLONGWIDTH + 1];
	int n;

	if (!s || !isdigit2(*s)) return(0);
	n = atoi(s);
	snprintf2(buf, sizeof(buf), "%d", n);
	if (strcmp(s, buf)) return(0);
	if (np) *np = n;

	return(1);
}

static int dir_cmplist(vp1, vp2)
CONST VOID_P vp1;
CONST VOID_P vp2;
{
	int *np1, *np2;

	np1 = (int *)vp1;
	np2 = (int *)vp2;

	return(*np1 - *np2);
}

int dir_getlist(folder, listp)
char *folder;
int **listp;
{
	DIR *dirp;
	struct dirent *dp;
	char path[MAXPATHLEN];
	int n, argc, val, *list, *new;

	if (!folder || !*folder) folder = inboxdir;
	if ((n = mh_genpath(path, sizeof(path), folder, -1)) < 0) return(-1);

	if (!(dirp = opendir(path))) {
		ERRORx(("%s: Cannot read dir", path));
		return(-1);
	}

	list = NULL;
	argc = 0;
	while ((dp = readdir(dirp))) {
		if (dir_isdot(dp -> d_name)) continue;
		if (!dir_isnumeric(dp -> d_name, &val)) continue;

		snprintf2(&(path[n]), sizeof(path) - n, "/%d", val);
		if (stat_isreg(path, 0) <= 0) continue;

		new = (int *)Xrealloc(list, (argc + 1) * sizeof(int));
		if (!new) {
			Xfree(list);
			closedir(dirp);
			return(-1);
		}
		list = new;
		list[argc++] = val;
	}
	closedir(dirp);

	if (!listp) Xfree(list);
	else {
		qsort(list, argc, sizeof(int), dir_cmplist);
		*listp = list;
	}

	return(argc);
}

int dir_atoi(folder, argv, listp)
char *folder, **argv;
int **listp;
{
	char **args, path[MAXPATHLEN];
	int i, j, n, argc, val, *list, *new;

	if (!argv) return(0);

	if (!folder || !*folder) folder = inboxdir;
	if ((n = mh_genpath(path, sizeof(path), folder, -1)) < 0) return(-1);

	list = NULL;
	argc = 0;
	for (i = 0; argv[i]; i++) {
		args = msg_getargv(argv[i], (ALLOC_T)-1);
		if (!args) continue;
		for (j = 0; args[j]; j++) {
			if (!dir_isnumeric(args[j], &val)) continue;

			snprintf2(&(path[n]), sizeof(path) - n, "/%d", val);
			if (stat_isreg(path, 0) <= 0) continue;

			new = (int *)Xrealloc(list, (argc + 1) * sizeof(int));
			if (!new) {
				Xfree(list);
				list_free(args);
				return(-1);
			}
			list = new;
			list[argc++] = val;
		}
		list_free(args);
	}

	if (!listp) Xfree(list);
	else {
		qsort(list, argc, sizeof(int), dir_cmplist);
		*listp = list;
	}

	return(argc);
}
