/*
 *	mhpop.h
 *
 *	header file for MHpop
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>
#include "machine.h"

#ifndef	NOUNISTDH
#include <unistd.h>
#endif

#ifndef	NOSTDLIBH
#include <stdlib.h>
#endif

#define	MHPOPD		"mhpopd"
#define	MHSMTPD		"mhsmtpd"
#define	MHP_POP3	0
#define	MHP_SMTP	1
#define	STRBUFUNIT	32
#define	MAXLINEBUF	255
#define	MAXLONGWIDTH	20			/* log10(2^64) = 19.266 */
#define	COREDUMPSIZE	(1024 * 1024)		/* maximum core dump size */
#define	MAXBACKLOG	5			/* backlog of listen() */
#define	WRITETIMEOUT	5			/* timeout to write() */

#define	DEFSPOOLDIR	"Mail"			/* local spool directory */
#define	DEFINBOXDIR	"inbox"			/* local folder */
#define	DEFINCPROC	"inc"			/* command name of inc */
#define	DEFSENDPROC	"send"			/* command name of send */
#define	DEFRMMPROC	"rmm"			/* command name of rmm */
#define	DEFCONTEXT	"context"		/* context file */
#define	DEFMSGPROTECT	0644			/* file mode of messages */
#define	DEFFLDPROTECT	0711			/* file mode of folders */
#define	DEFSEQUENCE	".mh_sequences"		/* sequence number file */
#define	DEFPASSWDFILE	".mhpopdpass"		/* password file */
#define	DEFPICKFILE	".pick"			/* pick list file */
#define	DEFPOP3PORT	110			/* POP3 */
#define	DEFSMTPPORT	25			/* SMTP */
#define	DEFPIDDIR	"/var/run"		/* full path for process ID */
#define	DEFMAXLOGSIZE	1024			/* maximum log size (KB) */
#define	DEFALLOWFILE	"/etc/users.allow"	/* full path for allow file */
#define	DEFDENYFILE	"/etc/users.deny"	/* full path for deny file */
#define	DEFMHPROFILE	".mh_profile"		/* MH profile name */
#define	DEFMHPOPDRC	".mhpopdrc"		/* user run com name */
#define	DEFTIMEOUT	5			/* timeout of read() */

#include "types.h"
#include "func.h"
#include "var.h"

#ifdef	NOERRNO
extern int errno;
#endif

#if	!defined (USESTRERROR) && !defined (DECLERRLIST)
extern char *sys_errlist[];
#endif

#ifdef	NOFILEMACRO
#define	FLMACRO		""
#else
#define	FLMACRO		__FILE__
#endif
#ifdef	NOFUNCMACRO
#define	FNMACRO		""
#else
#define	FNMACRO		__FUNCTION__
#endif
#ifdef	NOLINEMACRO
#define	LNMACRO		0
#else
#define	LNMACRO		__LINE__
#endif

#define	ERRORx(s)	do { \
				log_header(FLMACRO, FNMACRO, LNMACRO, \
					errno); \
				log_body s; \
			} while (0)
#define	ERROR0(s)	do { \
				log_header(FLMACRO, FNMACRO, LNMACRO, \
					0); \
				log_body s; \
			} while (0)
#define	DEBUG(n, s)	do { \
				if (debuglevel < (n)) break; \
				log_header(FLMACRO, FNMACRO, LNMACRO, \
					-1 - n); \
				log_body s; \
			} while (0)
