/*
 *	main.c
 *
 *	main module of MHpop
 */

#include "mhpopd.h"
#include "pop3.h"
#include "smtp.h"

static int NEAR setmyname __P_((char *));
static int NEAR mhpopd __P_((int, int));


static int NEAR setmyname(s)
char *s;
{
	char *cp;
	ALLOC_T len;

	if (!s) return(-1);
	if ((cp = strrchr(s, '/'))) s = ++cp;
#ifdef	CYGWIN
	if ((cp = strchr(s, '.')) && !strpathcmp(cp + 1, "exe")) len = cp - s;
	else
#endif
	len = strlen(s);
	myname = MHPOPD;
	if (len == sizeof(MHPOPD) - 1 && !strnpathcmp(s, myname, len)) {
		mh_protocol = MHP_POP3;
		return(0);
	}
	myname = MHSMTPD;
	if (len == sizeof(MHSMTPD) - 1 && !strnpathcmp(s, myname, len)) {
		mh_protocol = MHP_SMTP;
		return(0);
	}

	return(-1);
}

static int NEAR mhpopd(fdin, fdout)
int fdin, fdout;
{
	int (*func)__P_((XFILE *, XFILE *));
	XFILE *fpin, *fpout;
	int n;

	fpin = Xfdopen(fdout, "r", sockettimeout, XF_CONNECTED, pathsocket);
	if (!fpin) return(-1);
	fpout = Xfdopen(fdin, "w",
		sockettimeout, XF_NOCLOSE | XF_CONNECTED, pathsocket);
	if (!fpout) {
		Xfclose(fpin);
		return(-1);
	}

	mydomain = pwd_gethost();
	switch (mh_protocol) {
		case MHP_POP3:
			log_fpdump(5, "POP3 receive:", fpin);
			log_fpdump(5, "POP3 send:", fpout);
			func = pop_receive;
			n = pop_greeting(fpout);
			break;
		case MHP_SMTP:
			log_fpdump(5, "SMTP receive:", fpin);
			log_fpdump(5, "SMTP send:", fpout);
			func = smtp_receive;
			n = smtp_greeting(fpout);
			break;
		default:
			func = NULL;
			n = -1;
			break;
	}

	if (n >= 0) while (!(n = (*func)(fpin, fpout)))
		if (Xfeof(fpin) > 0 || (n = Xfflush(fpout)) < 0) break;

	if (n >= 0) fpout -> flags &= ~XF_CONNECTED;
	Xfclose(fpout);
	Xfclose(fpin);

	return(0);
}

int main(argc, argv)
int argc;
char *argv[];
{
	int n, s;

	conf_init(0);
	if (setmyname(argv[0]) < 0) {
		fprintf(stderr, "%s: Illegal program name\n", argv[0]);
		return(1);
	}
	if ((n = conf_args(argc, argv)) <= 0) return(-n);
	log_init();
	if (sig_init() < 0) return(1);
	if (conf_load(NULL, XF_INHEAD) < 0) return(1);
	if (pid_check() < 0) return(1);

	if (sock_issocket(STDIN_FILENO) && sock_issocket(STDOUT_FILENO))
		isinetd = 1;
	if (!isinetd && !interactive) daemonize = 1;

	if (interactive && term_init() < 0) return(1);
	if (daemonize && Xdaemon(0, 0) < 0) return(1);
	if (pid_create() < 0) return(1);

	DEBUG(0, ("Start daemon"));
	n = 0;
	if (isinetd) {
		if (mhpopd(STDIN_FILENO, STDOUT_FILENO) < 0) n++;
	}
	else while (sig_check(1) >= 0) {
		if ((s = sock_wait(portno)) >= 0) {
			ischild++;
			if (mhpopd(s, s) < 0) n++;
			break;
		}
		if (errno != EINTR) {
			n++;
			break;
		}
	}

	pid_unlink();
	sig_unlink();
	DEBUG(0, ((ischild) ? "Connection closed" : "End daemon"));
	log_end();

	return(n);
}
