.\"
.\" Copyright (c) 2005 Takashi SHIRAI
.\"                    <shirai@unixusers.net>
.\"
.\" @(#)mhpopd.8   1.00a 05/31/05
.\"   mhpopd - File & Directory maintenance tool
.TH MHPOPD 8 "May 31, 2005"
.de sh
.br
.PP
\fB\\$1\fR
.PP
..
.SH NAME
mhpopd, mhsmtpd \- a delivery server for MH\-type mail folder
.SH SYNOPSIS
.B mhpopd
[
.B \-hv
] [
.B \-Displtd
]
.br
.B mhsmtpd
[
.B \-hv
] [
.B \-Displtd
]
.SH DESCRIPTION
.B mhpopd
will send mails via POP3 from MH\-type local mail folders.
And then it will control local mails with
.BR inc (1)
and
.BR rmm (1)
the MH commands,
if they are configured as so.

.B mhsmtpd
will copy message files received via SMTP to a MH\-type local mail folder.
And then it will send them with
.BR send (1)
the MH command,
if it is configured as so.
.SS Options
.BR mhpopd ,
.B mhsmtpd
can take the following options when invoked.
.TP
.B \-h
It will list all options,
and exit.
.TP
.B \-v
It will display its version,
and exit.
.TP
.B \-D
It will be invoked as a daemon to run in the background.
This behavior is default when it is invoked on the command line.
.TP
.B \-i
It will run in the forground forcedly.
.TP
.BI \-s " file"
The server configuration file is
.IR file .
.TP
.BI \-p " port"
The port number is
.IR port .
.TP
.BI \-l " dir"
The directory where the log file is created is
.IR dir .
.TP
.BI \-t " timeout"
The input timeout in second from clients is
.IR timeout .
.TP
.BI \-d " debuglevel"
It allows to output verbose logs for debugging.
The larger
.IR debuglevel ,
the more informations.
.SS Crient configurations
In receiving configurations,
you must set "POP3" or "APOP" as the receiving protocol.
The default value of port number is
.BR 110 .
And you MAY use "POP3 AUTH" as the authentication method.

In sending configurations,
you must set "SMTP" as the sending protocol.
The default value of port number is
.BR 25 .
And you MUST use "SMTP AUTH" as the authentication method.

Each port number can be changed in the server configurations,
so that setting another value will cause you to match the client configuration to it.
And you must set the password string which is inputted with
.BR mhpasswd (1)
in the password configuration.

In case that you check to remove mails from the server in receiving configurations,
the server will change the seen information with rewriting the contents of public sequences file on the server.
And then it will remove specified mail files with invoking the command equivalent to
.BR rmm (1)
the MH command,
if configured as invoked.
.SS Server configurations
.B mhpopd
and
.B mhsmtpd
will load configuration parameters from the server configuration file.
The server configuration file is
.BR /etc/mhpopdrc ,
unless you specify the
.B \-s
option.
Each configuration parameter in this file must be described in this format:

	"\fIprofile\-component\fR\fB:\fP \fIvalue\fR"

.I profile\-component
is one of the following identifiers,
and
.I value
is the value of the configuration parameter which is indicated by the identifier.
.I profile\-component
is not case sensitive.

While lack of
.I value
means that the configuration parameter has no value,
the configuration line with no value is ignored if not otherwise specified.
If
.I value
extends across some lines,
the continuation lines must start with spaces or tabs.

In the following description of identifiers,
the parameter whose identifier is followed by "(MH)" means that the same identifier is used as the profile component in
.B .mh_profile
the user profile of MH.
.IP "\fBPath\fP (MH)" 10
The MH directory name of each user.
Unless it starts with "/",
it will be regarded as the directory under the home directory of each user.
It is used as the root of the local mail folders.
The default value is
.BR Mail .
.IP "\fBInbox\fP (MH)"
The inbox folder name of each user.
It exists just under the MH directory,
in which
.BR inc (1)
will incorporate mails.
The default value is
.BR inbox .
.IP "\fBDraft\-Folder\fP (MH)"
The draft folder name of each user.
It exists just under the MH directory,
in which the message sent by
.BR send (1)
will be created as the file.
No value means that
.B draft
the single file just under the MH directory will be overwritten.
The default value is none.
.IP "\fBmh\-Path\fP"
The directory name in which each MH command exists.
It must start with "/".
The default value is
.BR /usr/local/bin .
.IP "\fBincproc\fP (MH)"
.PD 0
.IP "\fBrmmproc\fP (MH)"
.PD 0
.IP "\fBsendproc\fP (MH)"
.PD
The MH command name which is invoked as
.BR inc (1),
.BR rmm (1)
and
.BR send (1).
Unless it starts with "/",
it will be regarded as the command under the directory specified by
.BR mh\-Path .
No value means that no command invoked as each MH command exists.
The default value is
.BR inc ,
none,
.B send
respectively.
.IP "\fBcontext\fP (MH)"
The MH context file name of each user.
It exists just under the MH directory,
in which each MH command will write the dynamic information such as the current folder name.
The default value is
.BR context .
.IP "\fBMsg\-Protect\fP (MH)"
The message file mode of each user.
It specifies the octal protection bits for created message files.
The default value is
.BR 644 .
.IP "\fBFolder\-Protect\fP (MH)"
The folder directory mode of each user.
It specifies the octal protection bits for created folder directories.
The default value is
.BR 711 .
.IP "\fBmh\-sequences\fP (MH)"
The public sequences file name.
It exists just under each folder in the MH directory,
in which the current message number of the folder is described.
The default value is
.BR .mh_sequences .
.IP "\fBpasswordfile\fP"
The user authentication password file name.
Unless it starts with "/",
it will be regarded as the file under the home directory of each user.
The password which is used in user authentication of POP3 and SMTP is described in it.
No value means that no authentication password file is used.
The default value is
.BR .mhpopdpass .
.IP "\fBincprompt\fP"
The password prompt string for
.BR inc (1).
It specifies the password prompt string with some shell\-like wildcard characters,
if
.BR inc (1)
will require your password.
When the line which macthes the specified pattern is found in terminal outputs from the command,
the server will automatically reply the password string specified by
.B passwordfile
or
.BR my\-passwd .
No value means no reply for the command.
The defalut value is none.
.IP "\fBpickfile\fP"
The mail sort controlling file name.
Unless it starts with "/",
it will be regarded as the file under the MH directory of each user.
The mail auto\-sorting rule after
.BR inc (1)
is described in this file,
which format is describes later in
.BR "Mail sort controlling file" .
It specifies the file, which describes the rule
No value means that no mail is sorted automativally.
The default value is
.BR .pick .
.IP "\fBenvpath\fP"
The value of the environment variable
.B PATH
for the MH commands.
It specifies the value of the environment variable
.B PATH
which is passed to each MH command when invoked.
No value means that the environment variable
.B PATH
is not passed.
The default value is none.
.IP "\fBpop3port\fP"
.PD 0
.IP "\fBsmtpport\fP"
.PD
The port number used by
.B mhpopd
and
.BR mhsmtpd .
The default value is
.B 110
and
.B 25
respectively.
Notice that it is overwritten by the option
.BR \-p .
.IP "\fBpiddir\fP"
The process ID directory name of the server program.
It must start with "/".
It specifies the directory,
in which the process ID file is created to write the process ID of running
.B mhpopd
and
.BR mhsmtpd .
And the process ID file name is the string of each server program name followed by the extension
.BR .pid .
Unless the server program is running as root,
the process ID file will be created just under the home directory of the effective user.
The default value is
.BR /var/run .
.IP "\fBlogdir\fP"
The log directory name of the server program.
It must start with "/".
It specifies the directory,
in which the log file is created for server logging.
And the log file name is the same as each server program name.
No value means that no logging is reported except the system message logging.
The default value is none.
Notice that it is overwritten by the option
.BR \-l .
.IP "\fBmaxlogsize\fP"
The log file size of the server program.
It specifies the maximum kilobyte size of the log file created in the directory specified by
.BR logdir .
If the size exceeds this value,
the last log file will be renamed as the file name followed by the extension
.B .old
to create another new log file.
The default value is
.BR 1024 (1MB).
.IP "\fBnosyslog\fP"
The boolean to suppress the system message logging by
.BR syslogd (8).
The value of
.B yes
or
.B 1
means that no logging is reported except the log file.
The default value is none.
.IP "\fBusers\-allow\fP"
.PD 0
.IP "\fBusers\-deny\fP"
.PD
The user access controlling file name.
It must start with "/".
The users who are allowed or denied access are listed in these files,
which format is described later in
.BR "User access controlling files" .
No value means that the empty file is specified.
The default value is
.B /etc/users.allow
and
.BR /etc/users.deny .
.IP "\fBhostname\fP"
The server host name.
It specifies the host name sent in the reply for client programs.
No value means that the host name configured with OS where the server is invoked.
The default value is none.
.IP "\fBmh\-profile\fP"
The MH user profile name.
It exists just under the home directory of each user,
in which parameters for MH are written.
No value means that no MH user profile is used.
The default value is
.BR .mh_profile .
.IP "\fBmhpopdrc\fP"
The user configuration file name.
It exists just under the home directory of each user,
in which configuration parameters for each user are written.
No value means that no user configuration file is used.
The default value is
.BR .mhpopdrc .
.IP "\fBtimeout\fP"
The timeout for the client input.
In case the client input pauses more than seconds specified by this value,
the server will close connection forcedly.
The default value is
.BR 30 .
Notice that it is overwritten by the option
.BR \-t .
.IP "\fBdebuglevel\fP"
The debug level.
It allows to output verbose logs for debugging.
The larger value,
the more informations.
No value or the value
.B 0
means no information is outputted except error informations.
The default value is none.
Notice that it is overwritten by the option
.BR \-d .
.SS User configurations
.B mhpopd
and
.B mhsmtpd
will load user configuration parameters from the files specified by
.B mh\-profile
and
.B mhpopdrc
the configuration parameter in the server configuration file,
in this order.
If you want to use the different value than the MH profile component
or to set the parameters which don't exist in the MH profile component,
you should describe them in the file specified by
.BR mhpopdrc .

The format of these files is similar to that of the server configuration file,
and
.I profile\-component
means one of the following identifiers.
The parameter whose identifier is the same as the server configuration file will
be overwritten by these configuration files.
.IP "\fBPath\fP" 10
.PD 0
.IP "\fBInbox\fP"
.PD 0
.IP "\fBDraft\-Folder\fP"
.PD 0
.IP "\fBmh\-Path\fP"
.PD 0
.IP "\fBincproc\fP"
.PD 0
.IP "\fBrmmproc\fP"
.PD 0
.IP "\fBsendproc\fP"
.PD 0
.IP "\fBcontext\fP"
.PD 0
.IP "\fBMsg\-Protect\fP"
.PD 0
.IP "\fBFolder\-Protect\fP"
.PD 0
.IP "\fBmh\-sequences\fP"
.PD 0
.IP "\fBpasswordfile\fP"
.PD 0
.IP "\fBincprompt\fP"
.PD 0
.IP "\fBpickfile\fP"
.PD 0
.IP "\fBenvpath\fP"
.PD
The same in the server configuration file.
.IP "\fBmy\-password\fP"
The user authentication password.
It specifies the password string used in the user authentication,
in plain text.
No value means that the user authentication password file specified by
.B passwordfile
is used,
but no value of
.B passwordfile
together will cause to fail authentication.
The default value is none.
.IP "\fBmy\-folders\fP"
The list of the MH folders to be sent.
It specifies the MH folders which is sent to clients by
.BR mhpopd ,
separated by spaces or tabs.
No value means that the only folder specified by
.B Inbox
is the target to be sent.
The default value is none.
.SS Mail sort controlling file
The file specified by
.BR pickfile ,
the parameter in the server configuration file,
will control the mail auto\-sorting.
This file will control which mail is sorted into which folder after
.BR inc (1),
from the folder specified by
.BR Inbox .

The format of this file is similar to that of the server configuration file,
.I profile\-component
means the destinasion folder name and
.I value
means the command name which picks mails and its arguments.
Unless it starts with "/",
it will be regarded as the command under the directory specified by
.BR mh\-Path .
Each argument is sepalated by spaces or tabs,
then you must escape these characters with "\e" or quote them with ' or " in any argument.
Multiple lines means that there are the multiple folders where you want to sort.

The example when you use
.BR pick (1)
the MH command:

	"mymail: pick \-from myname@mydomain"

This specifies the mails whose header has the field "From:" with the value of "myname$mydomain" will be sorted into the folder "mymail".
You can refer to each MH documents for details of
.BR pick (1)
options.
If you use the command except
.BR pick (1),
it must list the message numbers of specified mails separated by spaces, tabs or linefeed into the terminal output.
.SS User access controlling files
The files specified by
.B users\-allow
and
.BR users\-deny ,
the parameters in the server configuration file,
will control whose access from client programs is allowed or denied.
First,
the file specified by
.B users\-allow
is confirmed to allow access of the users who are described in this file.
Next,
the file specified by
.B users\-deny
is confirmed to deny access of the users who are described in this file.
Finally,
the server will allow access of the users who are described in neither file.

Each line of these user access controlling files must be described in this format:

	"\fIserver_name\fR\fB:\fP \fIuser\fR ..."

.I server_name
is one of the string
.BR mhpopd ,
.B mhsmtpd
and
.BR ALL ,
to specify the target server program.
.B ALL
means that the target is any server program.

.I user
is the target user name, separated by spaces or tabs.
The user name starts with
.B @
means that the target is any user who belongs to the group named as the string next to
.BR @ .
.B ALL
means that the target is any user.
.SH ENVIRONMENT VARIABLES
.B mhpopd
and
.B " mhsmtpd"
will invoke each MH command with the following environment variables.
No environment variable is set except them.
If the invoked program needs the other environment variables,
you should manage the program to be invoked from the shell script,
in which you set the environment variables.
.IP "\fBPATH\fP" 14
The content specified by the parameter
.BR envpath .
.IP "\fBUSER\fP"
The user name of authenticated user.
.IP "\fBHOME\fP"
The home directory name of authenticated user.
.IP "\fBSHELL\fP"
The login shell name of authenticated user.
.SH AUTHOR
Takashi SHIRAI <shirai@unixusers.net>
.SH FILES
.PD 0
.TP 20
.B /etc/mhpopdrc
The default name of the server configuration file.
.TP
.B /etc/users.allow
.TP
.B /etc/users.deny
The default name of the user access controlling file.
.TP
.B ~/.mh_profile
The default name of the MH user profile.
.TP
.B ~/.mhpopdrc
The default name of the user configuration file.
.TP
.B ~/.mhpopdpass
The default name of the user authentication password file.
.TP
.B ~/Mail
The default name of the MH directory.
.TP
.B ~/Mail/.pick
The default name of the mail sort controlling file.
.PD
.SH SEE ALSO
.BR mh (1),
.BR inc (1),
.BR rmm (1),
.BR send (1),
.BR pick (1),
.BR mhpasswd (1),
.BR syslogd (8)
.SH COPYRIGHT
Copyright (C) 2005 by Takashi SHIRAI
