/*
 *	pop3.h
 *
 *	header for POP3
 */

#define	POP_OK		"+OK"
#define	POP_ERR		"-ERR"
#define	POP_MAXBUF	1024
#define	POP_MAXARG	40
#define	POP_STAT_AUTH	0
#define	POP_STAT_USER	1
#define	POP_STAT_TRANS	2
#define	POP_STAT_UPDATE	3
#define	POP_XUIDL	"X-UIDL:"

typedef struct _pop3_t {
	char *folder;
	int file;
	ALLOC_T size;
	char *uidl;
	u_int flags;
} pop3_t;
#define	POP_DELETED	000001

extern char pop_okstr[];
extern char pop_errstr[];
extern int pop_status;
extern char *pop_timestamp;
extern char *pop_username;
extern char **pop_folders;
extern pop3_t *pop_msglist;
extern int pop_maxmsg;

/* pop3.c */
extern VOID pop_free __P_((VOID_A));
extern int pop_fetch __P_((VOID_A));
extern int pop_gettotal __P_((ALLOC_T *));
extern int pop_getmsgno __P_((char *));
extern XFILE *pop_openmsg __P_((int));
extern int pop_update __P_((VOID_A));

/* pop3recv.c */
extern int pop_receive __P_((XFILE *, XFILE *));

/* pop3send.c */
extern int pop_senderror __P_((XFILE *fp));
extern int pop_sendok __P_((XFILE *, CONST char *fmt, ...));
extern int pop_sendwarning __P_((XFILE *fp, CONST char *fmt, ...));
extern int pop_greeting __P_((XFILE *));
