/*
 *	stat.c
 *
 *	getting file status
 */

#include "mhpopd.h"
#include "fileio.h"


static int NEAR Xstat __P_((char *, struct stat *, int));

static int NEAR Xstat(path, buf, errflags)
char *path;
struct stat *buf;
int errflags;
{
	for (;;) {
		if (stat(path, buf) >= 0) {
			errno = 0;
			return(0);
		}
		else if (errno != EINTR || sig_check(0) < 0) break;
	}

	if (errflags & XF_IGNOREERR)
		DEBUG(4, ("%s: Cannot get file status", path));
	else if ((errflags & XF_IGNORENOENT) && errno == ENOENT)
		DEBUG(4, ("%s: Cannot find file", path));
	else ERRORx(("%s: Cannot get file status", path));

	return(-1);
}

int stat_getsize(path, sizep, errflags)
char *path;
ALLOC_T *sizep;
int errflags;
{
	struct stat st;

	if (Xstat(path, &st, errflags) < 0) return(-1);
	if (sizep) *sizep = st.st_size;

	return(0);
}

int stat_gettime(path, tp, errflags)
char *path;
time_t *tp;
int errflags;
{
	struct stat st;

	if (Xstat(path, &st, errflags) < 0) return(-1);
	if (tp) *tp = st.st_mtime;

	return(0);
}

int stat_getmode(path, modep, errflags)
char *path;
u_int *modep;
int errflags;
{
	struct stat st;

	if (Xstat(path, &st, errflags) < 0) return(-1);
	if (modep) *modep = st.st_mode;

	return(0);
}

int stat_isdir(path, errflags)
char *path;
int errflags;
{
	struct stat st;

	if (Xstat(path, &st, errflags) < 0) return(-1);

	return(((st.st_mode & S_IFMT) == S_IFDIR) ? 1 : 0);
}

int stat_isreg(path, errflags)
char *path;
int errflags;
{
	struct stat st;

	if (Xstat(path, &st, errflags) < 0) return(-1);

	return(((st.st_mode & S_IFMT) == S_IFREG) ? 1 : 0);
}

int stat_cloexec(fd, path)
int fd;
char *path;
{
	int flags;

	if ((flags = Xfcntl(fd, F_GETFD, 0, path)) < 0) return(-1);
	if (Xfcntl(fd, F_SETFD, flags | FD_CLOEXEC, path) < 0) return(-1);

	return(0);
}
