/*
 *	func.h
 *
 *	function prototype declarations
 */

/* macros */
#ifdef	USESTRERROR
#define	Xstrerror	strerror
#else
#define	Xstrerror(n)	(char *)sys_errlist[n]
#endif

#ifdef	USESIGPMASK
#define	Xsigemptyset(m)	sigemptyset(&(m))
#define	Xsigfillset(m)	sigfillset(&(m))
#define	Xsigaddset(m,s)	sigaddset(&(m), s)
#define	Xsigdelset(m,s)	sigdelset(&(m), s)
#else	/* !USESIGPMASK */
#define	Xsigemptyset(m)	((m) = 0)
#define	Xsigfillset(m)	((m) = ~0)
#define	Xsigaddset(m,s)	((m) |= sigmask(s))
#define	Xsigdelset(m,s)	((m) &= ~sigmask(s))
#endif	/* !USESIGPMASK */

#ifdef	USEWAITPID
#define	Xwait3(s,o,r)	waitpid(-1, s, o)
#else
#define	Xwait3		wait3
#endif

#ifdef	GETPGRPVOID
#define	Xgetpgrp	getpgrp
#else
#define	Xgetpgrp()	getpgrp(0)
#endif

#if	(GETTODARGS == 1)
#define	Xgettimeofday(tv, tz)	gettimeofday(tv)
#else
#define	Xgettimeofday(tv, tz)	gettimeofday(tv, tz)
#endif

#ifdef	USEGETWD
#define	Xgetwd		getwd
#else
#define	Xgetwd(p)	getcwd(p, MAXPATHLEN)
#endif

#ifdef	USERAND48
#define	Xsrandom	srand48
#define	Xrandom		lrand48
#else
#define	Xsrandom	srandom
#define	Xrandom		random
#endif

#ifdef	CYGWIN
#define	strpathcmp	Xstrcasecmp
#define	strnpathcmp	Xstrncasecmp
#else
#define	strpathcmp	strcmp
#define	strnpathcmp	strncmp
#endif

#define	base64siz(n)	((((n) - 1) / 3 + 1) * 4)

/* syscall.c */
extern int Xselect __P_((int, int, int));
extern int Xread __P_((int, u_char *, ALLOC_T, int, char *));
extern int Xwrite __P_((int, u_char *, ALLOC_T, int, char *));
extern int Xopen __P_((char *, int, int, int));
extern VOID Xclose __P_((int, char *));
extern off_t Xlseek __P_((int, off_t, int, char *));
extern int Xfcntl __P_((int, int, VOID_P, char *));
#ifndef	NOFLOCK
extern int Xflock __P_((int, int, char *));
#endif
extern int Xftruncate __P_((int, off_t, char *));
extern int Xpipe __P_((int *));
extern int Xdup2 __P_((int, int, char *));
extern int Xchdir __P_((char *));
extern int Xrename __P_((char *, char *));
extern int Xunlink __P_((char *));
extern int Xsetreuid __P_((uid_t, uid_t));
extern int Xsetregid __P_((gid_t, gid_t));
extern p_id_t Xsetsid __P_((VOID_A));
extern p_id_t Xfork __P_((VOID_A));
extern int Xsetpgrp __P_((p_id_t, p_id_t));
extern VOID Xexecve __P_((char *, char *[], char *[]));

/* libc.c */
extern VOID Xfree __P_((VOID_P));
extern char *Xmalloc __P_((ALLOC_T));
extern char *Xrealloc __P_((VOID_P, ALLOC_T));
extern char *Xstrdup __P_((char *));
extern char *Xstrndup __P_((char *, ALLOC_T));
extern VOID Xfclose __P_((XFILE *));
extern XFILE *Xfopen __P_((char *, char *, int, int));
extern XFILE *Xfdopen __P_((int, char *, int, int, char *));
extern VOID Xclearerr __P_((XFILE *));
extern int Xfeof __P_((XFILE *));
extern int Xferror __P_((XFILE *));
extern int Xfflush __P_((XFILE *));
extern int Xfseek __P_((XFILE *, off_t, int));
extern off_t Xftell __P_((XFILE *));
extern int Xrewind __P_((XFILE *));
extern int Xfread __P_((u_char *, ALLOC_T, XFILE *));
extern int Xfwrite __P_((u_char *, ALLOC_T, XFILE *));
extern int Xfgetc __P_((XFILE *));
extern int Xfputc __P_((int, XFILE *));
extern char *Xfgets __P_((XFILE *, ALLOC_T *, int));
extern int Xfputs __P_((char *, XFILE *));
extern int Xungetc __P_((int, XFILE *));
extern int Xusleep __P_((u_long));
extern int Xstrcasecmp __P_((char *, char *));
extern int Xstrncasecmp __P_((char *, char *, ALLOC_T));
extern int Xdaemon __P_((int, int));

/* list.c */
extern int list_count __P_((char **));
extern char **list_init __P_((VOID));
extern char **list_add __P_((char **, int, char *, ALLOC_T));
extern char **list_tryadd __P_((char **, char *));
extern VOID list_free __P_((char **));

/* time.c */
time_t Xtime __P_((time_t *));
int time_getdatestr __P_((char *, ALLOC_T));

/* term.c */
extern int Xioctl __P_((int, int, VOID_P));
extern VOID term_safeclose __P_((int, char *));
extern VOID term_loadtermio __P_((int, char *, char *));
extern VOID term_savetermio __P_((int, char **, char **));
extern VOID term_getterm __P_((char **, char **));
extern VOID term_closetty __P_((VOID_A));
extern int term_gettty __P_((VOID_A));
extern int term_hastty __P_((VOID_A));
extern int term_init __P_((VOID_A));

/* signal.c */
extern int sig_init __P_((VOID_A));
extern VOID sig_child __P_((VOID_A));
extern VOID sig_blockchild __P_((VOID_A));
extern VOID sig_unblockchild __P_((VOID_A));
extern VOID sig_push __P_((char *));
extern VOID sig_pop __P_((char *));
extern VOID sig_unlink __P_((VOID_A));
extern int sig_check __P_((int));

/* wait.c */
extern int wait_children __P_((VOID_A));
extern VOID wait_discard __P_((VOID_A));
extern int wait_push __P_((p_id_t));
extern int wait_pop __P_((p_id_t, int *));
extern VOID wait_cancel __P_((p_id_t));
extern int wait_child __P_((p_id_t));

/* md5.c */
extern VOID md5_encode __P_((u_char *, ALLOC_T *, u_char *, ALLOC_T));
extern VOID md5_hmac __P_((u_char *, ALLOC_T *, char *, char *));
extern int md5_fencode __P_((u_char *, ALLOC_T *, VOID_P,
	int (*)__P_((u_char *, ALLOC_T, VOID_P))));

/* base64.c */
extern int base64_encode __P_((char *, ALLOC_T, u_char *, ALLOC_T));
extern int base64_decode __P_((u_char *, ALLOC_T *, char *, ALLOC_T));

/* passwd.c */
extern int passwd_encode __P_((char *, ALLOC_T, char *, int));
extern int passwd_decode __P_((char *, ALLOC_T, char *));

/* pid.c */
extern int pid_check __P_((VOID_A));
extern int pid_create __P_((VOID_A));
extern VOID pid_unlink __P_((VOID_A));

/* log.c */
extern VOID log_init __P_((VOID_A));
extern VOID log_end __P_((VOID_A));
extern VOID log_header __P_((CONST char *, CONST char *, int, int));
extern VOID log_body __P_((CONST char *, ...));
extern char *log_strerror __P_((VOID_A));
extern VOID log_dump __P_((u_char *, ALLOC_T, char *));
extern VOID log_fpdump __P_((int, char *, XFILE *));

/* config.c */
extern VOID conf_init __P_((int));
extern char *conf_getversion __P_((int *));
extern int conf_args __P_((int, char *[]));
extern char *conf_getline __P_((XFILE *, int));
extern int conf_load __P_((char *, int));
extern VOID conf_push __P_((VOID_A));
extern VOID conf_pop __P_((VOID_A));

/* socket.c */
extern VOID Xshutdown __P_((int, int));
extern int sock_issocket __P_((int));
extern int sock_wait __P_((int));
extern char *sock_getline __P_((XFILE *, ALLOC_T *));

/* stat.c */
extern int stat_getsize __P_((char *, ALLOC_T *, int));
extern int stat_gettime __P_((char *, time_t *, int));
extern int stat_getmode __P_((char *, u_int *, int));
extern int stat_isdir __P_((char *, int));
extern int stat_isreg __P_((char *, int));
extern int stat_cloexec __P_((int, char *));

/* filesys.c */
extern char *fsys_getmnttype __P_((char *));
extern int fsys_isnfs __P_((char *));

/* pwd.c */
extern char *pwd_gethome __P_((uid_t));
extern char *pwd_getpass __P_((char *));
extern int pwd_login __P_((char *));
extern char *pwd_gethost __P_((VOID_A));

/* pty.c */
extern int Xopenpty __P_((int *, char *, ALLOC_T));
extern int Xlogin_tty __P_((char *, char *, char *));
extern p_id_t Xforkpty __P_((int *, char *, char *));

/* wild.c */
extern u_short *wild_init __P_((char *, ALLOC_T));
extern int wild_match __P_((char *, ALLOC_T, u_short *));

/* argv.c */
extern char **argv_getargv __P_((char *, ALLOC_T));

/* dirent.c */
extern int dir_getlist __P_((char *, int **));
extern int dir_atoi __P_((char *, char **, int **));

/* mhcmd.c */
extern int mh_genpath __P_((char *, ALLOC_T, char *, int));
extern int mh_getseq __P_((char *));
extern int mh_setseq __P_((char *, int));
extern XFILE *mh_opendraft __P_((char *, ALLOC_T));
extern int mh_inc __P_((VOID_A));
extern int mh_pick __P_((char *, char **, char ***));
extern int mh_rmm __P_((char *, char **));
extern int mh_send __P_((char *));

/* message.c */
extern char *msg_getline __P_((XFILE *, ALLOC_T *, int));
extern int msg_putline __P_((char *, XFILE *));
extern char *msg_getfield __P_((char *, ALLOC_T *, int));
extern int msg_send __P_((XFILE *, CONST char *, ...));
extern int msg_sendeom __P_((XFILE *));
extern char **msg_getargv __P_((char *, ALLOC_T));
extern VOID msg_hex __P_((char *, ALLOC_T, u_char *, ALLOC_T));

/* auth.c */
extern int auth_cmppasswd __P_((char *, char *));
extern int auth_ehlo __P_((char *, XFILE *));
extern int auth_setmech __P_((char **, XFILE *));
extern int auth_input __P_((char *, XFILE *));
