/*
 *	pid.c
 *
 *	process ID management
 */

#include "mhpopd.h"
#include "fileio.h"
#include <signal.h>

static int NEAR pid_filename __P_((char *, ALLOC_T));


static int NEAR pid_filename(path, size)
char *path;
ALLOC_T size;
{
	uid_t uid;
	char *cp;
	int n;

	cp = (piddir && *piddir == '/') ? piddir : DEFPIDDIR;
	if ((uid = geteuid()) && !(cp = pwd_gethome(uid))) return(-1);
	n = stat_isdir(cp, XF_IGNORENOENT);
	if (n < 0 && errno == ENOENT) mkdir(cp, 0755);
	else if (n <= 0) return(-1);
	snprintf2(path, size, "%s/%s.pid", cp, myname);

	return(0);
}

int pid_check(VOID_A)
{
	XFILE *fp;
	p_id_t pid;
	char path[MAXPATHLEN], buf[MAXLONGWIDTH + 1 + 1];
	int n;

	if (pid_filename(path, sizeof(path)) < 0) return(-1);
	if (!(fp = Xfopen(path, "r", 0, XF_IGNORENOENT))) {
		if (errno == ENOENT) return(0);
		n = -1;
	}
	else {
		n = Xfread((u_char *)buf, strsize(buf), fp);
		Xfclose(fp);
	}

	if (n >= 0) {
		buf[n] = '\0';
		pid = atoi(buf);
		if (kill(pid, 0) >= 0) {
			ERROR0(("Daemon running already (pid=%d)", pid));
			return(-1);
		}
	}

	VOID_C Xunlink(path);

	return(0);
}

int pid_create(VOID_A)
{
	XFILE *fp;
	char path[MAXPATHLEN], buf[MAXLONGWIDTH + 1 + 1];
	int n;

	if (ischild || isinetd) return(0);
	if (pid_filename(path, sizeof(path)) < 0) return(-1);
	n = umask(022);
	fp = Xfopen(path, "w", O_EXCL, 0);
	VOID_C umask(n);
	if (!fp) {
		Xunlink(path);
		return(-1);
	}

	n = snprintf2(buf, sizeof(buf), "%d\n", getpid());
	n = Xfwrite((u_char *)buf, n, fp);
	if (n >= 0) n = Xfflush(fp);
	Xfclose(fp);

	if (n < 0) Xunlink(path);

	return(n);
}

VOID pid_unlink(VOID_A)
{
	char path[MAXPATHLEN];

	if (ischild || isinetd) return;
	if (pid_filename(path, sizeof(path)) < 0) return;

	VOID_C Xunlink(path);
}
