/*
 *	pop3.c
 *
 *	POP3 (Post Office Protocol V3) in RFC1939
 */

#include "mhpopd.h"
#include "kctype.h"
#include "pop3.h"
#include <sys/param.h>

typedef int (*md5_fread_t)__P_((u_char *, ALLOC_T, VOID_P));

char pop_okstr[] = POP_OK;
char pop_errstr[] = POP_ERR;
int pop_status = POP_STAT_AUTH;
char *pop_timestamp = NULL;
char *pop_username = NULL;
char **pop_folders = NULL;
pop3_t *pop_msglist = NULL;
int pop_maxmsg = 0;

static pop3_t *NEAR pop_initlist __P_((VOID_A));
static pop3_t *NEAR pop_addlist __P_((pop3_t *, int,
		char *, int, ALLOC_T, char *));
static VOID NEAR pop_freelist __P_((pop3_t *));
static int NEAR pop_getfolders __P_((VOID_A));
static char *NEAR pop_getuidl __P_((char *, int, ALLOC_T *));


static pop3_t *NEAR pop_initlist(VOID_A)
{
	pop3_t *new;

	if (!(new = (pop3_t *)Xmalloc(sizeof(pop3_t)))) return(NULL);
	new[0].folder = NULL;

	return(new);
}

static pop3_t *NEAR pop_addlist(list, n, folder, file, size, uidl)
pop3_t *list;
int n;
char *folder;
int file;
ALLOC_T size;
char *uidl;
{
	pop3_t *new;

	if (n >= 0) /*EMPTY*/;
	else if (!list) n = 0;
	else for (n = 0; list[n].folder; n++);

	if (!(new = (pop3_t *)Xrealloc(list, (n + 1 + 1) * sizeof(pop3_t)))) {
		while (n-- > 0) Xfree(list[n].uidl);
		Xfree(list);
		return(NULL);
	}

	new[n].folder = folder;
	new[n].file = file;
	new[n].size = size;
	new[n].uidl = uidl;
	new[n].flags = 0;
	new[++n].folder = NULL;

	return(new);
}

static VOID NEAR pop_freelist(list)
pop3_t *list;
{
	int i;

	if (!list) return;

	for (i = 0; list[i].folder; i++) Xfree(list[i].uidl);
	Xfree(list);
}

VOID pop_free(VOID_A)
{
	pop_freelist(pop_msglist);
	pop_msglist = NULL;
	pop_maxmsg = 0;
	list_free(pop_folders);
	pop_folders = NULL;
}

static int NEAR pop_getfolders(VOID_A)
{
	char **argv;

	argv = msg_getargv((folders && *folders) ? folders : inboxdir,
		(ALLOC_T)-1);
	if (!argv) return(-1);

	list_free(pop_folders);
	pop_folders = argv;

	return(0);
}

static char *NEAR pop_getuidl(folder, n, lenp)
char *folder;
int n;
ALLOC_T *lenp;
{
	XFILE *fp;
	ALLOC_T len, size, last;
	u_char md5[16];
	char *cp, *buf, tmp[POP_MAXBUF], path[MAXPATHLEN];
	time_t t;
	int i, flags;

	if (mh_genpath(path, sizeof(path), folder, n) < 0) return(NULL);

	if (stat_gettime(path, &t, 0) < 0) return(NULL);
	n = snprintf2(tmp, sizeof(tmp), "%lx.", t);

	if (!(fp = Xfopen(path, "r", 0, 0))) return(NULL);
	size = (ALLOC_T)0;
	last = (ALLOC_T)-1;
	flags = (XF_IGNOREERR | XF_INHEAD | XF_KEEPCRLF);
	for (; (buf = msg_getline(fp, &len, flags)); Xfree(buf)) {
		last = len;
		size += len;
		if (buf == nullstr) {
			flags &= ~XF_INHEAD;
			size += 2;
			buf = NULL;
			continue;
		}
		else if (!(flags & XF_INHEAD)) {
			if (*buf == '.') size--;
			continue;
		}
		else if (tmp[n]) continue;

		if ((cp = msg_getfield(buf, &len, flags))
		&& len == strsize(POP_XUIDL)
		&& !Xstrncasecmp(buf, POP_XUIDL, len))
			snprintf2(&(tmp[n]), (int)sizeof(tmp) - n, "%s", buf);
	}
	if (last <= 2) size += 2;

	if (!(tmp[n])) {
		len = sizeof(md5);
		if (Xrewind(fp) < 0
		|| md5_fencode(md5, &len, fp, (md5_fread_t)Xfread) < 0
		|| base64_encode(&(tmp[n]), (int)sizeof(tmp) - n,
		md5, len) < 0) {
			ERRORx(("%s: Cannot generate unique-id", path));
			Xfclose(fp);
			return(NULL);
		}
	}
	Xfclose(fp);

	len = strlen(tmp);
	for (cp = tmp; cp < &(tmp[len]); cp++) {
		if (!isspace2(*cp)) continue;
		for (i = 1; &(cp[i]) < &(tmp[len]); i++)
			if (!isspace2(cp[i])) break;
		memmove(cp, &(cp[i]), &(tmp[len]) - &(cp[i]) + 1);
		len -= i;
	}

	if (lenp) *lenp = size;

	return(Xstrdup(tmp));
}

int pop_fetch(VOID_A)
{
	pop3_t *list;
	char *uidl;
	ALLOC_T size;
	int i, j, n, seq, *msgs, argc;

	if (pop_status != POP_STAT_TRANS) {
		ERROR0(("Not logined"));
		return(-1);
	}
	if (pop_msglist) return(0);

	if (mh_inc() < 0) return(-1);
	if (pop_getfolders() < 0) return(-1);

	if (!(list = pop_initlist())) return(-1);
	argc = 0;
	for (i = 0; pop_folders[i]; i++) {
		seq = mh_getseq(pop_folders[i]);
		if (seq < 0) seq = 0;
		if ((n = dir_getlist(pop_folders[i], &msgs)) < 0) continue;

		for (j = 0; j < n; j++) {
			if (msgs[j] <= seq) continue;
			uidl = pop_getuidl(pop_folders[i], msgs[j], &size);
			if (!uidl) continue;
			list = pop_addlist(list, argc++,
				pop_folders[i], msgs[j], size, uidl);
			if (!list) {
				Xfree(msgs);
				return(-1);
			}
		}
		Xfree(msgs);
	}

	pop_msglist = list;
	pop_maxmsg = argc;

	return(0);
}

int pop_gettotal(sizep)
ALLOC_T *sizep;
{
	ALLOC_T size;
	int i, n;

	if (pop_fetch() < 0) return(-1);
	n = 0;
	size = (ALLOC_T)0;
	for (i = 0; i < pop_maxmsg; i++) {
		if (pop_msglist[i].flags & POP_DELETED) continue;
		n++;
		size += pop_msglist[i].size;
	}

	if (sizep) *sizep = size;

	return(n);
}

int pop_getmsgno(s)
char *s;
{
	int n;

	if (!s || !isdigit2(*s) || (n = atoi(s)) <= 0) {
		ERROR0(("%s: Invalid message number", s));
		return(-1);
	}

	if (pop_fetch() < 0) return(-1);
	if (n > pop_maxmsg) {
		ERROR0(("%d: Too large message number (>%d)",
			n, pop_maxmsg));
		return(-1);
	}
	if (pop_msglist[n - 1].flags & POP_DELETED) {
		ERROR0(("%d: Message is already marked to be deleted", n));
		return(-1);
	}

	return(n - 1);
}

XFILE *pop_openmsg(n)
int n;
{
	char path[MAXPATHLEN];

	n = mh_genpath(path, sizeof(path),
		pop_msglist[n].folder, pop_msglist[n].file);
	if (n < 0) return(NULL);

	return(Xfopen(path, "r", 0, 0));
}

int pop_update(VOID_A)
{
	char *last, **argv, buf[POP_MAXBUF];
	int i, n, max, argc;

	if (!pop_msglist || pop_status != POP_STAT_UPDATE) return(0);

	last = NULL;
	max = -1;
	if (!(argv = list_init())) return(-1);
	argc = 0;
	for (i = 0; i < pop_maxmsg; i++) {
		if (!(pop_msglist[i].flags & POP_DELETED)) continue;
		if (last != pop_msglist[i].folder) {
			VOID_C mh_setseq(last, max);
			VOID_C mh_rmm(last, argv);
			last = pop_msglist[i].folder;
			max = -1;
			list_free(argv);
			if (!(argv = list_init())) return(-1);
			argc = 0;
		}

		if (max < pop_msglist[i].file) max = pop_msglist[i].file;
		n = snprintf2(buf, sizeof(buf), "%d", pop_msglist[i].file);
		if (!(argv = list_add(argv, argc++, buf, n))) return(-1);
	}
	VOID_C mh_setseq(last, max);
	VOID_C mh_rmm(last, argv);
	list_free(argv);

	return(0);
}
