/*
 *	pop3send.c
 *
 *	POP3 packet to be sent
 */

#include "mhpopd.h"
#include "pop3.h"


int pop_senderror(fp)
XFILE *fp;
{
	char buf[POP_MAXBUF];
	int n;

	n = snprintf2(buf, sizeof(buf), "%s %s\r\n", pop_errstr, log_buf);

	return(Xfwrite((u_char *)buf, n, fp));
}

#ifdef	USESTDARGH
/*VARARGS2*/
int pop_sendok(XFILE *fp, CONST char *fmt, ...)
#else
/*VARARGS2*/
int pop_sendok(fp, fmt, va_alist)
XFILE *fp;
CONST char *fmt;
va_dcl
#endif
{
	va_list args;
	char buf[POP_MAXBUF];
	int n;

	VA_START(args, fmt);
	n = snprintf2(buf, sizeof(buf), "%s ", pop_okstr);
	n += vsnprintf2(&(buf[n]), (int)sizeof(buf) - n, fmt, args);
	n += snprintf2(&(buf[n]), (int)sizeof(buf) - n, "\r\n");
	va_end(args);

	return(Xfwrite((u_char *)buf, n, fp));
}

#ifdef	USESTDARGH
/*VARARGS2*/
int pop_sendwarning(XFILE *fp, CONST char *fmt, ...)
#else
/*VARARGS2*/
int pop_sendwarning(fp, fmt, va_alist)
XFILE *fp;
CONST char *fmt;
va_dcl
#endif
{
	va_list args;
	char *cp, buf[POP_MAXBUF];
	int n;

	VA_START(args, fmt);
	cp = log_strerror();
	n = snprintf2(buf, sizeof(buf), "%s ", pop_errstr);
	n += vsnprintf2(&(buf[n]), (int)sizeof(buf) - n, fmt, args);
	if (cp) n += snprintf2(&(buf[n]), (int)sizeof(buf) - n, " (%s)", cp);
	n += snprintf2(&(buf[n]), (int)sizeof(buf) - n, "\r\n");
	va_end(args);

	return(Xfwrite((u_char *)buf, n, fp));
}

int pop_greeting(fp)
XFILE *fp;
{
	char *cp, buf[POP_MAXBUF];
	int n, len;

	if (!mydomain) {
		pop_senderror(fp);
		return(-1);
	}

	snprintf2(buf, sizeof(buf),
		"<%u.%ld@%s>", getpid(), Xtime(NULL), mydomain);
	if (!(cp = Xstrdup(buf))) {
		pop_senderror(fp);
		return(-1);
	}
	Xfree(pop_timestamp);
	pop_timestamp = cp;

	cp = conf_getversion(&len);
	n = pop_sendok(fp,
		"%s (Ver. %-.*s) ready %s", myname, len, cp, pop_timestamp);
	VOID_C Xfflush(fp);

	return(n);
}
