/*
 *	smtpsend.c
 *
 *	SMTP packet to be sent
 */

#include "mhpopd.h"
#include "smtp.h"


#ifdef	USESTDARGH
/*VARARG2*/
int smtp_send(XFILE *fp, int code, CONST char *fmt, ...)
#else
/*VARARG2*/
int stmp_send(fp, code, fmt, va_alist)
XFILE *fp;
int code;
CONST char *fmt;
va_dcl
#endif
{
	va_list args;
	char buf[SMTP_MAXBUF];
	int n, c;

	VA_START(args, fmt);
	c = (smtp_flags & SMTP_CONTINUED) ? '-' : ' ';
	n = snprintf2(buf, sizeof(buf), "%<03d%c", code, c);
	n += vsnprintf2(&(buf[n]), (int)sizeof(buf) - n, fmt, args);
	n += snprintf2(&(buf[n]), (int)sizeof(buf) - n, "\r\n");
	va_end(args);

	return(Xfwrite((u_char *)buf, n, fp));
}

int smtp_senderror(fp)
XFILE *fp;
{
	return(smtp_send(fp, 421, "Service not available%s%s%s",
		(*log_buf) ? " (" : nullstr,
		(*log_buf) ? log_buf : nullstr,
		(*log_buf) ? ")" : nullstr));
}

int smtp_greeting(fp)
XFILE *fp;
{
	char *cp, date[SMTP_MAXARG + 1];
	int n, len;

	if (!mydomain) {
		smtp_senderror(fp);
		return(-1);
	}
	VOID_C time_getdatestr(date, sizeof(date));

	cp = conf_getversion(&len);
	n = smtp_send(fp, 220,
		"%s ESMTP %s (Ver. %-.*s) %s",
		mydomain, myname, len, cp, date);
	VOID_C Xfflush(fp);

	return(n);
}
