/*
 *	fileio.h
 *
 *	file I/O macros
 */

#include <fcntl.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/stat.h>

#ifdef	USEDIRECT
#include <sys/dir.h>
#define	dirent	direct
# ifdef	DIRSIZ
# undef	DIRSIZ
# endif
#else
#include <dirent.h>
#endif

#ifdef	USEUTIME
#include <utime.h>
#endif

#ifdef	USETIMEH
#include <time.h>
#endif

#ifndef	_PATH_DEVNULL
#define	_PATH_DEVNULL	"/dev/null"
#endif
#ifndef	_PATH_TTY
#define	_PATH_TTY	"/dev/tty"
#endif
#ifndef	O_ACCMODE
#define	O_ACCMODE	(O_RDONLY | O_WRONLY | O_RDWR)
#endif
#ifndef	LOCK_SH
#define	LOCK_SH		1
#endif
#ifndef	LOCK_EX
#define	LOCK_EX		2
#endif
#ifndef	LOCK_NB
#define	LOCK_NB		4
#endif
#ifndef	LOCK_UN
#define	LOCK_UN		8
#endif
#ifndef	L_SET
# ifdef	SEEK_SET
# define	L_SET	SEEK_SET
# else
# define	L_SET	0
# endif
#endif
#ifndef	L_INCR
# ifdef	SEEK_CUR
# define	L_INCR	SEEK_CUR
# else
# define	L_INCR	1
# endif
#endif
#ifndef	L_XTND
# ifdef	SEEK_END
# define	L_XTND	SEEK_END
# else
# define	L_XTND	2
# endif
#endif
#ifndef	SHUT_RD
#define	SHUT_RD		0
#endif
#ifndef	SHUT_WR
#define	SHUT_WR		1
#endif
#ifndef	SHUT_RDWR
#define	SHUT_RDWR	2
#endif
