/*
 *	argv.c
 *
 *	argument variable parser
 */

#include "mhpopd.h"
#include "kctype.h"

#define	ARGV_NORMAL		0
#define	ARGV_OPQUOTE		1
#define	ARGV_CLQUOTE		2
#define	ARGV_SQUOTE		3
#define	ARGV_DQUOTE		4
#define	ARGV_WORD		5
#define	ARGV_META		6
#define	ARGV_FGJOB		';'
#define	ARGV_BGJOB		'&'

static int NEAR argv_ismeta __P_((CONST char *, ALLOC_T, int));
static int NEAR argv_parse __P_((CONST char *, ALLOC_T, int *));
static char *NEAR argv_addch __P_((char *, ALLOC_T *, int));
static char **NEAR argv_addarg __P_((char **, int *, char *, ALLOC_T *));
#ifdef	TEST
int main __P_((int, char *CONST []));
#endif


static int NEAR argv_ismeta(s, len, quote)
CONST char *s;
ALLOC_T len;
int quote;
{
	if (s[0] != '\\' || quote == '\'') return(0);

	if (len <= (ALLOC_T)1) return(0);
	if (quote == '"' && (s[1] != quote || len <= 2)) return(0);

	return(1);
}

static int NEAR argv_parse(s, len, quotep)
CONST char *s;
ALLOC_T len;
int *quotep;
{
	if (*s == *quotep) {
		*quotep = '\0';
		return(ARGV_CLQUOTE);
	}
	else if (iskanji1(s, 0)) return(ARGV_WORD);
#ifdef	CODEEUC
	else if (isekana(s, 0)) return(ARGV_WORD);
#endif
	else if (*quotep == '\'') return(ARGV_SQUOTE);
	else if (argv_ismeta(s, len, *quotep)) return(ARGV_META);
	else if (*quotep) return(ARGV_DQUOTE);
	else if (*s == '\'' || *s == '"') {
		*quotep = *s;
		return(ARGV_OPQUOTE);
	}

	return(ARGV_NORMAL);
}

static char *NEAR argv_addch(s, sizep, c)
char *s;
ALLOC_T *sizep;
int c;
{
	char *new;

	new = Xrealloc(s, (*sizep + 1) * sizeof(char));
	if (!new) {
		Xfree(s);
		return(NULL);
	}

	s = new;
	new[(*sizep)++] = c;

	return(s);
}

static char **NEAR argv_addarg(argv, argcp, arg, sizep)
char **argv;
int *argcp;
char *arg;
ALLOC_T *sizep;
{
	if (!arg) return(argv);

	argv = list_add(argv, (*argcp)++, arg, *sizep);
	if (!argv) return(NULL);
	*sizep = (ALLOC_T)0;

	return(argv);
}

char **argv_getargv(s, len)
CONST char *s;
ALLOC_T len;
{
	char *cp, *new, **argv;
	ALLOC_T size;
	int argc, quote, bg;

	if (len == (ALLOC_T)-1) len = strlen(s);

	if (!(argv = list_init())) return(NULL);

	argc = 0;
	quote = bg = '\0';
	cp = NULL;
	size = (ALLOC_T)0;
	while (len) {
		new = nullline;
		if (bg) {
			for (; len; s++, len--) if (!isspace2(*s)) break;
			if (!len) break;
			ERROR0(("%s: Cannot follow `%c'", s, bg));
			Xfree(cp);
			list_free(argv);
			return(NULL);
		}
		switch (argv_parse(s, len, &quote)) {
			case ARGV_OPQUOTE:
				if (!cp) cp = new = Xmalloc(1);
				break;
			case ARGV_CLQUOTE:
				break;
			case ARGV_SQUOTE:
			case ARGV_DQUOTE:
				cp = new = argv_addch(cp, &size, *s);
				break;
			case ARGV_WORD:
				if (!(cp = argv_addch(cp, &size, *(s++)))) {
					list_free(argv);
					return(NULL);
				}
				len--;
				cp = new = argv_addch(cp, &size, *s);
				break;
			case ARGV_META:
				cp = new = argv_addch(cp, &size, *(++s));
				len--;
				break;
			default:
				if (*s == ARGV_FGJOB) bg = ARGV_FGJOB;
				else if (*s == ARGV_BGJOB) bg = ARGV_BGJOB;
				else if (!isspace2(*s)) {
					cp = new = argv_addch(cp, &size, *s);
					break;
				}
				argv = argv_addarg(argv, &argc, cp, &size);
				Xfree(cp);
				cp = NULL;
				if (!argv) return(NULL);
				if (*s == ARGV_BGJOB) {
					argv = argv_addarg(argv,
						&argc, nullline, &size);
					if (!argv) return(NULL);
				}
				break;
		}

		if (!new) {
			list_free(argv);
			return(NULL);
		}
		s++;
		len--;
	}

	if (cp) argv = list_add(argv, argc++, cp, size);
	Xfree(cp);

	return(argv);
}

#ifdef	TEST
/*ARGSUSED*/
int main(argc, argv)
int argc;
char *CONST argv[];
{
	XFILE *fp;
	ALLOC_T len;
	char *cp, *buf, **args;
	int i;

	nosyslog++;
	interactive++;
	if (sig_init() < 0) return(1);

	if (!(fp = Xfdopen(STDIN_FILENO, "r", -1, XF_NOCLOSE, pathstdin)))
		return(1);

	for (; (buf = Xfgets(fp, &len, XF_TRUNC)); Xfree(buf)) {
		if (!(args = argv_getargv(buf, len))) continue;

		for (i = 0; args[i]; i++) {
			if ((cp = args[i]) == nullline) cp = "&";
			fprintf(stdout, "argv[%d] = <%s>\n", i, cp);
		}
		list_free(args);
	}

	Xfclose(fp);

	return(0);
}
#endif
