/*
 *	message.c
 *
 *	Internet message in RFC2822
 */

#include "mhpopd.h"
#include "kctype.h"

static char *NEAR msg_addline __P_((char *, ALLOC_T *,
	CONST char *, ALLOC_T, int));


static char *NEAR msg_addline(buf, sizep, s, len, flags)
char *buf;
ALLOC_T *sizep;
CONST char *s;
ALLOC_T len;
int flags;
{
	char *new;
	int n;

	n = 0;
	if (flags & XF_KEEPCR) n++;
	if (flags & XF_KEEPLF) n++;
	new = Xrealloc(buf, *sizep + n + len + 1);
	if (!new) return(NULL);

	if (flags & XF_KEEPCR) new[(*sizep)++] = '\r';
	if (flags & XF_KEEPLF) new[(*sizep)++] = '\n';
	if (len) {
		memcpy(&(new[*sizep]), s, len + 1);
		*sizep += len;
	}

	return(new);
}


char *msg_getline(fp, lenp, flags)
XFILE *fp;
ALLOC_T *lenp;
int flags;
{
	char *cp, *buf, *new;
	ALLOC_T len, size;
	int c;

	buf = NULL;
	size = (ALLOC_T)0;
	if (!(flags & XF_INHEAD)) buf = Xfgets(fp, &size, XF_TRUNC);
	else for (;;) {
		if (!(cp = Xfgets(fp, &len, XF_TRUNC))) break;
		if ((flags & XF_ENDOFHEAD) && *cp == '-') len = (ALLOC_T)0;
		if (!len) {
			Xfree(cp);
			Xfree(buf);
			buf = nullline;
			size = (ALLOC_T)0;
			break;
		}

		if (!buf) {
			buf = cp;
			size = len;
		}
		else {
			new = msg_addline(buf, &size, cp, len, flags);
			if (!new) break;
			buf = new;
			Xfree(cp);
		}

		c = Xfgetc(fp);
		VOID_C Xungetc(c, fp);
		if (c == EOF || !isblank2(c)) break;
	}

	if (buf && buf != nullline) {
		if (flags & XF_KEEPCRLF) {
			new = msg_addline(buf, &size, NULL, (ALLOC_T)0, flags);
			if (new) buf = new;
		}
		buf[size] = '\0';
	}
	if (lenp) *lenp = size;

	return(buf);
}

int msg_putline(s, fp)
CONST char *s;
XFILE *fp;
{
	if (!s) s = nullstr;
	if (*s == '.' && Xfputc('.', fp) < 0) return(-1);
	if (Xfputs(s, fp) < 0 || Xfputs("\r\n", fp) < 0) return(-1);

	return(0);
}

char *msg_getfield(buf, lenp, flags)
char *buf;
ALLOC_T *lenp;
int flags;
{
	char *cp;
	ALLOC_T len;

	if (!(cp = strchr(buf, ':'))) {
		if (!(flags & XF_IGNOREERR))
			ERROR0(("%s: Unexpected end of field", buf));
		return(NULL);
	}

	len = cp++ - buf;
	if (!len) {
		if (!(flags & XF_IGNOREERR))
			ERROR0(("%s: Null field name", buf));
		return(NULL);
	}

	while (isblank2(*cp)) cp++;
	if (lenp) *lenp = len;

	return(cp);
}

#ifdef	USESTDARGH
/*VARARGS2*/
int msg_send(XFILE *fp, CONST char *fmt, ...)
#else
/*VARARGS2*/
int msg_send(fp, fmt, va_alist)
XFILE *fp;
CONST char *fmt;
va_dcl
#endif
{
	va_list args;
	char buf[MAXLINEBUF + 1];
	int n;

	VA_START(args, fmt);
	n = vsnprintf2(buf, sizeof(buf), fmt, args);
	n += snprintf2(&(buf[n]), (int)sizeof(buf) - n, "\r\n");
	va_end(args);

	return(Xfwrite((u_char *)buf, n, fp));
}

int msg_sendeom(fp)
XFILE *fp;
{
	return(Xfputs(".\r\n", fp));
}

char **msg_getargv(s, size)
CONST char *s;
ALLOC_T size;
{
	CONST char *cp;
	char **argv;
	ALLOC_T ptr;
	int argc;

	if (!(argv = list_init())) return(NULL);
	argc = 0;
	if (!s) return(argv);

	if (size == (ALLOC_T)-1) size = strlen(s);
	for (ptr = (ALLOC_T)0; ptr < size; ptr++) if (!isblank2(s[ptr])) break;

	while (ptr < size) {
		cp = &(s[ptr]);
		while (++ptr < size) if (isblank2(s[ptr])) break;

		if (!(argv = list_add(argv, argc++, cp, &(s[ptr]) - cp)))
			return(NULL);
		while (++ptr < size) if (!isblank2(s[ptr])) break;
	}

	return(argv);
}

VOID msg_hex(buf, size, s, len)
char *buf;
ALLOC_T size;
CONST u_char *s;
ALLOC_T len;
{
	char *cp;
	ALLOC_T ptr;
	int n;

	cp = buf;
	*buf = '\0';
	for (ptr = (ALLOC_T)0; ptr < len; ptr++) {
		if (cp - buf > size) break;
		n = snprintf2(cp, size - (cp - buf), "%<02x", (int)(s[ptr]));
		cp += n;
	}
}
