/*
 *	passwd.c
 *
 *	password encoding/decoding
 */

#include "mhpopd.h"

#define	PASSWD_MAXLEN		40


int passwd_encode(buf, size, s, salt)
char *buf;
ALLOC_T size;
CONST char *s;
int salt;
{
	u_char tmp1[1 + PASSWD_MAXLEN], tmp2[1 + PASSWD_MAXLEN];
	ALLOC_T ptr, len;

	if (!s) s = "";

	ptr = (ALLOC_T)0;
	tmp1[ptr++] = (salt & 0xff);
	while (*s) {
		if (ptr >= sizeof(tmp1)) break;
		tmp1[ptr++] = (u_char)(*(s++));
	}
	if (ptr < sizeof(tmp1)) {
		tmp1[ptr++] = '\0';
		while (ptr < sizeof(tmp1)) {
			len = sizeof(tmp1) - ptr;
			md5_encode(&(tmp1[ptr]), &len, tmp1, ptr);
			ptr += len;
		}
	}

	tmp2[0] = tmp1[0];
	for (ptr = (ALLOC_T)1; ptr < sizeof(tmp2); ptr++)
		tmp2[ptr] = tmp1[ptr] - tmp1[ptr - 1];
	if (base64_encode(buf, size, tmp2, sizeof(tmp2)) < 0) return(-1);

	return(0);
}

int passwd_decode(buf, size, s)
char *buf;
ALLOC_T size;
CONST char *s;
{
	u_char tmp1[1 + PASSWD_MAXLEN], tmp2[1 + PASSWD_MAXLEN];
	ALLOC_T ptr, len;

	if (!s) s = "";

	len = sizeof(tmp1);
	if (base64_decode(tmp1, &len, s, (ALLOC_T)-1) < 0) return(-1);

	tmp2[0] = tmp1[0];
	for (ptr = (ALLOC_T)1; ptr < sizeof(tmp2); ptr++) {
		tmp2[ptr] = tmp1[ptr] + tmp2[ptr - 1];
		if (!(tmp2[ptr])) break;
	}

	if (ptr-- > size) {
		errno = ERANGE;
		return(-1);
	}
	memcpy(buf, &(tmp2[1]), ptr);
	buf[ptr] = '\0';

	return(0);
}
