/*
 *	time.c
 *
 *	UNIX time handling
 */

#include "mhpopd.h"
#include <sys/types.h>
#include <sys/time.h>

#ifdef	USETIMEH
#include <time.h>
#endif

static CONST char *time_weekstr[] = {
	"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat",
};
#define	WEEKSTRSIZ		arraysize(time_weekstr)

static CONST char *time_monthstr[] = {
	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec",
};
#define	MONTHSTRSIZ		arraysize(time_weekstr)

#ifdef	NOTMGMTOFF
static long NEAR Xtimegm __P_((struct tm *));
#endif


#ifdef	NOTMGMTOFF
static long NEAR Xtimegm(tm)
struct tm *tm;
{
	long t;
	int i, y;

	y = (tm -> tm_year < 1900) ? tm -> tm_year + 1900 : tm -> tm_year;
	t = ((long)y - 1970) * 365;
	t += ((y - 1 - 1968) / 4)
		- ((y - 1 - 1900) / 100)
		+ ((y - 1 - 1600) / 400);
	for (i = 1; i < tm -> tm_mon + 1; i++) switch (i) {
		case 2:
			if (!(y % 4) && ((y % 100) || !(y % 400))) t++;
			t += 28;
			break;
		case 4:
		case 6:
		case 9:
		case 11:
			t += 30;
			break;
		default:
			t += 31;
			break;
	}
	t += tm -> tm_mday - 1;
	t *= 60L * 60L * 24L;
	t += ((long)(tm -> tm_hour) * 60L + tm -> tm_min) * 60L + tm -> tm_sec;

	return(t);
}
#endif	/* NOTMGMTOFF */

time_t Xtime(tp)
time_t *tp;
{
	struct timeval t_val;
	struct timezone t_zone;
	time_t t;

	VOID_C Xgettimeofday(&t_val, &t_zone);
	t = (time_t)(t_val.tv_sec);
	if (tp) *tp = t;

	return(t);
}

int time_getdatestr(buf, size)
char *buf;
ALLOC_T size;
{
	struct tm *tm;
	time_t t;
	long tz;
	int n, c;

	t = Xtime(NULL);
	tm = localtime(&t);
#ifndef	NOTMGMTOFF
	tz = tm -> tm_gmtoff;
#else
	tz = Xtimegm(tm) - (long)t;
#endif
	tz /= 60L;

	if (tz >= 0) c = '+';
	else {
		c = '-';
		tz = -tz;
	}

	n = snprintf2(buf, size,
		"%s, %u %s %u %<02u:%<02u:%<02u %c%<02lu%<02lu",
		time_weekstr[tm -> tm_wday % WEEKSTRSIZ],
		tm -> tm_mday,
		time_monthstr[tm -> tm_mon % MONTHSTRSIZ],
		tm -> tm_year + 1900,
		tm -> tm_hour, tm -> tm_min, tm -> tm_sec,
		c, tz / 60, tz % 60);

	return(n);
}
