/*
 *	types.h
 *
 *	type definitions
 */

#include <sys/types.h>

#ifdef	NOUID_T
typedef u_short			uid_t;
typedef u_short			gid_t;
#endif

#ifdef	USEPID_T
typedef pid_t			p_id_t;
#else
typedef long			p_id_t;
#endif

#ifdef	SIGARGINT
typedef int			sigarg_t;
#else
# ifdef	NOVOID
# define			sigarg_t
# else
typedef void			sigarg_t;
# endif
#endif

#ifdef	SIGFNCINT
typedef int			sigfnc_t;
#else
# ifdef	NOVOID
# define			sigfnc_t
# else
typedef void			sigfnc_t;
# endif
#endif

typedef sigarg_t (*sigcst_t)__P_((sigfnc_t));

#ifdef	USESIGPMASK
#define	sigmask_t		sigset_t
#else
typedef int			sigmask_t;
#endif

#ifdef	USEWAITPID
typedef int			wait_pid_t;
#else
#define	wait_pid_t		union wait
#endif

#ifdef	USESOCKLEN
#define	sock_len_t		socklen_t
#else
typedef int			sock_len_t;
#endif

#ifndef	XF_BUFSIZ
#define	XF_BUFSIZ		((ALLOC_T)BUFSIZ)
#endif
typedef struct _XFILE {
	int fd;
	int timeout;
	u_char buf[XF_BUFSIZ];
	off_t inptr;
	off_t outptr;
	off_t inmax;
	CONST char *debugmes;
	int flags;
	char path[1];
} XFILE;
#define	XF_DEBUGLVL		000017
#define	XF_EOF			000020
#define	XF_ERROR		000040
#define	XF_LOCKED		000100
#define	XF_NOCLOSE		000200
#define	XF_CONNECTED		000400
#define	XF_READ			001000
#define	XF_WRITTEN		002000
#define	XF_RDONLY		004000
#define	XF_WRONLY		010000

/* Flags for functions */
#define	XF_IGNOREERR		000001			/* Xfopen() */
#define	XF_IGNORENOENT		000002			/* Xfopen() */
#define	XF_TRUNC		000004			/* Xfgets() */
#define	XF_INHEAD		000010			/* msg_getline() */
#define	XF_ENDOFHEAD		000020			/* msg_getline() */
#define	XF_KEEPCR		000040			/* msg_getline() */
#define	XF_KEEPLF		000100			/* msg_getline() */
#define	XF_KEEPCRLF		(XF_KEEPCR | XF_KEEPLF)	/* msg_getline() */
#define	XF_NOCOMMENT		000200			/* conf_getline() */
#define	XF_KEEPSPACE		000400			/* conf_getline() */
#define	XF_FORUSER		001000			/* conf_load() */
#define	XF_RELOAD		002000			/* conf_load() */

/* Flags for socket option */
#define	SCK_TOSTYPE		0007
#define	SCK_LOWDELAY		0001
#define	SCK_THROUGHPUT		0002
#define	SCK_RELIABILITY		0003
#define	SCK_MINCOST		0004
#define	SCK_NORMAL		0005
#define	SCK_KEEPALIVE		0010
#define	SCK_REUSEADDR		0020
