/*
 *	pop3send.c
 *
 *	POP3 packet to be sent
 */

#include "mhpopd.h"
#include "pop3.h"


int pop_senderror(fp)
XFILE *fp;
{
	char buf[POP_MAXBUF];
	int n;

	n = Xsnprintf(buf, sizeof(buf), "%s %s\n", pop_errstr, log_buf);

	return((Xfwrite(buf, n, fp) < n) ? -1 : 0);
}

#ifdef	USESTDARGH
/*VARARGS2*/
int pop_sendok(XFILE *fp, CONST char *fmt, ...)
#else
/*VARARGS2*/
int pop_sendok(fp, fmt, va_alist)
XFILE *fp;
CONST char *fmt;
va_dcl
#endif
{
	va_list args;
	char buf[POP_MAXBUF];
	int n;

	VA_START(args, fmt);
	n = Xsnprintf(buf, sizeof(buf), "%s ", pop_okstr);
	n += Xvsnprintf(&(buf[n]), (int)sizeof(buf) - n, fmt, args);
	n += Xsnprintf(&(buf[n]), (int)sizeof(buf) - n, "\n");
	va_end(args);

	return((Xfwrite(buf, n, fp) < n) ? -1 : 0);
}

#ifdef	USESTDARGH
/*VARARGS2*/
int pop_sendwarning(XFILE *fp, CONST char *fmt, ...)
#else
/*VARARGS2*/
int pop_sendwarning(fp, fmt, va_alist)
XFILE *fp;
CONST char *fmt;
va_dcl
#endif
{
	va_list args;
	char *cp, buf[POP_MAXBUF];
	int n;

	VA_START(args, fmt);
	cp = log_strerror();
	n = Xsnprintf(buf, sizeof(buf), "%s ", pop_errstr);
	n += Xvsnprintf(&(buf[n]), (int)sizeof(buf) - n, fmt, args);
	if (cp) n += Xsnprintf(&(buf[n]), (int)sizeof(buf) - n, " (%s)", cp);
	n += Xsnprintf(&(buf[n]), (int)sizeof(buf) - n, "\n");
	va_end(args);

	return((Xfwrite(buf, n, fp) < n) ? -1 : 0);
}

int pop_greeting(fp)
XFILE *fp;
{
	char *cp, buf[POP_MAXBUF];
	int n, len;

	if (!mydomain) {
		pop_senderror(fp);
		return(-1);
	}

	Xsnprintf(buf, sizeof(buf),
		"<%u.%ld@%s>", getpid(), Xtime(NULL), mydomain);
	if (pop_incapable("APOP")) *buf = '\0';
	if (!(cp = Xstrdup(buf))) {
		pop_senderror(fp);
		return(-1);
	}
	Xfree(pop_timestamp);
	pop_timestamp = cp;

	cp = conf_getversion(&len);
	n = pop_sendok(fp,
		"%s (Ver. %-.*s) ready %s", myname, len, cp, pop_timestamp);
	VOID_C Xfflush(fp);

	return(n);
}
