/*
 *	types.h
 *
 *	type definitions
 */

#include "depend.h"
#include "typesize.h"
#include "stream.h"

#ifdef	NOUID_T
typedef u_short			uid_t;
typedef u_short			gid_t;
#endif

#ifdef	SIGARGINT
typedef int			sigarg_t;
#else
# ifdef	NOVOID
# define			sigarg_t
# else
typedef void			sigarg_t;
# endif
#endif

#ifdef	SIGFNCINT
typedef int			sigfnc_t;
#else
# ifdef	NOVOID
# define			sigfnc_t
# else
typedef void			sigfnc_t;
# endif
#endif

typedef sigarg_t (*sigcst_t)__P_((sigfnc_t));

#ifdef	USESIGPMASK
#define	sigmask_t		sigset_t
#else
typedef int			sigmask_t;
#endif

#ifdef	USEWAITPID
typedef int			wait_pid_t;
#else
#define	wait_pid_t		union wait
#endif

#ifdef	USESOCKLEN
#define	sock_len_t		socklen_t
#else
typedef int			sock_len_t;
#endif

/* Flags for functions */
#define	XF_IGNOREERR		000001			/* Xfopen() */
#define	XF_IGNORENOENT		000002			/* Xfopen() */
#define	XF_TRUNC		000004			/* Xfgets() */
#define	XF_INHEAD		000010			/* msg_getline() */
#define	XF_ENDOFHEAD		000020			/* msg_getline() */
#define	XF_KEEPCR		000040			/* msg_getline() */
#define	XF_KEEPLF		000100			/* msg_getline() */
#define	XF_KEEPCRLF		(XF_KEEPCR | XF_KEEPLF)	/* msg_getline() */
#define	XF_NOCOMMENT		000200			/* conf_getline() */
#define	XF_KEEPSPACE		000400			/* conf_getline() */
#define	XF_FORUSER		001000			/* conf_load() */
#define	XF_RELOAD		002000			/* conf_load() */

/* Flags for socket option */
#define	SCK_TOSTYPE		0007
#define	SCK_LOWDELAY		0001
#define	SCK_THROUGHPUT		0002
#define	SCK_RELIABILITY		0003
#define	SCK_MINCOST		0004
#define	SCK_NORMAL		0005
#define	SCK_KEEPALIVE		0010
#define	SCK_REUSEADDR		0020
