/*
 *	libc.c
 *
 *	wrappers for C library functions
 */

#include "mhpopd.h"
#include "fileio.h"
#include "kctype.h"

#ifdef	USESELECTH
#include <sys/select.h>
#endif


VOID Xfree(vp)
VOID_P vp;
{
	int duperrno;

	duperrno = errno;
	if (vp) free(vp);
	errno = duperrno;
}

char *Xmalloc(size)
ALLOC_T size;
{
	VOID_P new;

	if (!(new = (char *)malloc(size)))
		ERRORx(("Memory error for malloc()"));

	return(new);
}

char *Xrealloc(vp, size)
VOID_P vp;
ALLOC_T size;
{
	VOID_P new;

	new = (vp) ? (char *)realloc(vp, size) : (char *)malloc(size);
	if (!new) ERRORx(("Memory error for realloc()"));

	return(new);
}

char *Xstrdup(s)
CONST char *s;
{
	char *cp;
	ALLOC_T len;

	if (!s) {
		ERROR0(("Pointer is null for strdup()"));
		return(NULL);
	}

	len = strlen(s) + 1;
	if (!(cp = (char *)malloc(len))) {
		ERRORx(("%s: Memory error for strdup()", s));
		return(NULL);
	}

	memcpy(cp, s, len);

	return(cp);
}

char *Xstrndup(s, len)
CONST char *s;
ALLOC_T len;
{
	char *cp;

	if (!s) {
		ERROR0(("Pointer is null for strndup()"));
		return(NULL);
	}

	if (!(cp = (char *)malloc(len + 1))) {
		ERRORx(("%-.*s: Memory error for strndup()", len, s));
		return(NULL);
	}

	memcpy(cp, s, len);
	cp[len] = '\0';

	return(cp);
}

int Xusleep(usec)
u_long usec;
{
	struct timeval tv;

	tv.tv_sec = 0L;
	tv.tv_usec = usec;
	while (tv.tv_usec >= 1000000L) {
		tv.tv_sec++;
		tv.tv_usec -= 1000000L;
	}

	for (;;) {
		if (select(0, NULL, NULL, NULL, &tv) >= 0) {
			errno = 0;
			return(0);
		}
		else if (errno != EINTR || sig_check(0) < 0) break;
	}

	return(-1);
}

int Xdaemon(nochdir, noclose)
int nochdir, noclose;
{
	p_id_t pid;
	int fd, flags;

	if ((pid = Xfork()) < 0) return(-1);
	else if (pid) _exit(0);

	if ((pid = Xsetsid()) < 0) return(-1);

	if ((pid = Xfork()) < 0) return(-1);
	else if (pid) _exit(0);

	if (!nochdir) VOID_C Xchdir("/");
#ifdef	SELECTRWONLY
	flags = O_RDONLY;
#else
	flags = O_RDWR;
#endif
	if (!noclose
	&& (fd = Xopen(_PATH_DEVNULL, flags, 0, XF_IGNOREERR)) >= 0) {
		VOID_C Xdup2(fd, STDIN_FILENO, pathstdin);
		VOID_C Xdup2(fd, STDOUT_FILENO, pathstdout);
		VOID_C Xdup2(fd, STDERR_FILENO, pathstderr);
		if (fd != STDIN_FILENO
		&& fd != STDOUT_FILENO
		&& fd != STDERR_FILENO)
			VOID_C Xclose(fd, _PATH_DEVNULL);
	}

	return(0);
}
