/*
 *	mhpasswd.c
 *
 *	password file generator
 */

#include "mhpopd.h"
#include <pwd.h>

#define	PASSWD_MINLEN		6
#define	PASSWD_BUFSIZ		127

#ifndef	VER
#define	VER			"0.00"
#endif

int main __P_((int, char *CONST []));


int main(argc, argv)
int argc;
char *CONST argv[];
{
	struct passwd *pwd;
	FILE *fp;
	char *cp, path[MAXPATHLEN], buf[PASSWD_BUFSIZ + 1];
	ALLOC_T len;
	int n;

	if ((cp = strrchr(argv[0], '/'))) cp++;
	else cp = argv[0];

	if (argc < 2) {
		if (!(pwd = getpwuid(geteuid()))
		|| !(pwd -> pw_dir) || *(pwd -> pw_dir) != '/') {
			fprintf(stderr, "Cannot get home directory\n");
			return(1);
		}
		len = strlen(pwd -> pw_dir);
		if (len > strsize(path) - sizeof(DEFPASSWDFILE)) {
			fprintf(stderr, "%s: Too long home directory\n",
				pwd -> pw_dir);
			return(1);
		}
		memcpy(path, pwd -> pw_dir, len);
		path[len++] = '/';
		memcpy(&(path[len]), DEFPASSWDFILE, sizeof(DEFPASSWDFILE));
	}
	else if (argc > 2 || !strcmp(argv[1], "-h")) {
		fprintf(stderr, "Usage: %s [-hv] [password_file]\n", cp);
		return((argc > 2) ? 1 : 0);
	}
	else if (!strcmp(argv[1], "-v")) {
		fprintf(stderr, "%s Ver. %s\n", cp, VER);
		return(0);
	}
	else if ((len = strlen(argv[1])) > strsize(path)) {
		fprintf(stderr, "%s: Too long filename\n", argv[1]);
		return(1);
	}
	else memcpy(path, argv[1], len + 1);

	fprintf(stderr, "Generating password in \"%s\"\n", path);
	cp = getpass("New password:");
	if (!cp || !(len = strlen(cp))) {
		fprintf(stderr, "Password unchanged\n");
		return(1);
	}
	else if (len < PASSWD_MINLEN) {
		fprintf(stderr,
			"Password string needs at least %d characters\n",
			PASSWD_MINLEN);
		return(1);
	}
	if (len >= sizeof(buf)) len = strsize(buf);
	memcpy(buf, cp, len);
	buf[len] = '\0';

	cp = getpass("Retype new password:");
	if (!cp || strcmp(buf, cp)) {
		fprintf(stderr, "Password mismatch\n");
		return(1);
	}

	Xsrandom(time(NULL) + getpid());
	if (passwd_encode(buf, sizeof(buf), cp, Xrandom())) {
		fprintf(stderr, "Cannot encode password\n");
		return(1);
	}

	n = umask(077);
	fp = fopen(path, "w");
	VOID_C umask(n);
	if (!fp) {
		fprintf(stderr, "%s: Cannot open\n", path);
		return(1);
	}

	fprintf(fp, "%s\n", buf);
	VOID_C fclose(fp);
	VOID_C chmod(path, 0600);

	fprintf(stderr, "Written password in \"%s\"\n", path);

	return(0);
}
