/*
 *	pop3.c
 *
 *	POP3 (Post Office Protocol V3) in RFC1939
 */

#include "mhpopd.h"
#include "kctype.h"
#include "pop3.h"

typedef int (*md5_fread_t)__P_((char *, ALLOC_T, VOID_P));

typedef struct _popreport_t {
	char **list;
	int ptr;
	int max;
	ALLOC_T size;
} popreport_t;

#define	DATESTR			"Date: "

char pop_okstr[] = POP_OK;
char pop_errstr[] = POP_ERR;
int pop_status = POP_STAT_AUTH;
char *pop_timestamp = NULL;
char *pop_username = NULL;
char **pop_folders = NULL;
pop3_t *pop_msglist = NULL;
int pop_maxmsg = 0;
popreport_t *pop_report = NULL;

static pop3_t *NEAR pop_initlist __P_((VOID_A));
static pop3_t *NEAR pop_addlist __P_((pop3_t *, int,
	CONST char *, int, ALLOC_T, char *));
static VOID NEAR pop_freelist __P_((pop3_t *));
static VOID NEAR pop_freereport __P_((popreport_t *));
static int NEAR pop_getfolders __P_((VOID_A));
static int NEAR pop_genuidl __P_((char *, ALLOC_T,
	VOID_P, md5_fread_t, time_t, CONST char *));
static char *NEAR pop_getuidl __P_((CONST char *, int, ALLOC_T *));
static int NEAR pop_addreport __P_((CONST char *));
static int NEAR pop_genreport __P_((pop3_t *, int));
static int NEAR pop_readreport __P_((char *, ALLOC_T, popreport_t *));


static pop3_t *NEAR pop_initlist(VOID_A)
{
	pop3_t *new;

	if (!(new = (pop3_t *)Xmalloc(sizeof(pop3_t)))) return(NULL);
	new[0].folder = NULL;

	return(new);
}

static pop3_t *NEAR pop_addlist(list, n, folder, file, size, uidl)
pop3_t *list;
int n;
CONST char *folder;
int file;
ALLOC_T size;
char *uidl;
{
	pop3_t *new;

	if (n >= 0) /*EMPTY*/;
	else if (!list) n = 0;
	else for (n = 0; list[n].folder; n++) /*EMPTY*/;

	if (!(new = (pop3_t *)Xrealloc(list, (n + 1 + 1) * sizeof(pop3_t)))) {
		while (n-- > 0) Xfree(list[n].uidl);
		Xfree(list);
		return(NULL);
	}

	new[n].folder = folder;
	new[n].file = file;
	new[n].size = size;
	new[n].uidl = uidl;
	new[n].flags = 0;
	new[++n].folder = NULL;

	return(new);
}

static VOID NEAR pop_freelist(list)
pop3_t *list;
{
	int i;

	if (!list) return;

	for (i = 0; list[i].folder; i++) Xfree(list[i].uidl);
	Xfree(list);
}

static VOID NEAR pop_freereport(rp)
popreport_t *rp;
{
	if (rp) list_free(rp -> list);
	Xfree(rp);
}

VOID pop_free(VOID_A)
{
	pop_freelist(pop_msglist);
	pop_msglist = NULL;
	pop_maxmsg = 0;
	list_free(pop_folders);
	pop_folders = NULL;
	pop_freereport(pop_report);
	pop_report = NULL;
}

static int NEAR pop_getfolders(VOID_A)
{
	char **argv;

	argv = msg_getargv((folders && *folders) ? folders : inboxdir,
		(ALLOC_T)-1);
	if (!argv) return(-1);

	list_free(pop_folders);
	pop_folders = argv;

	return(0);
}

static int NEAR pop_genuidl(buf, size, vp, func, t, path)
char *buf;
ALLOC_T size;
VOID_P vp;
md5_fread_t func;
time_t t;
CONST char *path;
{
	u_char md5[16];
	ALLOC_T len;
	int n;

	if (!vp || !func) return(-1);
	len = sizeof(md5);
	n = Xsnprintf(buf, size, "%lx.", t);
	buf += n;
	size -= n;
	if (md5_fencode(md5, &len, vp, func) < 0
	|| base64_encode(buf, size, md5, len) < 0) {
		ERRORx(("%s: Cannot generate unique-id", path));
		return(-1);
	}

	return(0);
}

static char *NEAR pop_getuidl(folder, n, lenp)
CONST char *folder;
int n;
ALLOC_T *lenp;
{
	XFILE *fp;
	ALLOC_T len, size, last;
	char *cp, *buf, tmp[POP_MAXBUF], path[MAXPATHLEN];
	time_t t;
	int i, flags;

	if (mh_genpath(path, sizeof(path), folder, n) < 0) return(NULL);
	if (stat_gettime(path, &t, 0) < 0) return(NULL);

	if (!(fp = Xfopen(path, "r", 0, 0))) return(NULL);
	*tmp = '\0';
	size = (ALLOC_T)0;
	last = (ALLOC_T)-1;
	flags = (XF_IGNOREERR | XF_INHEAD | XF_KEEPCRLF);
	for (; (buf = msg_getline(fp, &len, flags)); Xfree(buf)) {
		last = len;
		size += len;
		if (buf == nullline) {
			flags &= ~XF_INHEAD;
			size += 2;
			buf = NULL;
			continue;
		}
		else if (!(flags & XF_INHEAD)) {
			if (*buf == '.') size--;
			continue;
		}
		else if (*tmp) continue;

		if ((cp = msg_getfield(buf, &len, flags))
		&& len == strsize(POP_XUIDL)
		&& !Xstrncasecmp(buf, POP_XUIDL, len))
			VOID_C Xsnprintf(tmp, sizeof(tmp), "%lx.%s", t, buf);
	}
	if (last <= 2) size += 2;

	if (!*tmp) {
		if (Xrewind(fp) < 0) {
			VOID_C Xfclose(fp);
			return(NULL);
		}
		i = pop_genuidl(tmp, sizeof(tmp),
			fp, (md5_fread_t)Xfread, t, path);
		if (i < 0) {
			VOID_C Xfclose(fp);
			return(NULL);
		}
	}
	VOID_C Xfclose(fp);

	len = strlen(tmp);
	for (cp = tmp; cp < &(tmp[len]); cp++) {
		if (!Xisspace(*cp)) continue;
		for (i = 1; &(cp[i]) < &(tmp[len]); i++)
			if (!Xisspace(cp[i])) break;
		memmove(cp, &(cp[i]), &(tmp[len]) - &(cp[i]) + 1);
		len -= i;
	}

	if (lenp) *lenp = size;

	return(Xstrdup(tmp));
}

static int NEAR pop_addreport(s)
CONST char *s;
{
	char **list;
	ALLOC_T len;

	if (!s) return(0);
	len = strlen(s);
	if (!pop_report) {
		list = list_init();
		if (!list) return(-1);
		pop_report = (popreport_t *)Xmalloc(sizeof(popreport_t));
		if (!pop_report) {
			list_free(list);
			return(-1);
		}
		pop_report -> list = list;
		pop_report -> ptr = pop_report -> max = 0;
		pop_report -> size = (ALLOC_T)0;
	}
	pop_report -> list =
		list_add(pop_report -> list, pop_report -> max, s, len);
	if (!(pop_report -> list)) return(-1);

	(pop_report -> max)++;
	pop_report -> size += len + 1 + 1;

	return(0);
}

static int NEAR pop_genreport(list, max)
pop3_t *list;
int max;
{
	char *cp, tmp[POP_MAXBUF];
	ALLOC_T total;
	int i, n, len;

	pop_freereport(pop_report);
	pop_report = NULL;

	if (pop_addreport("To: Undisclosed-Recipients:;") < 0) return(-1);
	n = Xsnprintf(tmp, sizeof(tmp),
		"From: postmaster@%s", (mydomain) ? mydomain : "localhost");
	if (n < 0 || pop_addreport(tmp) < 0) return(-1);
	if (pop_addreport("Subject: Report of mail delivery") < 0) return(-1);
	memcpy(tmp, DATESTR, strsize(DATESTR));
	n = time_getdatestr(&(tmp[strsize(DATESTR)]),
		sizeof(tmp) - strsize(DATESTR));
	if (n < 0 || pop_addreport(tmp) < 0) return(-1);

	if (pop_addreport(nullstr) < 0) return(-1);

	total = (ALLOC_T)0;
	if (max <= 0) {
		if (pop_addreport("No mail to be sent.") < 0) return(-1);
	}
	else for (i = 0; i < max; i++) {
		n = Xsnprintf(tmp, sizeof(tmp),
			"Message[%04d]: path=%s/%d, size=%d",
			i + 1, list[i].folder, list[i].file, list[i].size);
		if (n < 0 || pop_addreport(tmp) < 0) return(-1);
		total += list[i].size;
	}

	if (pop_addreport(nullstr) < 0) return(-1);
	n = Xsnprintf(tmp, sizeof(tmp),
		"Total: %d mail(s), size=%d", max, total);
	if (n < 0 || pop_addreport(tmp) < 0) return(-1);
	if (pop_addreport(nullstr) < 0 || pop_addreport("--") < 0) return(-1);
	cp = conf_getversion(&len);
	n = Xsnprintf(tmp, sizeof(tmp), "%s Ver. %-.*s", myname, len, cp);
	if (n < 0 || pop_addreport(tmp) < 0) return(-1);

	return(0);
}

static int NEAR pop_readreport(buf, size, rp)
char *buf;
ALLOC_T size;
popreport_t *rp;
{
	ALLOC_T len;

	if (!rp || rp -> ptr >= rp -> max || !(rp -> list)) return(0);
	len = strlen(rp -> list[rp -> ptr]);
	if (len > size) len = size;
	memcpy(buf, rp -> list[rp -> ptr], len);
	(rp -> ptr)++;

	return((int)len);
}

int pop_fetch(VOID_A)
{
	pop3_t *list;
	char *uidl, tmp[POP_MAXBUF];
	ALLOC_T size;
	int i, j, n, seq, *msgs, argc;

	if (pop_status != POP_STAT_TRANS) {
		ERROR0(("Not logined"));
		return(-1);
	}
	if (pop_msglist) return(0);

	if (mh_inc() < 0) return(-1);
	if (pop_getfolders() < 0) return(-1);

	if (!(list = pop_initlist())) return(-1);
	argc = 0;
	for (i = 0; pop_folders[i]; i++) {
		seq = mh_getseq(pop_folders[i]);
		if (seq < 0) seq = 0;
		if ((n = dir_getlist(pop_folders[i], &msgs)) < 0) continue;

		for (j = 0; j < n; j++) {
			if (msgs[j] <= seq) continue;
			uidl = pop_getuidl(pop_folders[i], msgs[j], &size);
			if (!uidl) continue;
			list = pop_addlist(list, argc++,
				pop_folders[i], msgs[j], size, uidl);
			if (!list) {
				Xfree(msgs);
				return(-1);
			}
		}
		Xfree(msgs);
	}

	n = 0;
	switch (reportmail) {
		case 1:
			if (!argc) n++;
			break;
		case 2:
			if (argc) n++;
			break;
		case 3:
			n++;
			break;
		default:
			break;
	}
	if (!n) /*EMPTY*/;
	else if (pop_genreport(list, argc) < 0) {
		pop_freereport(pop_report);
		pop_report = NULL;
	}
	else {
		pop_report -> ptr = 0;
		n = pop_genuidl(tmp, sizeof(tmp),
			pop_report, (md5_fread_t)pop_readreport,
			Xtime(NULL), "(reportmail)");
		if (n < 0) return(0);
		list = pop_addlist(list, argc++,
			nullstr, 0, pop_report -> size, Xstrdup(tmp));
	}

	pop_msglist = list;
	pop_maxmsg = argc;

	return(0);
}

int pop_gettotal(sizep)
ALLOC_T *sizep;
{
	ALLOC_T size;
	int i, n;

	if (pop_fetch() < 0) return(-1);
	n = 0;
	size = (ALLOC_T)0;
	for (i = 0; i < pop_maxmsg; i++) {
		if (pop_msglist[i].flags & POP_DELETED) continue;
		n++;
		size += pop_msglist[i].size;
	}

	if (sizep) *sizep = size;

	return(n);
}

int pop_getmsgno(s)
CONST char *s;
{
	int n;

	if (!s || !Xisdigit(*s) || (n = atoi(s)) <= 0) {
		ERROR0(("%s: Invalid message number", s));
		return(-1);
	}

	if (pop_fetch() < 0) return(-1);
	if (n > pop_maxmsg) {
		ERROR0(("%d: Too large message number (>%d)",
			n, pop_maxmsg));
		return(-1);
	}
	if (pop_msglist[n - 1].flags & POP_DELETED) {
		ERROR0(("%d: Message is already marked to be deleted", n));
		return(-1);
	}

	return(n - 1);
}

XFILE *pop_openmsg(n)
int n;
{
	char path[MAXPATHLEN];

	if (!*(pop_msglist[n].folder)) {
		if (pop_report) pop_report -> ptr = 0;
		return((XFILE *)nullstr);
	}

	n = mh_genpath(path, sizeof(path),
		pop_msglist[n].folder, pop_msglist[n].file);
	if (n < 0) return(NULL);

	return(Xfopen(path, "r", 0, 0));
}

char *pop_readmsg(fp, lenp)
XFILE *fp;
ALLOC_T *lenp;
{
	CONST char *cp;
	ALLOC_T len;

	if (fp != (XFILE *)nullstr) return(Xfgets(fp, lenp, XF_TRUNC));

	if (!pop_report
	|| pop_report -> ptr >= pop_report -> max || !(pop_report -> list))
		return(NULL);
	cp = pop_report -> list[pop_report -> ptr];
	len = strlen(cp);
	(pop_report -> ptr)++;
	if (lenp) *lenp = len;

	return(Xstrndup(cp, len));
}

VOID pop_closemsg(fp)
XFILE *fp;
{
	if (fp != (XFILE *)nullstr) VOID_C Xfclose(fp);
}

int pop_update(VOID_A)
{
	CONST char *last;
	char **argv, buf[POP_MAXBUF];
	int i, n, max, argc;

	if (!pop_msglist || pop_status != POP_STAT_UPDATE) return(0);

	last = NULL;
	max = -1;
	if (!(argv = list_init())) return(-1);
	argc = 0;
	for (i = 0; i < pop_maxmsg; i++) {
		if (!(pop_msglist[i].flags & POP_DELETED)) continue;
		if (!*(pop_msglist[i].folder)) continue;
		if (last != pop_msglist[i].folder) {
			VOID_C mh_setseq(last, max);
			VOID_C mh_rmm(last, argv);
			last = pop_msglist[i].folder;
			max = -1;
			list_free(argv);
			if (!(argv = list_init())) return(-1);
			argc = 0;
		}

		if (max < pop_msglist[i].file) max = pop_msglist[i].file;
		n = Xsnprintf(buf, sizeof(buf), "%d", pop_msglist[i].file);
		if (!(argv = list_add(argv, argc++, buf, n))) return(-1);
	}
	VOID_C mh_setseq(last, max);
	VOID_C mh_rmm(last, argv);
	list_free(argv);

	return(0);
}
