/*
 *	time.c
 *
 *	UNIX time handling
 */

#include "mhpopd.h"

static CONST char *time_weekstr[] = {
	"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat",
};
#define	WEEKSTRSIZ		arraysize(time_weekstr)

static CONST char *time_monthstr[] = {
	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec",
};
#define	MONTHSTRSIZ		arraysize(time_monthstr)

#ifdef	NOTMGMTOFF
static time_t NEAR Xtimegm __P_((CONST struct tm *));
#endif


time_t Xtime(tp)
time_t *tp;
{
	struct timeval t_val;
	struct timezone tz;
	time_t t;

	VOID_C Xgettimeofday(&t_val, &tz);
	t = (time_t)(t_val.tv_sec);
	if (tp) *tp = t;

	return(t);
}

#ifdef	NOTMGMTOFF
static int NEAR getmaxday(mon, year)
int mon, year;
{
	int mday;

	switch (mon) {
		case 2:
			mday = 28;
			if (!(year % 4) && ((year % 100) || !(year % 400)))
				mday++;
			break;
		case 4:
		case 6:
		case 9:
		case 11:
			mday = 30;
			break;
		default:
			mday = 31;
			break;
	}

	return(mday);
}

static time_t NEAR Xtimegm(tm)
CONST struct tm *tm;
{
	time_t t;
	int i, y;

	if (tm -> tm_year < 0) return((time_t)-1);
	y = (tm -> tm_year < 1900) ? tm -> tm_year + 1900 : tm -> tm_year;
	if (tm -> tm_mon < 0 || tm -> tm_mon > 11) return((time_t)-1);
	if (tm -> tm_mday < 1
	|| tm -> tm_mday > getmaxday(tm -> tm_mon + 1, y))
		return((time_t)-1);
	if (tm -> tm_hour < 0 || tm -> tm_hour > 23) return((time_t)-1);
	if (tm -> tm_min < 0 || tm -> tm_min > 59) return((time_t)-1);
	if (tm -> tm_sec < 0 || tm -> tm_sec > 60) return((time_t)-1);

	t = ((long)y - 1970) * 365;
	t += ((y - 1 - 1968) / 4)
		- ((y - 1 - 1900) / 100)
		+ ((y - 1 - 1600) / 400);
	for (i = 1; i < tm -> tm_mon + 1; i++) t += getmaxday(i, y);
	t += tm -> tm_mday - 1;
	t *= 60L * 60L * 24L;
	t += ((long)(tm -> tm_hour) * 60L + tm -> tm_min) * 60L + tm -> tm_sec;

	return(t);
}
#endif	/* NOTMGMTOFF */

int time_getdatestr(buf, size)
char *buf;
ALLOC_T size;
{
	struct tm *tm;
	time_t t;
	long tz;
	int n, c;

	t = Xtime(NULL);
	tm = localtime(&t);
#ifndef	NOTMGMTOFF
	tz = tm -> tm_gmtoff;
#else
	tz = (long)Xtimegm(tm) - (long)t;
#endif
	tz /= 60L;

	if (tz >= 0L) c = '+';
	else {
		c = '-';
		tz = -tz;
	}

	n = Xsnprintf(buf, size,
		"%s, %u %s %u %<02u:%<02u:%<02u %c%<02lu%<02lu",
		time_weekstr[tm -> tm_wday % WEEKSTRSIZ],
		tm -> tm_mday,
		time_monthstr[tm -> tm_mon % MONTHSTRSIZ],
		tm -> tm_year + 1900,
		tm -> tm_hour, tm -> tm_min, tm -> tm_sec,
		c, tz / 60L, tz % 60L);

	return(n);
}
